%%original.. uses matrix operations and solves for the cH using vector

%--------------------------------------------------------------------------
%  Calculate Chemical Equilibrium
%  Using the output of EquilibriumPolynomials, i.e. P, Q etc this function
%  a) computes C_H = [H+].
%  b) knowing C_H and LMat, it computes g_iz
%  Returns c_iz, c_h, g_iz 
%--------------------------------------------------------------------------
function [cizCube,cH,cHCubePower,gizCube]=CalculateEquilibrium(FirstTimeFlag,...
    cH,PCube,QMat,PPrimeCube,QPrimeMat,LCube,cMat)
global met2lit Ngrid Nspecies EquiPLength PolDeg

% EQUILIBRIUM
if FirstTimeFlag==1  % Solve for pH the first time
    %----------------------------------------------------------------------
    %----
    % Setup constant matrices -  THIS PART RUNS ONLY ONCE PER SIMULATION
    %--------------------------------------------------------------------------
    % Get equilibrium polynomials

    for ij=1:size(cMat,1) %iterate over all grids
        cTot=cMat(ij,:)/met2lit;   % convert back to mol/liter
        cTotRep=cTot'*ones(1,size(PCube(:,:,ij),2));
        P=sum(cTotRep.*PCube(:,:,ij),1);

        Poly=zeros(1,EquiPLength);

        Poly(1:size(P,2))=Poly(1:size(P,2))+P;
        Poly(1:size(QMat,2))=Poly(1:size(QMat,2))+QMat(ij,:); %from QMat
        Poly=fliplr(Poly);

        roo=roots(Poly);
        roo=roo(imag(roo)==0);
        cH(ij)=roo(roo>0);          % NOTE THAT cH is in mol/lit
    end %for ij
else
    % Solve for pH using Newton Raphson
    count=0;        cHPrev=ones(1,Ngrid);
    %%%            while max(abs(cHPrev-cH)) > max([abs(cH),abs(cHPrev)])*1E-3
%     while norm((cHPrev-cH)./max([abs(cH);abs(cHPrev)],[],1),inf) > 1E-6
%         count=count+1;
%         cHPrev=cH;
%         EquicHPolMat=[ones(1,Ngrid);cumprod(ones(EquiPLength-1,1)*cH,1)];
%         %% this makes a makes a matrix of powers of cH which is multiplied 
%         %by the companian matrix
%         fcH=sum(cMat'.*(PMat*EquicHPolMat),1)/met2lit+Q*EquicHPolMat;
%         fPrimecH=sum(cMat'.*(PPrimeMat*EquicHPolMat),1)/met2lit+QPrime*EquicHPolMat;
%         cH=cH-fcH./fPrimecH;
% 
%         if count>5
%             count;
%         end
%         if count>100
%             disp('Too many iterations on cH. Returning');
%             return;
%         end
% 
%     end

%can speed up, this using multiprod

fcH=zeros(1,Ngrid);
fPrimecH=zeros(1,Ngrid);
    while norm((cHPrev-cH)./max([abs(cH);abs(cHPrev)],[],1),inf) > 1E-6
        count=count+1;
        cHPrev=cH;
        %EquicHPolMat=[ones(1,Ngrid);cumprod(ones(EquiPLength-1,1)*cH,1)];
        for k=1:Ngrid
%        EquicHPolMat=[1;cumprod(ones(EquiPLength-1,1)*cH(k),1)];
        EquicHPolMat=cH(k).^[0:1:EquiPLength-1]'; %[1;cumprod(ones(EquiPLength-1,1)*cH(k),1)];
        %% this makes a makes a matrix of powers of cH which is multiplied 
        %by the companian matrix
        fcH(1,k)=sum(cMat(k,:)'.*(PCube(:,:,k)*EquicHPolMat),1)/met2lit+QMat(k,:)*EquicHPolMat;
        fPrimecH(1,k)=sum(cMat(k,:)'.*(PPrimeCube(:,:,k)*EquicHPolMat),1)/met2lit+QPrimeMat(k,:)*EquicHPolMat;
        end

        cH=cH-fcH./fPrimecH;
        
        
        if count>5
            count;
        end
        if count>1000
            disp('Too many iterations on cH. Returning');
            return;
        end
   
    end
  
 

  %===testing multiprod for equilibrium calculation
  
%       while norm((cHPrev-cH)./max([abs(cH);abs(cHPrev)],[],1),inf) > 1E-6
%         count=count+1;
%         cHPrev=cH;
%         EquicHPolMat=[ones(1,Ngrid);cumprod(ones(EquiPLength-1,1)*cH,1)];
%         TempPEMult1=multiprod(PCube, EquicHPolMat, [1 2], [1]);
%         TempPEMult2=multiprod(PPrimeCube, EquicHPolMat, [1 2], [1]);
%                 %% this makes a makes a matrix of powers of cH which is multiplied 
%         %by the companian matrix
%         for k=1:Ngrid
%         fcH=sum(cMat(k,:)'.*TempPEMult1(:,:,k),1)/met2lit +QMat(k,:)*EquicHPolMat;
%         fPrimecH=sum(cMat(k,:)'.*TempPEMult2(:,:,k),1)/met2lit +QPrimeMat(k,:)*EquicHPolMat;
%         cH(k)=cH(k)-fcH/fPrimecH;
%         end
%         %fcH=fcH+QMat*EquicHPolMat;
%         %fPrimecH=fPrimecH+QPrimeMat*EquicHPolMat;
%         %cH=cH-fcH./fPrimecH;
%    end
%         if count>5
%             count;
%         end
%         if count>1000
%             disp('Too many iterations on cH. Returning');
%             return;
%         end
  
  %======= testing for mulitprod for equilibrium calculation ends here

   
  
end %if first time
%cH=cH*met2lit;
cHPolMat=[ones(1,Ngrid);cumprod(ones(PolDeg-1,1)*cH,1)];

Temp=zeros(Nspecies,Ngrid);
TempL=permute(LCube,[1,3,2]); %8x2x150
Temp=multiprod(TempL, cHPolMat, [1 2], [1]); %faster multiplication
%========testing
%for k=1:1:Ngrid
%    Temp(:,k)=TempL(:,:,k)*cHPolMat(:,k);
%end
%=====testing

M1Cube=FastRepmatPages(cMat'./Temp,PolDeg);
% M1Cube=FastRepmatPages(cMat'./(sparse(LMat)*cHPolMat),PolDeg);
cHCubePower=FastRepmatRows(permute(cHPolMat,[3,2,1]),Nspecies);
cizCube=LCube.*cHCubePower.*M1Cube; %equation 5 in J. Chroma A
% %LCube should be properly computed
gizCube=LCube.*cHCubePower.*FastRepmatPages(1./Temp,PolDeg);

