%----------------------------------------------------------------------
% Calculates Ionic Effects. 
% a) Returns same values as CalculateEquilibrium()
% b) Inputs: ARG, KaList, zArrangedList
% c) Called within CalcFLux()
% d) This function calls CalculateEquilibrium() and
% RecomputeEquilibriumPolynomials() to iterate for ionic effects

%call CalculateEquilibrium() prior to call this


%updates: Feb 27, 2009
%corrected bug in definition of NewKaListCube{k}{i}, pKaFactor
%----------------------------------------------------------------------
function [cizCube,cH,cHCubePower,gizCube, IonicStrength, LCube, Kw_new]= ...
    CalculateIonicEffects(IonicEffectFlag, cH,LCube, cMat, ValCube, cizCube, zListArranged, KaListCube, cHCubePower, gizCube)
global Ngrid Nspecies met2lit Kw PolDeg

 Kw_new=Kw*ones(1,Ngrid);
if (IonicEffectFlag==0) 
    Temp=sum((LCube.*cHCubePower),3);
    gizCube=LCube.*cHCubePower.*FastRepmatPages(1./Temp,PolDeg); 
    %I know this is redundant.. let it be here for a while
    IonicStrength=zeros(1,Ngrid);
    return;
end



% see how zListArranged, KaList can be taken as input in CalcFlux(), as this
% function is called in CalcFlux()


convergence=false;
count=0;

while ~convergence
    
    if(count>40)
        disp('no convergence in Ionic Effects');
        break;
    end
       count=count+1;
        cHPrev=cH;
%START LOOP
        %step 2: Compute I=0.5 sum_i sum_z c_{iz}*z_{iz}^2
        IonicStrength=0.5*(sum(sum(ValCube.^2.*cizCube,3),1)/met2lit+cH+Kw_new./cH);
        %cizCube should be computed properly
 
        % see if you can iterate over the grid points
        %but will have to changed the way LCube, gizCube etc needs to be 
        %computed
        
%step 3: Using I, zArrangedList and KaList compute delta_pKa_Cube
%step 4: NewKaListCube = KaListCube + delta_pKa_Cube
%pKaFactor = 0.50850*(sqrt(IonicStrength)./(1+sqrt(IonicStrength))-0.3*IonicStrength);
pKaFactor = -getLogActivity(IonicStrength);
NewKaListCube=KaListCube; %initialize so that it doesn't grow inside the loop

for i=1:Nspecies
zListHeavy{i}=zListArranged{i}-Myheaviside(zListArranged{i}-0.1);    
%precomputing these so that it does not go into loop over grid points
end


for k=1:Ngrid
    for i=1:Nspecies
%     NewKaListCube{k}{i}=NewKaListCube{k}{i}.*10.^(-pKaFactor(k)*2.0*(zListArranged{i}-...
%         heaviside(zListArranged{i}-0.1)));
  NewKaListCube{k}{i}=NewKaListCube{k}{i}.*10.^(-pKaFactor(k)*2.0*zListHeavy{i});
    %i have taken abs because for base, delta_pKb=delta_pKa
    end
end
Kw_new=Kw*10.^(2*pKaFactor); %Kw/gamma^2 this goes into ReComputeEquilibriumPolynomials
%Kw_new=Kw;
%step 5: Call RecomputeEquilibriumPolynomials using "NewKaList" to get new LCube
LCube=RecomputeEquilibriumPolynomials(zListArranged, NewKaListCube);
%step 6: Call LzCalcEquilibrium()
[cizCube,cH,cHCubePower,gizCube]=LzCalcEquilibrium(cH,LCube,cMat, ValCube, Kw_new); 

%step 7: Check for convergence
%convergence of cH values
if (norm((cHPrev-cH)./max([abs(cH);abs(cHPrev)],[],1),inf) < 1E-6)
    convergence=true;
    break;
end



%GO UP, if NO congergence, else END of LOOK. Return Values
end
%  disp('iteration took counts = ');
%  disp(count);

%step 8: After convergence, compute new IonicStrength 
IonicStrength=0.5*sum(sum(ValCube.^2.*cizCube,3),1)/met2lit+0.5*(cH+Kw_new./cH); 
%step 9: Compute New muCube and using that compute DCube
