%%original.. uses matrix operations and solves for the cH using vector
%this function uses iterative method on eqn (6) of J. Chroma A paper.
%does not compute the equilibrium polynomials
%--------------------------------------------------------------------------
%  Calculate Chemical Equilibrium
%  Using the output of EquilibriumPolynomials, i.e. P, Q etc this function
%  a) computes C_H = [H+].
%  b) knowing C_H and LMat, it computes g_iz
%  Returns c_iz, c_h, g_iz 
%--------------------------------------------------------------------------
function [cizCube,cH,cHCubePower,gizCube]=LzCalcEquilibrium(cH,LCube,cMat, ValCube, Kw_new)
global Ngrid Nspecies PolDeg met2lit

% options = optimset('Display','iter','TolFun',1e-8);
% [cH, fval, exitflag] = fsolve(@(cH) MyLzFuncNEW(cH,LCube,cMat, ValCube), cH, options);
% %look at the case where function does not converge
cMat=cMat/met2lit;
cHPrev=ones(1,Ngrid);
count=0;



while norm((cHPrev-cH)./max([abs(cH);abs(cHPrev)],[],1),inf) > 1E-6
  count=count+1;
    cHPrev=cH;
    cH=cH-MyLzFuncNEW(cH,LCube,cMat, ValCube, Kw_new);
            if count>200
            disp('Too many iterations on cH. Returning');
            return;
            end
end
cMat=cMat*met2lit;
%fprintf('no. of iterations = %g \n', count);
% else
%     disp('initial condition is already the solution');
%     fprintf('Max absolute Residue = %g \n', max(abs(F)));
% end


cHPolMat=[ones(1,Ngrid);cumprod(ones(PolDeg-1,1)*cH,1)];
cHCubePower=FastRepmatRows(permute(cHPolMat,[3,2,1]),Nspecies);
Temp=sum((LCube.*cHCubePower),3);
M1Cube=FastRepmatPages(cMat'./Temp,PolDeg);
cizCube=LCube.*cHCubePower.*M1Cube; %equation 5 in J. Chroma A
gizCube=LCube.*cHCubePower.*FastRepmatPages(1./Temp,PolDeg);

