%%original.. uses matrix operations and solves for the cH using vector
%this function uses iterative method on eqn (6) of J. Chroma A paper.
%does not compute the equilibrium polynomials
%--------------------------------------------------------------------------
%  Calculate Chemical Equilibrium
%  Using the output of EquilibriumPolynomials, i.e. P, Q etc this function
%  a) computes C_H = [H+].
%  b) knowing C_H and LMat, it computes g_iz
%  Returns c_iz, c_h, g_iz 
%--------------------------------------------------------------------------
function F=MyLzFuncNEW(cH,LCube,cMat, ValCube, Kw_new)
global Ngrid Nspecies PolDeg Kw met2lit


%step 1: from the vector cH and LCube, construct cizCube
% step 2
% loop over grid points k=1:Ngrid
%     loop over species j=1:Nspecies
%         zList=zListArranged{j};
%         nj=min(zList);    pj=max(zList);
%     
%                     loop z=zList
%                      RHS(k)=RHS(k)-z*cizcube(j,k,z-nj+1);    
%                     loop over z ends
%       loop of species ends
% loop over grid points end
% cH=RHS=RHS+Kw./cH
%Step 3: Repeat step 2 again.. till you converge

cHPolMat=[ones(1,Ngrid);cumprod(ones(PolDeg-1,1)*cH,1)];
cHCubePower=FastRepmatRows(permute(cHPolMat,[3,2,1]),Nspecies);
%Temp=multiprod(TempL, cHPolMat, [1 2], [1]); %faster multiplication
Temp=sum((LCube.*cHCubePower),3);
M1Cube=FastRepmatPages(cMat'./Temp,PolDeg);
TempCube=FastRepmatPages(Temp,PolDeg);
cizCube=LCube.*cHCubePower.*M1Cube; %equation 5 in J. Chroma A
        
%M1Cube is denominator of eqn 5

%RHS_den=sum(sum((cizCube.*ValCube.^2-cizCube.*ValCube.^2.*LCube.*cHCubePower./TempCube),3),1);
RHS_den=sum(sum((cizCube.*ValCube.^2-cizCube.*ValCube.^2.*LCube.*cHCubePower./TempCube),3),1);
RHS_num=sum(sum((cizCube.*ValCube),3),1);
F_num=RHS_num+cH-Kw_new./cH;
F_den=RHS_den./cH+1+Kw_new./(cH.^2);
F=F_num./F_den; %for Newton raphson



 
   
  


