%this function computes the mobility based on Onsager-Fuoss theory.
%the algo is:
%a) extract the non zero entries of cizCube, ValCube, muCube using find
%function.. (later give this as input)
%construct: omega, 
%Follow the following for each grid point....
%b) once you have row matrices of mobility, valence and concentrations.
%construct: mu i.e. ratio c*z^2/IonicStrength
%c) now construct matrix H
%d) using H construct vectors r0, r1, ... , r5
%e) compute required factors for applying Onsager-Fuoss correction
%Repeat this for all grid points 

%f) assemble back the matrices using the result of find
function muIonicCube = OnsagerFuoss(IonicEffectFlag, ValCube, cizCube, muCube)
global Nspecies PolDeg Ngrid F

muIonicCube=F*muCube;
if (IonicEffectFlag==0)
return;

elseif (IonicEffectFlag==1)

%extract the non zero elements
[X, Y]=find(ValCube(:,1,:)~=0); %need to do this for one matrix only
                           %same for all grid points
    
%muCube is actually Omega in Onsage-Fuoss paper and is same for 
%all grid points
c=[0.2929 -0.3536 0.0884 -0.0442 0.0276 -0.0193];
%coefficients in onsager-fuoss paper
for i=1:1:length(X)
omega(1,i)=muCube(X(i),1,Y(i));
z(1,i)=ValCube(X(i),1,Y(i));
end
mob=omega.*abs(z);
XLen=length(X);
mob_new=zeros(1,XLen);
conc=zeros(1,length(X)); %concentrations

II=eye(XLen,XLen);

for k=1:1:Ngrid
        for i=1:1:XLen
        conc(1,i)=cizCube(X(i),k,Y(i));
        end
    %extract concentrations
    
%now that we have concentrations at k_th grid point
%make matrices mu 
IonicStr=sum(conc.*z.^2);
mu=conc.*z.^2./IonicStr; %total potential

%now make matrix H
for j=1:XLen
    for i=1:XLen
   h(j,i)=mu(i)*omega(i)/(omega(i)+omega(j));
    end
end
    
 d=sum(h,2);
 d1=diag(d);
 h=h+d1; %makes matrix H.. adds the delta_(i,j) terms
 
 B=2*h-II;
 
 r(:,1)=(z-sum(z.*mu)/sum(mu.*abs(z)./mob)*(abs(z)./mob))'; %check for absolute signs 
 for i=2:6                                        
 r(:,i)=B*r(:,i-1);
 end
 factor=c*r'; %factors computed in table 3, page 2755 of Onsager-Fuoss
 
 %Now compute the ionic strength dependence
 mob_new=F*omega-(F*0.78420*z.*factor.*omega+31.410e-9).*sqrt(IonicStr/2000)./(1+1.5*sqrt(IonicStr/2000));

%Robinson-Stokes, just checking dont use this. 
%mob_new=F*omega-(F*0.2297*z.*omega+31.410e-9).*sqrt(IonicStr/2000)./(1+1.5*sqrt(IonicStr/2000));
%Assemble matrix back
 
for i=1:1:XLen
muIonicCube(X(i),k,Y(i))=mob_new(1,i);
end   

end
end



