%--------------------------------------------------------------------------
%  Recompute Equilibrium polonomials
%  Will be called in a new function called IonicStrengthEffects()
%  Instead of EquilibriumPolynomials() this will use inputs as KaMat etc, 
%  As they are already in ordered form, instead of INP
%--------------------------------------------------------------------------

%updated Feb 27, 2009: Included Kw_new to include ionic strengths

%function [PMat,PPrimeMat,Q,QPrime,LMat]=RecomputeEquilibriumPolynomials(zListArranged, KaListCube)

function LCube=RecomputeEquilibriumPolynomials(zListArranged, KaListCube)
global Nspecies Ngrid PolDeg

LCube=zeros(Nspecies, Ngrid, PolDeg);

for k=1:1:Ngrid
    for j=1:1:Nspecies
        zList=zListArranged{j};
        KaList=KaListCube{k}{j};
         nj=min(zList);    %pj=max(zList);
  
            for z=zList
                if z<0
                    LCube(j,k,z-nj+1)=prod(KaList(z-nj+1:-nj));
                   elseif z>0
                    LCube(j,k,z-nj+1)=1/prod(KaList(-nj+2:z-nj+1));
                   elseif z==0
                    LCube(j,k,z-nj+1)=1;
                end %if
            end % for z

   end %for j
end %for loop k 


