%% Evaluates fully ionized mobilities and pKs at the specified operating temperature
% written by Anita Rogacs 
% November 2012 

% Mobilities are corrected using:
% (1)  empricially derived solvation shell variation from Nightingale data 
% (2)  viscosity change
%  pK(s) correction
% using thermodynamic properties specified at room temperature 
%  and evulates new pK at operating temperatures  using(Clark-Glew when both deltaH and deltaCp
%  available, and von't hoff when only deltaH is available)

% Output: [y:adjusted table of ions, mobility of H+, mob of OH-, Water
% dissoc.const]
function [y, mH, mOH, Kw]=AdjustReshape(InputTable, T)
global R RefTemp pKaWB DelH_W DelCp_W

mH       = 362E-9;   % Mobility of Hydronium   % [m^2/s*V]
mOH    = 205E-9;   % Mobility of Hydroxide   % [m^2/s*V]
pKaW  = pKaWB - (DelH_W/2.303/R)*( 1/RefTemp - 1/T ) - (DelCp_W/2.303/R)*(RefTemp/T-1+log(T/RefTemp));
Kw      = 10^(-pKaW);

x = test_func(T);

mH   = mH*x(3)/x(4);
mOH = mOH*x(3)/x(4);

% Evaluate fully ionized  mobility 
stct=2;
for ij=1:1:size(InputTable,1); %ij th row of InputTable
    i_mob=2;  i_pka=3; i_dH=4; i_dCp=5;
    temp_array=str2num(InputTable{ij,stct});    % contains charge, mobility, pK, deltah and deltaCp
    qq = size(temp_array,2)/5;
    fin_array = zeros(1,3*qq);
    temp_name = (InputTable{ij, 1}); % contains the name of the species
    col = 0;
        for ijk = 2:5:size(temp_array,2)
            col = round(ijk/5)*3+2;
            fin_array(col-1)=temp_array(ijk-1);  %populate final array with valence
            R_sol= Nightingale_data(T,temp_array(ijk-1),temp_name);% solvation correction (temp_array(ijk-1):valence)
         
            if 1==isempty(R_sol);
                fin_array(col)= x(3)/x(4)*(temp_array(ijk));  % viscosity corrected mobility, x(3):visc at RefTemp, x(4):visc at T
            else
               fin_array(col)=R_sol*x(3)/x(4)*(temp_array(ijk));  %viscosity, and solvation adjusted mobility      
            end
        end
       
   % evlaute change in pK for each ion
    clear ijk col
    indexPK = 4:5:size(temp_array,2);
    delPKA = zeros(1,qq);
         for i = 1:qq
           ijk = indexPK(i);
           delPKA(i) = - (temp_array(ijk)/2.303/R)*( 1/RefTemp - 1/T ) - (temp_array(ijk+1)/2.303/R)*(RefTemp/T-1+log(T/RefTemp));  %change in pKa due to temperature change
         end
    clear ijk i
    
   % populate matrix with new pK(s)
   IndexNewPK = 3:5:size(temp_array,2);
        for i = 1:qq
             ijk = IndexNewPK(i);
            fin_array(i*3) = temp_array(ijk)+ delPKA(i);     
        end
         
 InputTable{ij,stct}=num2str(fin_array);
end

y = InputTable;