function Cb=BufferingCapacity(CorrectedTable, pH, Tbc)
	% BUFFERING_CAPACITY finds the buffering capacity of a solution. 
	%	This function generates a solution to the buffering
	%	capacity by finding the derivative of the pH with respect to
	%	the addition of an acid.
    IonicEffectFlag = 1;
    
    mH     = 362E-9;   % Mobility of Hydronium   % [m^2/s*V]
    mOH    = 205E-9;   % Mobility of Hydroxide   % [m^2/s*V]
    Kw     = 10^-14;
    
	% Find the smallest concentration in the solution. 
	% Add an acid insult 
    
    conc = [CorrectedTable{:,3}];
	c=0.001*max(conc(conc~=0));
    Rows=size(conc,2)+1;
    
    for ij=1:Rows-1
        for i=1:3
         InputTableNew{ij,i}=CorrectedTable{ij,i};  %update mobilities
        end
    end
    
     InputTableNew{Rows,1}='ACID';
     InputTableNew{Rows,2}='-1    7.91e-08      -2';
     InputTableNew{Rows,3}=c;
     
     [pH_new]=FuncSteadyStateSolver(InputTableNew, Tbc, IonicEffectFlag, mH, mOH, Kw);
     
	% Find the slope of the pH. 
	Cb=abs(c/(pH-pH_new));
end
