%updates: Feb 27, 2009: coorected value for muMat
%Kw_new is now computed based on the ionic strength
function [pH,SigVec,muMat, cH, muIonicCube, LCube, Kw_new, cizCube, muH_new, muOH_new, alphaMat, ValCube] = CalculateSpatialPropertiesSteady(INP,N,FirstTimeFlag,cMat, Temp, IonicEffectFlag, muH, muOH, Kw)
global F Rmu   met2lit Nspecies PolDeg Ngrid EquiPLength
%Kw muH muOH
% disp('CalcSpatial')
% Temp
%cMat=cMat/met2lit;
Nspecies=size(INP,1);
%[PMat,PPrimeMat,Q,QPrime,LMat,ValMat,muMat,KaMat,DMat]=EquilibriumPolynomials(INP);

Ngrid=size(cMat,1); %grid size, global variable

[PCube,PPrimeCube,QMat,QPrimeMat,LCube,ValCube,muCube,DCube,...
    zListArranged, KaListCube]=EquilibriumPolynomials(INP, Temp, Kw);

EquiPLength=max(size(PCube,2),size(QMat,2));
PolDeg=size(LCube,3); % Polynomial degree

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
cH=zeros(1,size(cMat,1));

FirstTimeFlag=1;
[cizCube,cH,cHCubePower,gizCube]=CalculateEquilibrium(FirstTimeFlag,...
    cH,PCube,QMat,PPrimeCube,QPrimeMat,LCube,cMat);


%For effects of ionic strength on equilibrium
    [cizCube,cH,cHCubePower,gizCube, IonicStrength, LCube, Kw_new]= ...
    CalculateIonicEffects(IonicEffectFlag, cH,LCube,cMat, ValCube, cizCube, zListArranged, KaListCube, cHCubePower, gizCube, Temp, Kw);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%Now that we have Ionic strength, we can calculate the new MobilityCube
IonicStrength=IonicStrength*IonicEffectFlag;
ICube=repmat(IonicStrength, [Nspecies,1,PolDeg]);
  
muIonicCube = OnsagerFuoss(IonicEffectFlag, ValCube, cizCube, muCube, Temp);  
muMat=sum(ValCube.*muIonicCube.*gizCube,3)';  
%%%use correct units
%%%I have used value 4A = atomic radii, but actually its depends on the
%%%problem

alphaMat=F*sum(ValCube.^2.*muIonicCube.*gizCube,3)';
muH_new=muH;
muOH_new=muOH;
Kw_new=Kw*10.^(-2*getLogActivity(IonicStrength*IonicEffectFlag,Temp)); 

%compute new Kw because of change in ionic strength
SigVec = sum(alphaMat'.*cMat',1)' + F^2*(muH_new.*cH*met2lit+muOH_new.*(Kw_new./cH)*met2lit)';

if IonicEffectFlag==1
pH=-log10(cH.*10.^getLogActivity(IonicStrength,Temp));
else 
pH=-log10(cH);
end


