function [pH,SigVec,muMat, cMat, cH, cizCube, ValCube]=FuncSteadyStateSolver(InputTable, Temp, IonicEffectFlag,  mH, mOH, Kw)
%disp('Func')
%Temp
%--CalculateSpatialPropertiesSteady
          % EquilibriumPolynomials %%Generate polynomials 
          % CalculateEquilibrium %%pH calculation 
          % CalculateIonicEffects %% pH calculation with Ionic strength
          % OnsagerFuoss %Correct mobilities
          % getLogActivity %get activity
 
global F Rmu Nspecies  epsilon DeltaP uCST Ngrid
%Kw muH muOH
global PrepareGridStage PrevTotalCost
global met2lit
global ColorList
global EquiPLength PolDeg Ngrid%EquilibriumPLength and Ploynomial Degree



% Constants
F=9.65E4;       % Faraday's const.[C/mol]
Rmu=8.31;       % Universal gas const. [J/mol*K]
%Temp=298;       % Temperature [K]
%Kw=1E-14;       % Water equilibrium constant
muH=mH/F;           % Mobility of Hydronium   % [m^2/s*V]/F --> [mol*s/Kg]
muOH=mOH/F;          % Mobility of Hydroxide   % [m^2/s*V]/F --> [mol*s/Kg]
met2lit=1000;           % m^3 to liters


        for ij=1:size(InputTable,1)

            INP{ij,1}=str2num(InputTable{ij,2});
            cMat(:,ij)=InputTable{ij,3};
        end
     
       
        Nspecies=size(INP,1);
        Ngrid=1; %size(cMat,1); %grid size, global variable
        addpath(['../SubroutinesIonic']);

        
        cMat=cMat*met2lit;
        FirstTimeFlag=1;
       
        %compute equilibirum

        [pH,SigVec,muMat, cH, muIonicCube, LCube, Kw_new, cizCube, muH_new, muOH_new, alphaMat, ValCube] ...
            = CalculateSpatialPropertiesSteady(INP,1,FirstTimeFlag,cMat, Temp, IonicEffectFlag,  muH, muOH, Kw);


end


     
     

