%% Function corrects variation of ion solvation w temperature
% Anita Rogacs
% November 2012

% Each ion has its corresponding data file containing experimental data of
% limiting conductivity*viscosity (ref:  Nightingale, 1959) 

function R_sol=Nightingale(Temp,z,S)
global RefTemp
x = test_func(Temp);
Tr = RefTemp -273.15; 
T = Temp-273.15;       %operating temp

switch(S)
   case 'HYDROCHLORIC-ACID'
      [A,a]= readtext('Nightingale_Cl_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero');
      [C,I] = min(abs(A(:,1)-T));   % find closest temperature and associated data point 
      [Cr,Ir] = min(abs(A(:,1)-Tr));
      R_sol=A(I,2)/A(Ir,2);
   case 'SODIUM'
      [A,a]= readtext('Nightingale_Na.txt', '[,\t]', '#', '"', 'numeric-empty2zero');
      [C,I] = min(abs(A(:,1)-T));   % find closest temperature and associated data point 
      [Cr,Ir] = min(abs(A(:,1)-Tr));
      R_sol=A(I,2)/A(Ir,2);
   case 'POTASSIUM'
      [A,a]= readtext('Nightingale_K_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero');
      [C,I] = min(abs(A(:,1)-T));   % find closest temperature and associated data point 
      [Cr,Ir] = min(abs(A(:,1)-Tr));
      R_sol=A(I,2)/A(Ir,2);   
    case 'LITHIUM'
      [A,a]= readtext('Nightingale_Li_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero');
      [C,I] = min(abs(A(:,1)-T));   % find closest temperature and associated data point 
      [Cr,Ir] = min(abs(A(:,1)-Tr));
      R_sol=A(I,2)/A(Ir,2);
   case 'MAGNESIUM'
      [A,a]= readtext('Nightingale_Mg_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero');
      [C,I] = min(abs(A(:,1)-T));   % find closest temperature and associated data point 
       [Cr,Ir] = min(abs(A(:,1)-Tr));
      R_sol=A(I,2)/A(Ir,2);
   case 'PERCHLORIC-ACID'
      [A,a]= readtext('Nightingale_Perchlorate_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero');
      [C,I] = min(abs(A(:,1)-T));   % find closest temperature and associated data point 
      [Cr,Ir] = min(abs(A(:,1)-Tr));
      R_sol=A(I,2)/A(Ir,2); 
   case 'RUBIDIUM'
      [A,a]= readtext('Nightingale_Rb and Cs _data.txt', '[,\t]', '#', '"', 'numeric-empty2zero');
      [C,I] = min(abs(A(:,1)-T));   % find closest temperature and associated data point 
       [Cr,Ir] = min(abs(A(:,1)-Tr));
      R_sol=A(I,2)/A(Ir,2);
    case 'CESIUM'
      [A,a]= readtext('Nightingale_Rb and Cs _data.txt', '[,\t]', '#', '"', 'numeric-empty2zero');
      [C,I] = min(abs(A(:,1)-T));   % find closest temperature and associated data point 
      mob =  10.35e-21*A(I,2)/abs(z)/x(4)*10^10; % factors convert from limiting conductivity to mobility
     case 'CALCIUM'
      [A,a]= readtext('Nightingale_Rb and Cs _data.txt', '[,\t]', '#', '"', 'numeric-empty2zero');
      [C,I] = min(abs(A(:,1)-T));   % find closest temperature and associated data point 
      [Cr,Ir] = min(abs(A(:,1)-Tr));
      R_sol=A(I,2)/A(Ir,2);
    case 'SILVER'
      [A,a]= readtext('Nightingale_Ag_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero');
      [C,I] = min(abs(A(:,1)-T));   % find closest temperature and associated data point 
      [Cr,Ir] = min(abs(A(:,1)-Tr));
      R_sol=A(I,2)/A(Ir,2);
    case 'SULFATE'
      [A,a]= readtext('Nightingale_Sulfate_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero');
      [C,I] = min(abs(A(:,1)-T));   % find closest temperature and associated data point 
      [Cr,Ir] = min(abs(A(:,1)-Tr));
      R_sol=A(I,2)/A(Ir,2);
    otherwise
        R_sol = '';
         
end





