%% Plots Nightingale data for the 11 small ions
%%% Anita Rogacs %%%
%%% November 2012 %%%

clear all 
clc
close all

[A,a]= readtext('Nightingale_Mg_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero')
plot(A(:,1), A(:,2), 'k')
hold on
clear A a
[A,a]= readtext('Nightingale_K_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero')
plot(A(:,1), A(:,2), 'k--')
hold on
clear A a
[A,a]= readtext('Nightingale_Na.txt', '[,\t]', '#', '"', 'numeric-empty2zero')
plot(A(:,1), A(:,2), 'k:')
hold on
clear A a
[A,a]= readtext('Nightingale_Ag_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero')
plot(A(:,1), A(:,2), 'b')
hold on
clear A a
[A,a]= readtext('Nightingale_Rb and Cs _data.txt', '[,\t]', '#', '"', 'numeric-empty2zero')
plot(A(:,1), A(:,2), 'b--')
hold on
clear A a
[A,a]= readtext('Nightingale_Ca_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero')
plot(A(:,1), A(:,2), 'b:')
hold on
clear A a
[A,a]= readtext('Nightingale_Perchlorate_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero')
plot(A(:,1), A(:,2), 'r')
hold on
clear A a
[A,a]= readtext('Nightingale_Sulfate_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero')
plot(A(:,1), A(:,2), 'r--')
hold on
clear A a
[A,a]= readtext('Nightingale_Cl_data.txt', '[,\t]', '#', '"', 'numeric-empty2zero')
plot(A(:,1), A(:,2), 'r:')


xlabel('Temperature (C)')
ylabel('Walden product')
xlim([0 100])
ylim([0.1 0.8])
figure=gcf;
set(findall(figure,'-property','FontSize'),'FontSize',12) 
set(findall(figure,'-property','linewidth'),'linewidth',2) 
legend('Mg^+', 'K^+', 'Na^+', 'Ag^+', 'RB^+ and Cs^+', 'Ca^2^+', 'ClO_4', 'SO_4^2^-', 'Cl^-')


