%% Simulation of Temperature Effects on Electrophoresis (STEEP)  buffer calculator 
% Developed by Anita Rogacs, Supreet Singh Bahga and Moran Bercovici
% Related publications and directions for use can be found in README file 
% GUI interface written by Jose Gutierrez and Anita Rogacs

function varargout = STEEPBufferCalculatorGUI(varargin)
%STEEPBUFFERCALCULATORGUI M-file for STEEPBufferCalculatorGUI.fig
%      STEEPBUFFERCALCULATORGUI, by itself, creates a new STEEPBUFFERCALCULATORGUI or raises the existing
%      singleton*.
%
%      H = STEEPBUFFERCALCULATORGUI returns the handle to a new STEEPBUFFERCALCULATORGUI or the handle to
%      the existing singleton*.
%
%      STEEPBUFFERCALCULATORGUI('Property','Value',...) creates a new STEEPBUFFERCALCULATORGUI using the
%      given property value pairs. Unrecognized properties are passed via
%      varargin to STEEPBufferCalculatorGUI_OpeningFcn.  This calling syntax produces a
%      warning when there is an existing singleton*.
%
%      STEEPBUFFERCALCULATORGUI('CALLBACK') and STEEPBUFFERCALCULATORGUI('CALLBACK',hObject,...) call the
%      local function named CALLBACK in STEEPBUFFERCALCULATORGUI.M with the given input
%      arguments.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help STEEPBufferCalculatorGUI

% Last Modified by GUIDE v2.5 21-Apr-2013 23:17:17

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @STEEPBufferCalculatorGUI_OpeningFcn, ...
                   'gui_OutputFcn',  @STEEPBufferCalculatorGUI_OutputFcn, ...
                   'gui_LayoutFcn',  [], ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
   gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before STEEPBufferCalculatorGUI is made visible.
function STEEPBufferCalculatorGUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   unrecognized PropertyName/PropertyValue pairs from the
%            command line (see VARARGIN)

% Choose default command line output for STEEPBufferCalculatorGUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes STEEPBufferCalculatorGUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = STEEPBufferCalculatorGUI_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes during object creation, after setting all properties.
function tempTextField_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tempTextField (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function tempLabel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to calculateButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

textStr = sprintf('%s\n%s%s', 'Operating','Temperature (', char(176),'C)');
set(hObject,'String',textStr);


% --- Executes on button press in calculateButton.
function calculateButton_Callback(hObject, eventdata, handles)
% hObject    handle to calculateButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

temp = get(handles.tempTextField,'String');
selectedCellData = get(handles.selectedTable,'Data');

disablePopups = get(handles.disablePopupsCheckbox,'Value');

% generate error messages and popups
[errType warnings] = displayWarnings(selectedCellData, handles);
[MSGwarnings] = displayMSGWarnings(selectedCellData, handles);

% display text box with warnings, ask user about overriding
overrideWarning = 0;

if isempty(warnings) ~= 1
    if errType==2 && disablePopups~=1
        msgStr = sprintf('Calculation could not proceed due to the following error(s):\n\n%s',warnings);
        msgbox(msgStr,'Error','error','modal');
        overrideWarning=0;
    elseif errType==1 && disablePopups~=1
        dlgMsg = sprintf('Warning!\n\n%sWould you like to replace NaN values with 0?',warnings);
        overrideWarning = strcmp(questdlg(dlgMsg, 'Warning', 'Yes', 'No', 'No'),'Yes');
        
    elseif errType==2 && disablePopups==1
        overrideWarning=0;
    else
        overrideWarning=1;
    end
else
    overrideWarning=1;
end

if isempty(selectedCellData)~=1 && (isempty(warnings)==1 || overrideWarning==1)
    
    set(handles.bgeSolutionTable, 'Data', []);
    set(handles.bgeConstituentsTable,'Data',[]);
    set(handles.absMobilitiesTable,'Data',[]);
    
    % if isnumtemp > 1, then temp has letter characters
    alpha = isstrprop(temp,'alpha');
    isAlphaTemp = sum(alpha);
    
    selectedTData = get(handles.selectedTable,'Data');
    TempData = selectedTData;
    
    for i=1:1:size(selectedTData,1)
        selectedTData{i,2} = strrep(TempData{i,3}, 'NaN', '0');
        selectedTData{i,3} = eval(TempData{i,2});
    end
    
    InputTable = selectedTData;
    
    
    % in case temp is not specified, only perform 25C calculations
    if (isempty(temp)~=0 || isAlphaTemp ~= 0)
        
        
        colHeadersSoln = {'pH',...
                          'Ionic Strength (M)',...
                          'Conductivity (S/m)',...
                          'Buffering Capacity (M)'};
        
        rowHeadersSoln = {strcat('25',char(176),'C')};
        
        colHeadersConst = {'Name',...
                           strcat(char(0181),'eff ',' (25',char(176),'C)')};
        
        colHeadersSoln = setDisplayProperties(colHeadersSoln);
        colHeadersConst = setDisplayProperties(colHeadersConst);
        
        set(handles.bgeSolutionTable, 'ColumnName', colHeadersSoln);
        set(handles.bgeSolutionTable, 'RowName', rowHeadersSoln)
        set(handles.bgeConstituentsTable, 'ColumnName', colHeadersConst);
        
        [Brt BCrt CorrectedTable]=SampleSolution(InputTable, 25+273.15);
        
        % Format data for solutions table
        
        cellData = zeros(4,1);
        cellData(1,1) = Brt(1);
        cellData(2,1) = Brt(2);
        cellData(3,1) = Brt(3);
        cellData(4,1) = Brt(4);
        
        % Format data for constituents table
        
        cellData2 = cell(2,2);
        p = size(InputTable,1);
        
        % Format data for absolute mobilities table
        
        cellData3 = cell(2,2);
        
        for c = 1:p
            cellData2{c,1} = InputTable{c,1};
            cellData2{c,2} = BCrt(c);
            
            CorrStr = str2num(CorrectedTable{c,2});
            cellData3{c,1} = CorrectedTable{c,1};   %Set name of the species
            
            for t=1:length(CorrStr)/3
                Content = mat2str(CorrStr(3*(t-1)+1:3*t));
                cellData3{c,2}= [cellData3{c,2} Content];  %Assign updated properties (evaluated @ Operating Temp) of each ion (valence, absolute mobility and pKa)
            end
            
        end
        
        if isreal(cellData(3,1))~=1
            msgStr = sprintf('Calculation error. Check input values.\n\n');
            msgbox(msgStr,'Error','error','modal');
            
        elseif isnan(cellData(3,1))
            msgStr = sprintf('Calculation error. Check input mobilities.\n\n');
            msgbox(msgStr,'Error','error','modal');
        else
            set(handles.bgeSolutionTable,'Data', cellData.');
            set(handles.bgeConstituentsTable,'Data', cellData2);
            set(handles.absMobilitiesTable,'Data',cellData3);
        end
        
        text = strcat('Absolute mobilities and pKa at T=25', char(176), 'C');
        set(handles.absMobilitiesText,'String',text);
        
        
        % if temp is specified
    else
        overrideError = 1;
        if str2num(temp) >= 100
            dlgMsg = sprintf('Caution: Operating temperature is above validated conditions.\nWould you like to continue?',warnings);
            overrideError = strcmp(questdlg(dlgMsg, 'Warning', 'Yes', 'No', 'No'),'Yes');
        end
        
        if overrideError == 1
            colHeadersSoln = {'pH',...
                              'Ionic Strength (M)',...
                              'Conductivity (S/m)',...
                              'Buffering Capacity (M)'};
            
            rowHeadersSoln = {strcat('25',char(176),'C'),...
                              strcat(temp, char(176), 'C')};
            
            colHeadersConst = {'Name',...
                               strcat(char(0181),'<html><sub>eff</sub> ',' (25',char(176),'C)'),...
                               strcat(char(0181),'<html><sub>eff</sub> ',' (',temp,char(176),'C)')};
            
            colHeadersSoln = setDisplayProperties(colHeadersSoln);
            colHeadersConst = setDisplayProperties(colHeadersConst);
            
            set(handles.bgeSolutionTable, 'ColumnName', colHeadersSoln);
            set(handles.bgeSolutionTable, 'RowName', rowHeadersSoln)
            set(handles.bgeConstituentsTable, 'ColumnName', colHeadersConst);
            
            temp = eval(temp);
            
            [Brt BCrt CorrectedTable]=SampleSolution(InputTable, 25+273.15);
            [B BC CorrectedTable]=SampleSolution(InputTable, temp+273.15);
            
            cellData = zeros(4,2);
            cellData(1,1) = Brt(1);
            cellData(2,1) = Brt(2);
            cellData(3,1) = Brt(3);
            cellData(4,1) = Brt(4);
            cellData(1,2) = B(1);
            cellData(2,2) = B(2);
            cellData(3,2) = B(3);
            cellData(4,2) = B(4);
            
            cellData2 = cell(2,3);  %Table for effective mobilites
            cellData3 = cell(2,2);  %Table for electrolyte properties at the operating temperature
            
            % Cycle through the number of rows (number of electrolytes in solution)
            p = size(InputTable,1);
            for c = 1:p
                cellData2{c,1} = InputTable{c,1};
                cellData2{c,2} = BCrt(c);
                cellData2{c,3} = BC(c);
                
                CorrStr = str2num(CorrectedTable{c,2});
                cellData3{c,1} = CorrectedTable{c,1};   %Set name of the species
                
                for t=1:length(CorrStr)/3
                    Content = mat2str(CorrStr(3*(t-1)+1:3*t));
                    cellData3{c,2} = [cellData3{c,2} Content];  %Assign updated properties (evaluated @ Operating Temp) of each ion (valence, absolute mobility and pKa)
                end
                
            end
            
            if isreal(cellData(3,1)) ~=1 || isreal(cellData(3,2))~=1
                msgStr = sprintf('Calculation error. Check input values.\n\n');
                msgbox(msgStr,'Error','error','modal');
                
            elseif isnan(cellData(3,1)) || isnan(cellData(3,2))
                msgStr = sprintf('Calculation error. Check input mobilities.\n\n');
                msgbox(msgStr,'Error','error','modal');
            else
                set(handles.bgeSolutionTable,'Data', cellData.');
                set(handles.bgeConstituentsTable,'Data', cellData2);
                set(handles.absMobilitiesTable,'Data',cellData3);
            end
            
        end

        text = strcat('Absolute mobilities and pKa at T=',num2str(temp), char(176), 'C');
        set(handles.absMobilitiesText,'String',text);
    end
    
end


% --- Executes on button press in addButton.get
function addButton_Callback(hObject, eventdata, handles)
% hObject    handle to addButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% databaseTable_CellSelectionCallback(hObject, eventdata, handles)
selectedIndex = get(handles.databaseTable,'UserData');

if (isempty(selectedIndex) ~= 1)
    set(handles.bgeSolutionTable, 'Data', []);
    set(handles.bgeConstituentsTable, 'Data', []);

    tableData = get(handles.databaseTable,'Data');

    % get a whole row of data from the selected data matrix
    rowData = tableData(selectedIndex(1),:);
    rowString = rowData{2};
    
    newData = {rowData{1}, '', rowString};

    prevDataSelected = get(handles.selectedTable,'Data');

    if isempty(prevDataSelected);
        set(handles.selectedTable,'Data',newData);
    else
        set(handles.selectedTable,'Data',[prevDataSelected;newData]);
    end
end


% --- Executes on button press in removeButton.
function removeButton_Callback(hObject, eventdata, handles)
% hObject    handle to removeButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
selectedIndex = get(handles.selectedTable,'UserData');

if (isempty(selectedIndex) ~= 1)
    set(handles.bgeSolutionTable, 'Data', []);
    set(handles.bgeConstituentsTable, 'Data', []);

    tableData = get(handles.selectedTable,'Data');

    tableData(selectedIndex(1),:) = [];

    set(handles.selectedTable, 'Data', tableData);
end


function databaseTable_CreateFcn(hObject, eventdata, handles)
% handles.selectedCells = [];
warning('off','MATLAB:xlsread:Mode')

% determine OS
if ispc == 1
    [num, txt, raw]= xlsread('Database/STEEP_Database.xls');
elseif ismac == 1
    [num, txt, raw]= xlsread('Database/STEEP_Database.xls', '','', 'basic');
else
    % add support for another OS
end

index = 1;

% start at 2 to ignore header row in Excel file
for row = 2:size(raw,1)
    %cell_data{index,1}=txt{ij,2};
    cell_data{index,1} = raw{row,2};
    
    % Reference column = 5th column in Excel file
    % start collecting cells after ref column
    a=([raw{row,6:end}]);
    
    str = [];
    % split rest of row into groups of 5
    for kl=1:length(a)/5
        setContent = mat2str(a(5*(kl-1)+1:5*kl));
        numSetContent = eval(setContent);
        if(isempty(str) ~= 1 && isnan(numSetContent(1)) ~= 1)
            str = [str ' ' setContent];
        elseif (isnan(numSetContent(1))~=1)
            str = [str setContent];
        end
    end
    cell_data{index,2} = str; 
    index = index+1;
end

headers = {'Name',...
           '<html>Valence, Mobility (m<sup>2</sup>/V/s), pKa, &Delta H (J/mol), &Delta Cp (J/K/mol)</html>'};

headers = setDisplayProperties(headers);

columnWidths = {120, 400};

set(hObject,'ColumnName', headers);
set(hObject, 'ColumnWidth', columnWidths);
set(hObject,'Data',cell_data);


% --- Executes during object creation, after setting all properties.
function selectedTable_CreateFcn(hObject, eventdata, handles)
% hObject    handle to selectedTable (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
secondCol = '<html>Valence, Mobility (m<sup>2</sup>/V/s), pKa, &Delta H (J/mol), &Delta Cp (J/K/mol)</html>';
tableHeaders = {'Name',...
                 'Concentration(M)',...
                 secondCol};
            
tableHeaders = setDisplayProperties(tableHeaders);

columnWidths = {100, 120, 350};

set(hObject,'ColumnName', tableHeaders);
set(hObject, 'ColumnWidth', columnWidths);
set(hObject,'Data',[]);
guidata(hObject,handles);


% --- Executes when selected cell(s) is changed in selectedTable.
function selectedTable_CellSelectionCallback(hObject, eventdata, handles)
% hObject    handle to selectedTable (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) currently selecteds
% handles    structure with handles and user data (see GUIDATA)
set(hObject, 'UserData', eventdata.Indices);
guidata(hObject,handles);


% --- Executes when selected cell(s) is changed in databaseTable.
function databaseTable_CellSelectionCallback(hObject, eventdata, handles)
% hObject    handle to databaseTable (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) currently selecteds
% handles    structure with handles and user data (see GUIDATA)
set(hObject, 'UserData', eventdata.Indices);
guidata(hObject,handles);


% --- Executes during object creation, after setting all properties.
function bgeSolutionTable_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bgeSolutionTable (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
rowHeaders = {strcat('25', char(176), 'C'),...
              ''};

%rowHeaders = setDisplayProperties(rowHeaders);

colHeaders = {'pH',...
              'Ionic Strength (M)',...
              'Conductivity (S/m)',...
              'Buffering Capacity (M)'};
          
colHeaders = setDisplayProperties(colHeaders);

columnWidths = {70, 120, 120, 140};

set(hObject, 'ColumnName', colHeaders);
set(hObject, 'ColumnWidth', columnWidths);
set(hObject, 'RowName', rowHeaders);


% --- Executes during object creation, after setting all properties.
function bgeConstituentsTable_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bgeConstituentsTable (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
colHeader = strcat(char(0181), '<sub>eff</sub> ',' (25', char(176), 'C)');
tableHeaders = {'Name',...
                 colHeader};
             
tableHeaders = setDisplayProperties(tableHeaders);
             
cell_data = [];

columnWidths = {80, 100};

set(hObject, 'ColumnName', tableHeaders);
set(hObject, 'ColumnWidth', columnWidths);
set(hObject, 'Data', cell_data);


% --- Executes when entered data in editable cell(s) in selectedTable.
function selectedTable_CellEditCallback(hObject, eventdata, handles)
% hObject    handle to selectedTable (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) edited
%	PreviousData: previous data for the cell(s) edited
%	EditData: string(s) entered by the user
%	NewData: EditData or its converted form set on the Data property. Empty if Data was not changed
%	Error: error string when failed to convert EditData to appropriate value for Data
% handles    structure with handles and user data (see GUIDATA)
set(handles.bgeSolutionTable, 'Data', []);
set(handles.bgeConstituentsTable, 'Data', []);

textPos = eventdata.Indices;

userText = eventdata.EditData;

selTData = get(handles.selectedTable,'Data');

if (textPos(2)==2)
    selTData(textPos(1),2) = {userText};
    set(handles.selectedTable,'Data',selTData);
elseif (textPos(2)==3)
    selTData(textPos(1),3) = {userText};
    set(handles.selectedTable,'Data',selTData);
else 
    selTData(textPos(1),4) = {userText}; 
    set(handles.selectedTable,'Data',selTData);
end


function tempTextField_Callback(hObject, eventdata, handles)
% hObject    handle to tempTextField (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tempTextField as text
%        str2double(get(hObject,'String')) returns contents of tempTextField as a double
set(handles.bgeSolutionTable, 'Data', []);
set(handles.bgeConstituentsTable, 'Data', []);


% --- Executes during object creation, after setting all properties.
function absMobilitiesTable_CreateFcn(hObject, eventdata, handles)
% hObject    handle to absMobilitiesTable (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

secondCol = '<html>Valence, Mobility (m<sup>2</sup>/V/s), pKa</html>';

colHeaders={'Name',...
            secondCol};
        
colHeaders = setDisplayProperties(colHeaders);
        
columnWidths = {100, 300};

set(hObject,'ColumnName',colHeaders);
set(hObject, 'ColumnWidth', columnWidths);


% --- Executes during object creation, after setting all properties.
function absMobilitiesText_CreateFcn(hObject, eventdata, handles)
% hObject    handle to absMobilitiesText (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
text = strcat('Absolute mobilities and pKa at T = 25', char(176), 'C');
set(hObject,'String',text);


% --- Executes on button press in exportButton.
function exportButton_Callback(hObject, eventdata, handles)
% hObject    handle to exportButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% get data from all tables
% export input table (incldes name, concentrations, and room temperature
% properties

InputTable= get(handles.selectedTable,'Data');
savename = strcat('Data/InputTable');
save(savename, 'InputTable');

solnPropertiesData = get(handles.bgeSolutionTable,'Data');
OperatingTemperature = get(handles.tempTextField,'String');

%Export Solution Data
SolProp= cell(5,3);
SolProp(1,1) = {'Temperature (C)'};
SolProp(1,2) = {'25'};
SolProp(1,3) = {OperatingTemperature};
SolProp(2,1)={'pH'};
SolProp(3,1)={'Ionic Strength (M)'};
SolProp(4,1)={'Conductivity (S/m)'};
SolProp(5,1)={'Buffering Capacity (M)'};
a = solnPropertiesData(1,:);;
SolProp(2:5,2)=num2cell(a);

if ~isempty(solnPropertiesData(2,:))
a = solnPropertiesData(2,:);
SolProp(2:5,3)=num2cell(a);
end

savename = strcat('Data/SolutionProperties');
save(savename, 'SolProp');


%export operating temperature paramterers
OperatingTemperature = get(handles.tempTextField,'String');

if ~isempty(OperatingTemperature)
savename = strcat('Data/OperatingTemperature');
save(savename, 'OperatingTemperature');

absMobilitiesData = get(handles.absMobilitiesTable,'Data');
effMobilitiesData = get(handles.bgeConstituentsTable,'Data');
speciesNames = ['Name'; InputTable(:,1)];
effMobilities = ['mu_eff'; effMobilitiesData(:,2)];
combined = [speciesNames effMobilities];
absMobilities = absMobilitiesData(:,2);
valenceMatrix = generateValMatrix(absMobilities);

%export ElectrolyteProperties at operating temperature 
ElectrolyteProperties = [combined valenceMatrix]
savename = strcat('Data/ElectrolyteProperties_OpTemp');
save(savename, 'ElectrolyteProperties');

end

