%% Evaluates BGE solution properties and effective mobilites of BGE constituents
% author: Anita Rogacs
% November 2012

%%% INPUT %%%
% Input Table contains the list of electrolytes with Name, Properties @ ROOM TEMP [Valence, absolute mob, pK, deltaH, deltaCp], concentration(M). For example: 
% InputTable= { 
%           'Citric Acid','[-3.0 74.4e-9  6.396 4.07e3 -131] [-2 54.7e-9  4.761 2.23e3 -178] [-1 28.7e-009 3.128 -3.38e3 -254]', 0.0001;
%           'Boric acid', '[-1 36.48e-9 9.237 3.8e3  -240]', 0.02; 
%           'ethanolamine', '[1 44.3e-9 9.498 50.52e3  26]', 0.02;
%          'SODIUM', '[1 51.9e-009 13.7 0 0]', 0.0001;}
 
 % Operating Temperature: T
 
 %%% OUTPUT %%%
 % B: solution properties
 % B(1): pH, B(2):ionic strength, B(3): conductivity, B(4): buffering
 % capacity
 % BC: effective  mobilities of all ions included in the InputTable
 % CorrectedTable: contains the list of electrolytes with updated properties: 
 % Name, Properties @ OPERATING TEMP (Valence, absolute mob at T, pK at T), concentration(M). 
 
                

function [B BC CorrectedTable]=SampleSolution(InputTable, T)
 
global R RefTemp DelH_W DelCp_W pKaWB
IonicEffectFlag = 1;

RefTemp     = 25 + 273.15; % !!if you change this, change test_func  % reference temperature in Kelvins
R               = 8.31;  % gas constant

pKaWB       = 14; 
DelH_W      = 55.815e3; %[J/mol]
DelCp_W    = -224;     %[J/K/mol]

mH              = 362E-9;   % Mobility of Hydronium   % [m^2/s*V]
mOH            = 205E-9;   % Mobility of Hydroxide   % [m^2/s*V]
Kw              = 10^-14;    % Water dissociation constant

[CorrectedTable, mH, mOH, Kw] = AdjustReshape(InputTable, T);
[pH,SigVec,muMat, cMat, cH, cizCube, ValCube]=FuncSteadyStateSolver(CorrectedTable, T, IonicEffectFlag, mH, mOH, Kw);

B(1)    = pH;  %electrolyte pH
B(2)    = 0.5*sum(sum(ValCube.^2.*cizCube,3),1)/1000;  % Electrolyte ionics stregth
B(3)    = SigVec; % Electrolyte conductivity
B(4)    =  BufferingCapacity(CorrectedTable, pH, T); % Electrolyte buffering capacity

BC      = muMat';  %fully corrected mobiltity of all electrolytes in solution

end



