% File: checkData.m
% Authors: Jose Gutierrez and Anita Rogacs
% Usage: flags = checkData(tableData)
% ------------------------------------------------------------------
% This function generates flags that correspond to specific types of
% errors that may be encountered when running a calculation.
% Currently, the following flags are used:
%
% flag 0: the input table is not missing any data
% flag 1: array is missing one value (Cp or deltaH)
% flag 2: array is missing two values (Cp and deltaH)
% flag 3: a value is listed as 'NaN'
% flag 4: one or more concentration values are missing
% flag 5: table is empty
% flag 6: all concentrations are set to 0
function flags = checkData(DataTable)
Trigger =0;
if (isempty(DataTable)==1)
    % second element is a placeholder
    flags = [5 0];
    Trigger = 1;
else
    
    PropCol = DataTable(:,3);
    ConcCol = DataTable(:,2);
    
    
    for j = 1:size(ConcCol,1)
        if isempty(ConcCol{j,:})==1 
            flags(j+size(PropCol,1),:) = [4 j];
            Trigger = 1;
        else
            flags(j+size(PropCol,1),:) = [0 j];
        end
    end
    
% check for other flags only if first table is not empty and
% concentrations were specified
if Trigger~=1;
     
    %% flag for all 0 concentrations
    b=zeros(length(ConcCol), 1);
    for i=1:length(b)
        b(i)=str2num(ConcCol{i});
    end
    if all(sum(b))~=1
         % second element is a placeholder
    flags = [6 0];  
    
    else
    
        flags = zeros(size(PropCol,1) + size(ConcCol,1),2);

        for i = 1:size(PropCol,1)
            PropColStr = PropCol{i,:};

            bracketLoc = findstr(']', PropColStr);
            pos = 1;
            for j = 1:length(bracketLoc)
                % transform a set of second column data from string to vector
                PropColSet = eval(PropColStr(pos:bracketLoc(j)));

                colLength = length(PropColSet);

                % next position is 2 spaces ahead because of space between brackets
                pos = bracketLoc(j)+2;

                % finds number of elements that are NaN
                nNan = sum(isnan(PropColSet));

                % check if elements are missing or if elements are NaN
                if mod(colLength,5)~=0
                    flags(i,:) = [3 i];
                    break;
                else
                    if nNan == 2
                        flags(i,:) = [2 i];
                        break;
                    elseif nNan == 1
                        flags(i,:) = [1 i];
                        break;
                    else
                        flags(i,:) = [0 i];
                    end
                end

            end
        end
    end
    
    
end
end
end