% File: displayWarnings.m
% Authors: Jose Gutierrez and Anita Rogacs
% Usage: [errorType warningMessage] = displayWarnings(data, handles)
% ------------------------------------------------------------------
% This function determines the type of an error and the string that
% will be displayed to the user in a popup. The function uses the
% following error types:
% 
% Type 1: warning (Cp or deltaH may be missing)
% Type 2: error (tables are empty or there is not enough data to
% perform a calculation)


function [errorType warningMsg] = displayWarnings(dataTable, handles)


try
    flags = checkData(dataTable);
    errorType = 1;
    str = [];
    for i = 1:size(flags,1)
        flagNum = flags(i,1);
        flagRow = flags(i,2);
             
        if flagNum == 3
            errMsg = sprintf('Entry %i (%s): electrolyte properties are missing\n\n', flagRow, dataTable{flagRow,1});
            str = [str errMsg];
            errorType = 2;
        elseif flagNum == 4
            errMsg = sprintf('Entry %i (%s): Concentration is missing\n\n', flagRow, dataTable{flagRow,1});
            str = [str errMsg];
            errorType = 2;
        elseif flagNum == 5
            errMsg = sprintf('Electrolyte Solution Composition table is empty');
            str = [str errMsg];
            errorType = 2;        
         elseif flagNum == 6
            errMsg = sprintf('Concentrations of all species are set to 0');
            str = [str errMsg];
            errorType = 2;     
        end
    end
    
         if isempty(str)
              for i = 1:size(flags,1)
                flagNum = flags(i,1);
                flagRow = flags(i,2);
                if flagNum == 1
                    errMsg = sprintf('Entry %i (%s): deltaCp not specified\nSee message box for details\n\n', flagRow, dataTable{flagRow,1});
                    str = [str errMsg];
                    errorType = 1;
                 elseif flagNum == 2
                    errMsg = sprintf('Entry %i (%s): deltaH and deltaCp not specified\nSee message box for details\n\n', flagRow, dataTable{flagRow,1});
                    str = [str errMsg];
                    errorType = 1;
                end
              end

         
        end
    
    warningMsg = str;
    
catch err
% If an exception occurs, it will occur when checkData is called in line 8.
% Therefore, we can be certain that the error involves the Electrolyte
% Solution Composition table and the flagType will be 5.
    warningMsg = sprintf('errmsg'); % TODO: change this error message
    errorType = 2;
    set(handles.message,'String',warningMsg);
end

end
