% File: generateValMatrix.m
% Authors: Jose Gutierrez
% Usage: valMatrix = generateValMatrix(absoluteMobilitiesStringArray)
% -------------------------------------------------------------------
% This function generates a valence matrix given the values from the
% absolute mobilities table.

function valMatrix = generateValMatrix(absoluteMobilitiesStrArray)

row = 1;
col = 1;
index = 1;
valence = zeros(1,1);

for h = 1:length(absoluteMobilitiesStrArray)
    line = absoluteMobilitiesStrArray{h};
    
    % left bracket locations
    bracketLoc = findstr(']', line);
    
    start = 1;
    for i=1:length(bracketLoc)
        % evaluate first bracketed group
        str = line(start:bracketLoc(i));
        numMobArray = eval(str);
        
        % get valence, mobility, and pKa
        valence(index) = numMobArray(1);
        mob = num2str(numMobArray(2));
        pKa = num2str(numMobArray(3));
        
        % store mobilities and pKa in temp
        temp{row,col} = mob;
        temp{row,col+1} = pKa;
        
        start = bracketLoc(i)+1;
        col = col+2;
        index = index+1;
    end
    
    row = row + 1;
end

% create the first row that contains 'u(n)' and 'pKa(n)'
colIndex = 1;
for j = 1:length(valence)
    firstRow{colIndex} = strcat('u(',num2str(valence(j)),')');
    firstRow{colIndex+1} = strcat('pKa(',num2str(valence(j)),')');
    colIndex = colIndex + 2;
end

valMatrix = [firstRow; temp];
end