% File: setDisplayProperties.m
% Authors: Jose Gutierrez and Anita Rogacs
% Usage: updatedHeaderText = setDisplayProperties(currentHeaderText,
%                            textSize, textColor) 
% ------------------------------------------------------------------
% This function updates column and row headers to the desired size
% and color. Size and color arguments are optional.

function updatedHeaderText = setDisplayProperties(currentTableHeaders, fontSize, fontColor)

nrows = size(currentTableHeaders,1);
ncols = size(currentTableHeaders,2);

if ncols > nrows
    if nargin == 3
        for i = 1:length(currentTableHeaders)
          updatedHeaderText{i} = strcat('<html><font size=', num2str(fontSize), ' color =', fontColor, '>', currentTableHeaders{i}, '</font></html>');
        end
    elseif nargin == 2
        for i = 1:length(currentTableHeaders)
          updatedHeaderText{i} = strcat('<html><font size=', num2str(fontSize), '>', currentTableHeaders{i}, '</font></html>');
        end
    elseif nargin == 1
        for i = 1:length(currentTableHeaders)
          updatedHeaderText{i} = strcat('<html><font size=4>', currentTableHeaders{i}, '</font></html>');
        end
    end
else
    if nargin == 3
        for i = 1:size(currentTableHeaders,1)
          updatedHeaderText{:,i} = strcat('<html><font size=', num2str(fontSize), ' color =', fontColor, '>', currentTableHeaders{i}, '</font></html>');
        end
    elseif nargin == 2
        for i = 1:size(currentTableHeaders,1)
          updatedHeaderText{:,i} = strcat('<html><font size=', num2str(fontSize), '>', currentTableHeaders{i}, '</font></html>');
        end
    elseif nargin == 1
        for i = 1:size(currentTableHeaders,1)
          updatedHeaderText{:,i} = strcat('<html><font size=4>', currentTableHeaders{i}, '</font></html>');
        end
    end
end