function y=test_func(T)

global RefTemp


%RefTemp = 25 + 273.15; 
y(1) = RefTemp;

%T = 45 + 273.15;  % temperature in K
y(2) = T;


R  = 8.31;  % gas constant

% viscosity (Fox and McDonald's Intro to FLuid Mechanics)
y(3) = (2.414e-5)*10^(247.8/(RefTemp-140));
y(4) = (2.414e-5)*10^(247.8/(T-140));

% dielectric constant (CRC handbook)
y(5) = 249.21 - 0.79069*RefTemp +(0.72997e-3)*RefTemp^2;
y(6) = 249.21 - 0.79069*T +(0.72997e-3)*T^2;

%y(7) = 1.002*10^((20-T)/(T+96)*(1.2378 - 1.303e-3*(20-T) +  3.06e-6*(20-T)^2 + 2.55e-8*(20-T)^3));
