% THIS FUNCTION IS REDUNDANT AND IS NOT USED ANYWHERE
%
%
%--------------------------------------------------------------------------
%  Calculate Chemical Equilibrium when Ionic Effects are ON
%  Using the output of EquilibriumPolynomials, i.e. P, Q etc this function
%  a) computes C_H = [H+].
%  b) knowing C_H and LMat, it computes g_iz
%  Returns c_iz, c_h, g_iz 
%--------------------------------------------------------------------------
function [cizCube,cH,cHCubePower,gizCube]=CalculateEquilibriumIonic(FirstTimeFlag,...
    cH,PMat,Q,PPrimeMat,QPrime,PolDeg,EquiPLength,N,LMat,LCube,cMat,Nspecies)
global met2lit Ngrid

% EQUILIBRIUM
if FirstTimeFlag==1  % Solve for pH the first time
    %----------------------------------------------------------------------
    %----
    % Setup constant matrices -  THIS PART RUNS ONLY ONCE PER SIMULATION
    %--------------------------------------------------------------------------
    % Get equilibrium polynomials

    for ij=1:Ngrid %iterate over all grids
        cTot=cMat(ij,:)/met2lit;   % convert back to mol/liter
        cTotRep=cTot'*ones(1,size(PMat,2)); %probably put PCube(ij)
        P=sum(cTotRep.*PMat,1);

        Poly=zeros(1,EquiPLength);

        Poly(1:size(P,2))=Poly(1:size(P,2))+P;
        Poly(1:size(Q,2))=Poly(1:size(Q,2))+Q;
        Poly=fliplr(Poly);

        roo=roots(Poly);
        roo=roo(imag(roo)==0);
        cH(ij)=roo(roo>0);          % NOTE THAT cH is in mol/lit
    end %for ij
else
    % Solve for pH using Newton Raphson
    count=0;        cHPrev=ones(1,N);
    %            while max(abs(cHPrev-cH)) > max([abs(cH),abs(cHPrev)])*1E-3
  for k=1:N
    while abs(cHPrev(k)-cH(k))/max(abs(cH(k)),abs(cHPrev(k))) > 1E-6
        count=count+1;
        cHPrev(k)=cH(k);
        EquicHPolMat=[1;cumprod(ones(EquiPLength-1,1)*cH(k),1)];
        %% this makes a makes a matrix of powers of cH which is multiplied 
        %by the companian matrix
        fcH=sum(cMat(k,:)'.*(PMat*EquicHPolMat),1)/met2lit+Q*EquicHPolMat;
        fPrimecH=sum(cMat(k,:)'.*(PPrimeMat*EquicHPolMat),1)/met2lit+QPrime*EquicHPolMat;
        cH(k)=cH(k)-fcH/fPrimecH;

        if count>5
            count;
        end
        if count>100
            disp('Too many iterations on cH. Returning');
            return;
        end

    end
  end
end %if first time

cHPolMat=[ones(1,N);cumprod(ones(PolDeg-1,1)*cH,1)]; %will have to make again
M1Cube=FastRepmatPages(cMat'./(sparse(LMat)*cHPolMat),PolDeg);
cHCubePower=FastRepmatRows(permute(cHPolMat,[3,2,1]),Nspecies);
cizCube=LCube.*cHCubePower.*M1Cube;

gizCube=LCube.*cHCubePower.*FastRepmatPages(1./(sparse(LMat)*cHPolMat),PolDeg);

