%--------------------------------------------------------------------------
%  Equilibrium polonomial
%  Called in the LocalOde45 function before the first time step
%  COMMENTS: I would require to call this again and again, if I update
%  pKa's for ionic strength stuff.
%  1) In that case, This would have to be called in CalculateEquilibrium function
%  2) Could remove its call in LocalOde function then
%  3) INP would need to be updated everytime I calculate new kPa
%  4) INP is actually part of ARGS used in MainRun to call LocalOde45
%  5) Would have to take INP as input of CalculateEquilibrium if I need to 
%     call EquilibriumPolynomials(INP) in that function.
%--------------------------------------------------------------------------
function [PCube,PPrimeCube,QMat,QPrimeMat,LCube,ValCube,muCube,DCube, ...
    zListArranged, KaListCube]=EquilibriumPolynomials(INP, Temp, Kw)
global F Rmu  Ngrid EquiPLength PolDeg

%Ngrid=150; %testing

% PREPARE MATRICES
%------------------
MaxCol=-Inf;
for j=1:size(INP,1) %iterate on species
    MaxCol=max([MaxCol,max(INP{j}(1:3:end))-min(INP{j}(1:3:end))+1]);
end

LMat=zeros(size(INP,1),MaxCol);

ValMat=zeros(size(INP,1),MaxCol);
muMat=ValMat; KaMat=ValMat; DMat=ValMat;

for j=1:size(INP,1) % for every specie
    zList=INP{j}(1:3:end);
    muList=INP{j}(2:3:end)./(F*abs(zList));  % Defines Santiago mobility
    pKaList=INP{j}(3:3:end);
    KaList=10.^(-pKaList);

    %%make 2-D-Kalist
    DList=Rmu*Temp*muList; %diffusivity


    [zList,Index]=sort(zList);
    KaList=KaList(Index);
    DList=DList(Index);
    muList=muList(Index);

    Ip1=find(zList==1);     Im1=find(zList==-1);

    zList=[zList(1:Im1),0,zList(Ip1:end)];
    muList=[muList(1:Im1),0,muList(Ip1:end)];
    KaList=[KaList(1:Im1),1,KaList(Ip1:end)];
    DList=[DList(1:Im1),mean(DList),DList(Ip1:end)];

    
    ValMat(j,1:length(zList))=zList;
    muMat(j,1:length(muList))=muList;
    KaMat(j,1:length(KaList))=KaList;
    DMat(j,1:length(DList))=DList;

    zListArranged{j}=zList;
    
    for k=1:Ngrid
    KaListCube{k}{j}=KaList; %k=grid point, j=species
    end
    
    nj=min(zList);    pj=max(zList);

    
    for z=zList
        if z<0
%LMat is LMat
            LMat(j,z-nj+1)=prod(KaList(z-nj+1:-nj));
        elseif z>0
            LMat(j,z-nj+1)=1/prod(KaList(-nj+2:z-nj+1));
        elseif z==0
            LMat(j,z-nj+1)=1;
        end %if
    end % for z

end %for ij

% CONSTRUCT POLYNOMIALS
%--------------------
Q1=1;
for j=1:size(LMat,1)
    Q1=conv(Q1,LMat(j,:));
end %for j
Q2=[-Kw 0 1];
Q=conv(Q1,Q2);

for i=1:size(INP,1)
    tmp=zeros(1,size(LMat,2));
    tmp(1:length(zListArranged{i}))=zListArranged{i};
    Mmod=LMat;     Mmod(i,:)=Mmod(i,:).*tmp;

    Pi=1;
    for kl=1:size(Mmod,1)
        Pi=conv(Pi,Mmod(kl,:));
    end %for j
    %PMat(i,:)=Pi;
    Pi=conv([0 1],Pi);  % Convolve with P2
    PMat(i,:)=Pi;

    PiPrime=Pi.*([1:length(Pi)]-1);   PiPrime=[PiPrime(2:end),0];
    PPrimeMat(i,:)=PiPrime;
end %for i
%P2=[0 1];

% Calculate polynomial derivatives
QPrime=Q.*([1:length(Q)]-1);   QPrime=[QPrime(2:end),0];

SizeDiff=size(Q,2)-size(PMat,2);
if SizeDiff>0
    PMat=[PMat,repmat(PMat(:,1)*0,1,SizeDiff)];
    PPrimeMat=[PPrimeMat,repmat(PMat(:,1)*0,1,SizeDiff)];
elseif SizeDiff<0
    Q=[Q,repmat(0,1,SizeDiff)];
    QPrime=[QPrime,repmat(0,1,SizeDiff)];
end

% PMat=sparse(PMat); %these matrices are not sparse!
% Q=sparse(Q);

EquiPLength=max(size(PMat,2),size(Q,2)); %make these using Pcube
PolDeg=size(LMat,2); % Polynomial degree %make this using LCube

%Cube here refers to 3-d array
%cols: grid points, rows: no. of species depth: polynomial degree
muCube=repmat(reshape(muMat,[size(INP,1),1,PolDeg]),[1,Ngrid,1]); %mobilities
DCube=repmat(reshape(DMat,[size(INP,1),1,PolDeg]),[1,Ngrid,1]); %diffusivities
ValCube=repmat(reshape(ValMat,[size(INP,1),1,PolDeg]),[1,Ngrid,1]); %valence
LCube=FastRepmatColumns(reshape(LMat,[size(INP,1),1,PolDeg]),Ngrid); %L
PCube=FastRepmatColumns(reshape(PMat,[size(INP,1),1,EquiPLength]),Ngrid);
PPrimeCube=FastRepmatColumns(reshape(PPrimeMat,[size(INP,1),1, EquiPLength]),Ngrid); %L
PCube=permute(PCube,[1, 3, 2]);
PPrimeCube=permute(PPrimeCube,[1, 3, 2]);

QMat=repmat(Q,Ngrid,1);
QPrimeMat=repmat(QPrime,Ngrid,1);
%First time LCube is just made by repeating LMat as pKas are same on all
%grid points. But later for Ionic strengths it should be made differently

% ---------------------------------
