package Gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import Controller.*;

public class JobLogDlg extends JDialog implements ActionListener{ 

    private int buttonHit;
    private JTextArea outputArea;
    private JButton okButton;
    private JobManager jm;
    
    public JobLogDlg(JTextArea log){
	setTitle("Structure Job Log");
	setLocationRelativeTo(null);

	outputArea = log;
	outputArea.setEditable(false);
	JScrollPane sp = new JScrollPane(outputArea);
		
	sp.setPreferredSize(new Dimension(350,350));
	
	
	okButton = new JButton("  OK  ");
	okButton.setActionCommand("ok");
	okButton.addActionListener(this);
	JPanel buttonPane = new JPanel();
	
	buttonPane.add(okButton);
	buttonPane.setPreferredSize(new Dimension(350,50));
	
	JPanel topPane = new JPanel();
	JLabel title = new JLabel("Structure Job Log");
	topPane.add(title);
	getContentPane().add("North",topPane);
	getContentPane().add("Center",sp);
	getContentPane().add("South", buttonPane);
    }
    public int showDialog(){
	setModal(false);
	pack();
	super.show();
	return buttonHit;
    }
    
    public JTextArea getOutput(){
	return outputArea;
    }


    public void actionPerformed(ActionEvent event){
	
	String action = event.getActionCommand();
	if(action.equals("ok")){	    
	    buttonHit =JOptionPane.OK_OPTION;								
	    setVisible(false);
	    return;
	}
	
    }
    

}
