/*
 * Decompiled with CFR 0.152.
 */
package Gui;

import Controller.PFGenManager;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PFileGenDlg
extends JDialog
implements ActionListener {
    private String sSim;
    private int buttonHit;
    private JComboBox simBox;
    private JCheckBox seedBox;
    private JButton okButton;
    private JButton cancelButton;
    private JButton browseButton;
    private JTextField dirField;
    private JTextField fromKField;
    private JTextField toKField;
    private JTextField seedField;
    private String saveDir;
    private int fromK;
    private int toK;
    private int seed;
    private PFGenManager manager;
    private boolean requireSeed;

    public PFileGenDlg(String[] stringArray) {
        this.setTitle("Parameter file generator");
        this.setLocationRelativeTo(null);
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Select a parameter set  ");
        this.simBox = new JComboBox<String>(stringArray);
        this.simBox.setEditable(false);
        this.simBox.setPreferredSize(new Dimension(160, 20));
        this.simBox.setSelectedIndex(0);
        jPanel.add(jLabel);
        jPanel.add(this.simBox);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel("Generate files for k from    ");
        this.fromKField = new JTextField(3);
        JLabel jLabel3 = new JLabel(" to ");
        JLabel jLabel4 = new JLabel("    ");
        this.toKField = new JTextField(3);
        jPanel2.add(jLabel2);
        jPanel2.add(this.fromKField);
        jPanel2.add(jLabel3);
        jPanel2.add(this.toKField);
        jPanel2.add(jLabel4);
        this.seedBox = new JCheckBox("Use sequential integer random seeds starting at  ");
        this.seedField = new JTextField(4);
        this.seedBox.setActionCommand("seed");
        this.seedBox.addActionListener(this);
        this.requireSeed = false;
        this.seedField.setEnabled(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.seedBox);
        jPanel3.add(this.seedField);
        JPanel jPanel4 = new JPanel();
        JLabel jLabel5 = new JLabel("Save in directory ");
        this.dirField = new JTextField(9);
        this.browseButton = new JButton("Browse...");
        this.browseButton.setActionCommand("browse");
        this.browseButton.addActionListener(this);
        jPanel4.add(jLabel5);
        jPanel4.add(this.dirField);
        jPanel4.add(this.browseButton);
        this.okButton = new JButton("Generate");
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(" Dismiss ");
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.okButton);
        jPanel5.add(this.cancelButton);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(0, 1));
        jPanel6.add(jPanel);
        jPanel6.add(jPanel2);
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel4);
        jPanel6.setPreferredSize(new Dimension(430, 150));
        jPanel5.setPreferredSize(new Dimension(430, 50));
        JPanel jPanel7 = new JPanel();
        JLabel jLabel6 = new JLabel(" ");
        jPanel7.add(jLabel6);
        jPanel7.setPreferredSize(new Dimension(430, 30));
        this.getContentPane().add("North", jPanel7);
        this.getContentPane().add("Center", jPanel6);
        this.getContentPane().add("South", jPanel5);
    }

    public int showDialog() {
        this.setModal(true);
        this.pack();
        super.show();
        return this.buttonHit;
    }

    public void setManager(PFGenManager pFGenManager) {
        this.manager = pFGenManager;
    }

    private boolean validateInput() {
        this.sSim = (String)this.simBox.getSelectedItem();
        String string = this.fromKField.getText();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "K must be an Integer", "Error", 0);
            return false;
        }
        if (n <= 0) {
            JOptionPane.showMessageDialog(null, "K must be greater than 0", "Error", 0);
            return false;
        }
        this.fromK = n;
        string = this.toKField.getText();
        n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "K must be an Integer", "Error", 0);
            return false;
        }
        if (n <= 0) {
            JOptionPane.showMessageDialog(null, "K must be greater than 0", "Error", 0);
            return false;
        }
        if (n < this.fromK) {
            JOptionPane.showMessageDialog(null, "Invalid Range for K: from " + this.fromK + " to " + n, "Error", 0);
            return false;
        }
        this.toK = n;
        this.saveDir = this.dirField.getText();
        File file = new File(this.saveDir);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, "Target directory does not exist", "Error", 0);
            return false;
        }
        if (!file.canWrite()) {
            JOptionPane.showMessageDialog(null, "No write permission in target directory", "Error", 0);
            return false;
        }
        if (this.requireSeed) {
            String string2 = this.seedField.getText();
            try {
                this.seed = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, "Random seed input is invalid", "Error", 0);
                return false;
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            if (this.validateInput()) {
                this.buttonHit = 0;
                this.manager.generateFile(this.sSim, this.fromK, this.toK, this.saveDir, this.requireSeed, this.seed);
                return;
            }
            return;
        }
        if (string.equals("cancel")) {
            this.buttonHit = 2;
            this.setVisible(false);
            return;
        }
        if (string.equals("browse")) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setApproveButtonText("Select");
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.dirField.setText(file.getAbsolutePath());
            }
        }
        if (string.equals("seed")) {
            this.requireSeed = !this.requireSeed;
            this.seedField.setEnabled(this.requireSeed);
        }
    }

    public String getSaveDir() {
        return this.saveDir;
    }

    public int getFromK() {
        return this.fromK;
    }

    public int getToK() {
        return this.toK;
    }

    public boolean isSeedRequired() {
        return this.requireSeed;
    }

    public int getSeed() {
        return this.seed;
    }

    public String getSim() {
        return this.sSim;
    }
}

