/*
 * Decompiled with CFR 0.152.
 */
package Gui.Param;

import Gui.Param.LambdDlg;
import Obj.NSimObj;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FreqDlg
extends JDialog
implements ActionListener {
    private int buttonHit;
    private float mean = 0.01f;
    private float sd = 0.05f;
    private float lambd = 1.0f;
    private boolean onefst;
    private boolean setlambd = true;
    private boolean inferlambd = false;
    JTextField meanField;
    JTextField sdField;
    private JButton okButton;
    private JButton cancelButton;
    private JButton defaultButton;
    private JCheckBox onefstBox;
    private JRadioButton setlambdBox;
    private JRadioButton inferlambdBox;
    private JTextField lambdField;
    private JButton lambdButton;
    private LambdDlg lambdDlg;
    private NSimObj sim;
    private boolean focusIsSet;

    public FreqDlg(Component component, NSimObj nSimObj, boolean bl) {
        this.sim = nSimObj;
        JLabel jLabel = new JLabel("Prior Mean: ");
        JLabel jLabel2 = new JLabel("Prior SD:   ");
        this.setlambdBox = new JRadioButton("Set Lambda  ");
        this.setlambdBox.setActionCommand("setlambd");
        this.setlambdBox.addActionListener(this);
        this.inferlambdBox = new JRadioButton("Infer Lambda");
        this.inferlambdBox.setActionCommand("inferlambd");
        this.inferlambdBox.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.setlambdBox);
        buttonGroup.add(this.inferlambdBox);
        this.meanField = new JTextField(10);
        this.meanField.setText("0.01");
        this.sdField = new JTextField(10);
        this.sdField.setText("0.05");
        this.lambdField = new JTextField(10);
        this.lambdButton = new JButton("Configure ...");
        this.lambdButton.setActionCommand("lambdbutton");
        this.lambdButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.lambdButton);
        jLabel.setLabelFor(this.meanField);
        jLabel2.setLabelFor(this.sdField);
        this.okButton = new JButton("   OK  ");
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel ");
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        this.defaultButton = new JButton("Default");
        this.defaultButton.addActionListener(this);
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        this.onefstBox = new JCheckBox("Assume Same Value of Fst for All Subpopulations");
        this.onefstBox.addItemListener(checkBoxListener);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel2.add(this.setlambdBox);
        jPanel2.add(this.inferlambdBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.meanField);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.sdField);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(this.lambdField);
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel6);
        jPanel3.add(jPanel);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(this.cancelButton);
        jPanel7.add(this.defaultButton);
        jPanel7.add(this.okButton);
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(BorderFactory.createEmptyBorder(20, 20, 4, 20));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel8.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        gridBagLayout.setConstraints(this.onefstBox, gridBagConstraints);
        jPanel8.add(this.onefstBox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel8.add(jPanel2);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel8.add(jPanel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(25, 20, 20, 20);
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel8.add(jPanel7);
        this.setContentPane(jPanel8);
        this.setLocationRelativeTo(component);
        if (!nSimObj.isNew() && !bl) {
            this.onefst = nSimObj.ONEFST;
            this.onefstBox.setSelected(nSimObj.ONEFST);
            this.mean = nSimObj.FPRIORMEAN;
            this.sd = nSimObj.FPRIORSD;
            this.meanField.setText("" + this.mean);
            this.sdField.setText("" + this.sd);
            this.setlambd = nSimObj.FQSETLAMBDA;
            this.inferlambd = nSimObj.FQINFERLAMBDA;
            if (this.setlambd) {
                this.lambd = nSimObj.LAMBDA;
            }
            if (this.inferlambd) {
                this.lambdDlg = new LambdDlg((Component)this, nSimObj, false);
            }
        }
        this.updatePanelUI();
    }

    private void updatePanelUI() {
        this.lambdField.setText("" + this.lambd);
        this.lambdField.setEnabled(this.setlambd);
        this.inferlambdBox.setSelected(this.inferlambd);
        this.lambdButton.setEnabled(this.inferlambd);
        this.setlambdBox.setSelected(this.setlambd);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Default")) {
            this.reset();
            return;
        }
        if (string.equals("ok")) {
            if (!this.validateData()) {
                return;
            }
            this.buttonHit = 0;
            this.setVisible(false);
            return;
        }
        if (string.equals("cancel")) {
            this.buttonHit = 2;
            this.reset();
            this.setVisible(false);
            return;
        }
        if (string.equals("setlambd")) {
            if (!this.setlambd) {
                this.setlambd = true;
                this.inferlambd = false;
            }
            this.updatePanelUI();
            return;
        }
        if (string.equals("inferlambd")) {
            if (!this.inferlambd) {
                this.inferlambd = true;
                this.setlambd = false;
                this.lambd = 1.0f;
            }
            this.updatePanelUI();
            return;
        }
        if (string.equals("lambdbutton")) {
            if (this.lambdDlg == null) {
                this.lambdDlg = new LambdDlg((Component)this, this.sim, true);
            }
            this.lambdDlg.showDialog();
            return;
        }
    }

    private void setFocus() {
        if (!this.focusIsSet) {
            this.meanField.requestFocus();
            this.focusIsSet = true;
        }
    }

    public int showDialog() {
        this.setModal(true);
        this.pack();
        super.show();
        return this.buttonHit;
    }

    public void reset() {
        this.meanField.setText("0.01");
        this.mean = 0.01f;
        this.sdField.setText("0.05");
        this.sd = 0.05f;
        this.onefstBox.setSelected(false);
        this.onefst = false;
        this.setlambd = true;
        this.inferlambd = false;
        this.lambd = 1.0f;
        this.updatePanelUI();
    }

    public boolean validateData() {
        String string = "";
        String string2 = this.meanField.getText();
        try {
            this.mean = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = string + new String("\n\"Prior Mean\" Must be a Real Number");
        }
        string2 = this.sdField.getText();
        try {
            this.sd = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = string + new String("\n\"Prior SD\" Must be a Real Number");
        }
        if (this.setlambd) {
            string2 = this.lambdField.getText();
            try {
                this.lambd = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string = string + new String("\nLambda Must be a Real Number");
            }
        }
        if (string.compareTo("") != 0) {
            String string3 = "Errors:\n";
            string = string3.concat(string);
            string = string + new String("\n\n");
            JOptionPane.showMessageDialog(this, string, "errors", 0);
            return false;
        }
        return true;
    }

    public void updateData() {
        this.sim.ONEFST = this.onefst;
        this.sim.FPRIORMEAN = this.mean;
        this.sim.FPRIORSD = this.sd;
        this.sim.FQSETLAMBDA = this.setlambd;
        this.sim.FQINFERLAMBDA = this.inferlambd;
        if (this.setlambd) {
            this.sim.LAMBDA = this.lambd;
        }
        if (this.inferlambd) {
            if (this.lambdDlg == null) {
                this.sim.LAMBDA = 1.0f;
                this.sim.POPSPECIFICLAMBDA = false;
            } else {
                this.lambdDlg.updateData();
            }
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            boolean bl = true;
            if (itemEvent.getStateChange() == 2) {
                bl = false;
            }
            if (itemSelectable == FreqDlg.this.onefstBox) {
                FreqDlg.this.onefst = bl;
            }
        }
    }
}

