/*
 * Decompiled with CFR 0.152.
 */
package Loader;

import Gui.RstDlg;
import Loader.Decoder;
import Plot.AlphaPlotManager;
import Plot.FstPlotManager;
import Plot.LikePlotManager;
import Plot.LnpdPlotManager;
import Plot.RecmbPlotManager;
import Plot.RstPlotManager;
import Triangle.TrianglePlotManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class RstLoader
implements ActionListener {
    private JFrame frame;
    private Decoder decoder;
    private String rstFile;
    private String runtimeFile;
    private FstPlotManager fstpm = new FstPlotManager();
    private AlphaPlotManager alphapm = new AlphaPlotManager();
    private LikePlotManager likepm = new LikePlotManager();
    private LnpdPlotManager lnpdpm = new LnpdPlotManager();
    private RstPlotManager rpm;
    private RecmbPlotManager recpm = new RecmbPlotManager();
    private TrianglePlotManager tripm;
    private RstDlg fileDlg = new RstDlg(null);

    public RstLoader() {
        int n = this.fileDlg.showDialog();
        if (n == 0) {
            this.showResult(this.fileDlg.getRstFile(), this.fileDlg.getRtmFile());
        }
        this.fileDlg.dispose();
    }

    private void showResult(String string, String string2) {
        this.rstFile = string;
        this.runtimeFile = string2;
        if (this.decoder != null) {
            this.decoder = null;
        }
        this.decoder = new Decoder(string, string2);
        if (string2 != null) {
            this.decoder.readRuntimeData();
        }
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.frame = new JFrame("Show results");
        String string3 = this.decoder.getRstContent();
        JTextArea jTextArea = new JTextArea(string3);
        jTextArea.setMargin(new Insets(20, 50, 20, 40));
        jTextArea.setFont(new Font("TimesRoman", 0, 15));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
        jScrollPane.setPreferredSize(new Dimension(850, 600));
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Load results ...");
        jMenuItem.setActionCommand("open");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Bar plot");
        JMenuItem jMenuItem2 = new JMenuItem("Show");
        jMenuItem2.setActionCommand("barplot");
        jMenuItem2.addActionListener(this);
        jMenu2.add(jMenuItem2);
        JMenu jMenu3 = new JMenu("Data plot");
        JMenuItem jMenuItem3 = new JMenuItem("Fst");
        if (this.decoder.fst_array != null) {
            jMenuItem3.setActionCommand("sviewfst");
            jMenuItem3.addActionListener(this);
        } else {
            jMenuItem3.setEnabled(false);
        }
        JMenuItem jMenuItem4 = new JMenuItem("Alpha");
        if (this.decoder.alpha_array != null) {
            jMenuItem4.setActionCommand("sviewalpha");
            jMenuItem4.addActionListener(this);
        } else {
            jMenuItem4.setEnabled(false);
        }
        JMenuItem jMenuItem5 = new JMenuItem("Recombination rate");
        if (this.decoder.rec_array != null) {
            jMenuItem5.setActionCommand("sviewrec");
            jMenuItem5.addActionListener(this);
        } else {
            jMenuItem5.setEnabled(false);
        }
        JMenuItem jMenuItem6 = new JMenuItem("Likelihood");
        if (this.decoder.llhd_array != null) {
            jMenuItem6.setActionCommand("sviewlike");
            jMenuItem6.addActionListener(this);
        } else {
            jMenuItem6.setEnabled(false);
        }
        JMenuItem jMenuItem7 = new JMenuItem("Ln P(D) ");
        if (this.decoder.lnpd_array != null) {
            jMenuItem7.setActionCommand("sviewlnpd");
            jMenuItem7.addActionListener(this);
        } else {
            jMenuItem7.setEnabled(false);
        }
        jMenu3.add(jMenuItem3);
        jMenu3.add(jMenuItem4);
        jMenu3.add(jMenuItem5);
        jMenu3.add(jMenuItem6);
        jMenu3.add(jMenuItem7);
        JMenu jMenu4 = new JMenu("Histogram");
        JMenuItem jMenuItem8 = new JMenuItem("Fst");
        if (this.decoder.fst_array != null) {
            jMenuItem8.setActionCommand("histfst");
            jMenuItem8.addActionListener(this);
        } else {
            jMenuItem8.setEnabled(false);
        }
        JMenuItem jMenuItem9 = new JMenuItem("Alpha");
        if (this.decoder.alpha_array != null) {
            jMenuItem9.setActionCommand("histalpha");
            jMenuItem9.addActionListener(this);
        } else {
            jMenuItem9.setEnabled(false);
        }
        JMenuItem jMenuItem10 = new JMenuItem("Recombination rate");
        if (this.decoder.rec_array != null) {
            jMenuItem10.setActionCommand("histrec");
            jMenuItem10.addActionListener(this);
        } else {
            jMenuItem10.setEnabled(false);
        }
        JMenuItem jMenuItem11 = new JMenuItem("Likelihood");
        if (this.decoder.llhd_array != null) {
            jMenuItem11.setActionCommand("histlike");
            jMenuItem11.addActionListener(this);
        } else {
            jMenuItem11.setEnabled(false);
        }
        JMenuItem jMenuItem12 = new JMenuItem("Ln P(D) ");
        if (this.decoder.llhd_array != null) {
            jMenuItem12.setActionCommand("histlnpd");
            jMenuItem12.addActionListener(this);
        } else {
            jMenuItem12.setEnabled(false);
        }
        JMenu jMenu5 = new JMenu("Triangle plot");
        JMenuItem jMenuItem13 = new JMenuItem("Show");
        jMenuItem13.setActionCommand("triplot");
        jMenuItem13.addActionListener(this);
        jMenu5.add(jMenuItem13);
        jMenu4.add(jMenuItem8);
        jMenu4.add(jMenuItem9);
        jMenu4.add(jMenuItem10);
        jMenu4.add(jMenuItem11);
        jMenu4.add(jMenuItem12);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        jMenuBar.add(jMenu5);
        this.frame.setJMenuBar(jMenuBar);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)jScrollPane, "Center");
        this.frame.setLocation(300, 200);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.compareTo("sviewfst") == 0) {
            this.fstpm.plot(this.decoder.fst_array, this.runtimeFile);
            return;
        }
        if (string.equals("sviewalpha")) {
            this.alphapm.plot(this.decoder.alpha_array, this.runtimeFile);
            return;
        }
        if (string.equals("sviewrec")) {
            this.recpm.plot(this.decoder.rec_array, this.runtimeFile);
            return;
        }
        if (string.equals("sviewlnpd")) {
            this.lnpdpm.plot(this.decoder.lnpd_array, this.runtimeFile);
            return;
        }
        if (string.equals("sviewlike")) {
            this.likepm.plot(this.decoder.llhd_array, this.runtimeFile);
            return;
        }
        if (string.equals("barplot")) {
            if (this.rpm != null) {
                this.rpm.dispose();
                this.rpm = null;
            }
            this.rpm = new RstPlotManager(this.frame, this.rstFile, this.rstFile);
        }
        if (string.equals("histrec")) {
            this.recpm.plotHist(this.decoder.getHistArray(1), this.runtimeFile);
            return;
        }
        if (string.equals("histfst")) {
            this.fstpm.plotHist(this.decoder.getHistArray(3), this.runtimeFile);
            return;
        }
        if (string.equals("histalpha")) {
            this.alphapm.plotHist(this.decoder.getHistArray(2), this.runtimeFile);
            return;
        }
        if (string.equals("histlike")) {
            this.likepm.plotHist(this.decoder.getHistArray(4), this.runtimeFile);
            return;
        }
        if (string.equals("histlnpd")) {
            this.likepm.plotHist(this.decoder.getHistArray(5), this.runtimeFile);
            return;
        }
        if (string.equals("open")) {
            this.fileDlg = new RstDlg(this.frame);
            int n = this.fileDlg.showDialog();
            if (n == 0) {
                this.showResult(this.fileDlg.getRstFile(), this.fileDlg.getRtmFile());
            }
            this.fileDlg.dispose();
        }
        if (string.equals("triplot")) {
            this.tripm = new TrianglePlotManager();
            this.tripm.showFrame(null, this.rstFile);
        }
    }
}

