/*
 * Decompiled with CFR 0.152.
 */
package Obj;

import Obj.NSimObj;
import Obj.ObjIO;
import Obj.ProjObj;
import Util.CopyFile;
import Util.DelDir;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class NProjObj {
    String workingPath;
    String projName;
    String projPath;
    Vector simList;
    boolean useIndLabel;
    boolean usePopId;
    boolean usePopFlag;
    boolean useGeneName;
    boolean useLocusName;
    boolean usePhaseInfo;
    boolean usePhenoType;
    boolean oneRow;
    boolean phased;
    boolean recessiveAllele;
    String notambiguous;
    int extraCol = 0;
    int numInds;
    int ploidy;
    int numloci;
    String missingVal;
    String dataFile;
    int recessiveAlleleShown = 0;
    int recessiveAlleleNotShown = 0;
    int noambiguityCount = 0;
    int ambiguousNorecessiveCount = 0;

    public NProjObj(String string, String string2, boolean bl, boolean bl2, int n, int n2, int n3, int n4, String string3, String string4, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10) {
        this.projName = string;
        this.projPath = string2;
        this.useIndLabel = bl;
        this.usePopId = bl2;
        this.extraCol = n;
        this.numInds = n2;
        this.ploidy = n3;
        this.numloci = n4;
        this.missingVal = string3;
        this.dataFile = string4;
        this.usePopFlag = bl3;
        this.useGeneName = bl4;
        this.useLocusName = bl5;
        this.usePhaseInfo = bl6;
        this.oneRow = bl7;
        this.phased = bl8;
        this.usePhenoType = bl9;
        this.recessiveAllele = bl10;
        this.simList = new Vector();
    }

    public NProjObj() {
        this.simList = new Vector();
    }

    public NProjObj(ProjObj projObj) {
        this.projName = projObj.getName();
        this.projPath = projObj.getPath();
        this.useIndLabel = projObj.isIndLabel();
        this.usePopId = projObj.isPopId();
        this.extraCol = projObj.getExtraCol();
        this.numInds = projObj.getNumInds();
        this.ploidy = projObj.getPloidy();
        this.numloci = projObj.getNumloci();
        this.missingVal = projObj.getMissingVal();
        this.dataFile = projObj.getDataFile();
        String string = projObj.getConfig();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
            stringTokenizer2.nextToken();
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            if (string3.equals("MARKERNAMES")) {
                try {
                    n = Integer.parseInt(string4);
                    this.useGeneName = n == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string3.equals("MAPDISTANCES")) {
                try {
                    n = Integer.parseInt(string4);
                    this.useLocusName = n == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string3.equals("PHASEINFO")) {
                try {
                    int n2 = Integer.parseInt(string4);
                    this.usePhaseInfo = n2 == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string3.equals("PHENOTYPE")) {
                try {
                    int n3 = Integer.parseInt(string4);
                    this.usePhenoType = n3 == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string3.equals("ONEROWPERIND")) {
                try {
                    int n4 = Integer.parseInt(string4);
                    this.oneRow = n4 == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string3.equals("PHASED")) {
                try {
                    int n5 = Integer.parseInt(string4);
                    this.phased = n5 == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!string3.equals("POPFLAG")) continue;
            try {
                int n6 = Integer.parseInt(string4);
                if (n6 == 1) {
                    this.usePopFlag = true;
                    continue;
                }
                this.usePopFlag = false;
            }
            catch (Exception exception) {}
        }
        this.recessiveAllele = false;
    }

    public void setName(String string) {
        this.projName = string;
    }

    public String getName() {
        return this.projName;
    }

    public void setPath(String string) {
        this.projPath = string;
    }

    public String getPath() {
        return this.projPath;
    }

    public void setIndLabel(boolean bl) {
        this.useIndLabel = bl;
    }

    public boolean isIndLabel() {
        return this.useIndLabel;
    }

    public void setPopId(boolean bl) {
        this.useIndLabel = bl;
    }

    public boolean isPopId() {
        return this.useIndLabel;
    }

    public void setExtraCol(int n) {
        this.extraCol = n;
    }

    public int getExtraCol() {
        return this.extraCol;
    }

    public void setNumInds(int n) {
        this.numInds = n;
    }

    public int getNumInds() {
        return this.numInds;
    }

    public void setPloidy(int n) {
        this.ploidy = n;
    }

    public int getPloidy() {
        return this.ploidy;
    }

    public void setNumloci(int n) {
        this.numloci = n;
    }

    public int getNumloci() {
        return this.numloci;
    }

    public void setMissingVal(String string) {
        this.missingVal = string;
    }

    public void setNAMBCode(String string) {
        this.notambiguous = string;
    }

    public String getMissingVal() {
        return this.missingVal;
    }

    public void setDataFile(String string) {
        this.dataFile = string;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public boolean getMapDistance() {
        return this.useLocusName;
    }

    public boolean getRecessiveAllele() {
        return this.recessiveAllele;
    }

    public boolean getGeneName() {
        return this.useGeneName;
    }

    public boolean getOneRow() {
        return this.oneRow;
    }

    public boolean getPhaseInfo() {
        return this.usePhaseInfo;
    }

    public boolean getPhased() {
        return this.phased;
    }

    public void writeProjectFile() {
        ObjIO.writeProjFile(this);
    }

    public void createProjectSpace() {
        File file = new File(this.projPath, this.projName);
        file.mkdirs();
        this.workingPath = file.getAbsolutePath();
        File file2 = new File(this.workingPath, "project_data");
        CopyFile.copyFile(this.dataFile, file2.getAbsolutePath());
        this.dataFile = file2.getAbsolutePath();
        this.writeProjectFile();
    }

    public void setWorkingPath(String string) {
        this.workingPath = string;
    }

    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setSimVector() {
        this.simList = new Vector();
        File file = new File(this.workingPath);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2;
            if (!fileArray[i].isDirectory() || !(file2 = new File(fileArray[i], ".sim")).exists()) continue;
            this.simList.addElement(fileArray[i].getName());
        }
    }

    public String getConfig() {
        String string = "";
        string = string + new String("#define INFILE " + this.dataFile + "\n");
        string = string + new String("#define NUMINDS " + this.numInds + "\n");
        string = string + new String("#define NUMLOCI " + this.numloci + "\n");
        string = this.useIndLabel ? string + new String("#define LABEL 1 \n") : string + new String("#define LABEL 0 \n");
        string = this.usePopId ? string + new String("#define POPDATA 1 \n") : string + new String("#define POPDATA 0 \n");
        string = this.usePopFlag ? string + new String("#define POPFLAG 1 \n") : string + new String("#define POPFLAG 0 \n");
        string = this.usePhenoType ? string + new String("#define PHENOTYPE 1 \n") : string + new String("#define PHENOTYPE 0 \n");
        string = this.useGeneName ? string + new String("#define MARKERNAMES 1 \n") : string + new String("#define MARKERNAMES 0 \n");
        string = this.useLocusName ? string + new String("#define MAPDISTANCES 1 \n") : string + new String("#define MAPDISTANCES 0 \n");
        string = this.oneRow ? string + new String("#define ONEROWPERIND 1 \n") : string + new String("#define ONEROWPERIND 0 \n");
        string = this.usePhaseInfo ? string + new String("#define PHASEINFO 1 \n") : string + new String("#define PHASEINFO 0 \n");
        string = this.phased ? string + new String("#define PHASED 1 \n") : string + new String("#define PHASED 0 \n");
        if (this.recessiveAllele) {
            string = string + new String("#define RECESSIVEALLELES 1 \n");
            if (this.ploidy >= 3) {
                string = string + "#define NOTAMBIGUOUS " + this.notambiguous + "  \n";
            }
        } else {
            string = string + new String("#define RECESSIVEALLELES 0 \n");
        }
        string = string + new String("#define EXTRACOLS " + this.extraCol + "\n");
        string = string + new String("#define MISSING " + this.missingVal + "\n");
        string = string + new String("#define PLOIDY " + this.ploidy + "\n");
        return string;
    }

    public String printProjInfo() {
        String string = new String("\n");
        string = string + new String("         =============== Project Information ============== \n\n");
        string = string + new String("                  Project Name: " + this.projName + "\n");
        string = string + new String("                  Project Path: " + this.workingPath + "\n");
        string = string + new String("                  Data File: " + this.dataFile + "\n\n\n");
        string = string + new String("                         Data Information\n\n");
        string = string + new String("                  Number of Individuals: " + this.numInds + "\n");
        string = string + new String("                  Number of Loci: " + this.numloci + "\n");
        string = string + new String("                  Ploidy: " + this.ploidy + "\n");
        string = string + new String("                  Missing Data is Represented by: " + this.missingVal + "\n\n\n");
        string = string + new String("                         Data Format\n\n");
        if (this.useIndLabel) {
            string = string + new String("                  Data Contains Individual Labels \n");
        }
        if (this.usePopId) {
            string = string + new String("                  Data Contains Population Identifiers \n");
        }
        if (this.usePopFlag) {
            string = string + new String("                  Data Contains USEPOPINFO Selection Flags \n");
        }
        if (this.useGeneName) {
            string = string + new String("                  Data Contains Row of Marker Names \n");
        }
        if (this.recessiveAllele) {
            string = string + new String("                  Data contains Row of Recessive Alleles \n");
            if (this.ploidy >= 3) {
                string = string + "                       Number of loci without genotypic ambiguity: " + this.noambiguityCount + "\n";
                string = string + "                       Number of loci with ambiguous copy numbers but no recessive allele: " + this.ambiguousNorecessiveCount + "\n";
            }
            string = string + "                       Number of loci with recessive alleles present in the dataset: " + this.recessiveAlleleShown + "\n";
            string = string + "                       Number of loci with recessive alleles absent in the dataset: " + this.recessiveAlleleNotShown + "\n";
        }
        if (this.useLocusName) {
            string = string + new String("                  Data Contains Map Distances between Loci \n");
        }
        if (this.usePhaseInfo) {
            string = string + new String("                  Data Contains Phase Information \n");
        }
        if (this.usePhenoType) {
            string = string + new String("                  Data Contains Phenotype \n");
        }
        if (this.oneRow) {
            string = string + new String("                  Data File Strores Data for Individuals in a Single Line \n");
        }
        if (this.phased) {
            string = string + new String("                  Data are phased \n");
        }
        if (this.extraCol > 0) {
            string = string + new String("                  Total Number of Extra Columns: " + this.extraCol + "\n");
        }
        return string;
    }

    public int getColNum() {
        return this.numloci + this.extraCol;
    }

    public String[] getDataTitle() {
        int n;
        int n2;
        int n3 = this.numloci;
        if (this.oneRow) {
            n3 = this.numloci * this.ploidy;
        }
        int n4 = this.extraCol;
        if (this.useIndLabel) {
            ++n4;
        }
        if (this.usePopId) {
            ++n4;
        }
        if (this.usePopFlag) {
            ++n4;
        }
        if (this.usePhenoType) {
            ++n4;
        }
        String[] stringArray = new String[n3 + n4];
        int n5 = 0;
        if (this.useIndLabel) {
            stringArray[n5++] = "Label";
        }
        if (this.usePopId) {
            stringArray[n5++] = "Pop ID";
        }
        if (this.usePopFlag) {
            stringArray[n5++] = "Flag";
        }
        if (this.usePhenoType) {
            stringArray[n5++] = "Phenotype";
        }
        for (n2 = 0; n2 < this.extraCol; ++n2) {
            stringArray[n5 + n2] = "Extra " + (n2 + 1);
        }
        n5 += this.extraCol;
        n2 = 1;
        if (this.oneRow) {
            n2 = this.ploidy;
        }
        int n6 = 1;
        int n7 = n5;
        for (n = n5; n < stringArray.length; ++n) {
            stringArray[n] = "";
        }
        for (n = 0; n < this.numloci; ++n) {
            stringArray[n7] = "Locus " + n6;
            n7 += n2;
            ++n6;
        }
        return stringArray;
    }

    public String[][] loadData() {
        String string;
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        Object object2;
        int n5 = 0;
        int n6 = this.ploidy;
        if (this.oneRow) {
            n6 = 1;
        }
        if (this.usePhaseInfo) {
            ++n6;
        }
        n5 = n6 * this.numInds;
        int n7 = 0;
        if (this.useGeneName) {
            ++n7;
        }
        if (this.useLocusName) {
            ++n7;
        }
        if (this.recessiveAllele) {
            ++n7;
        }
        n5 += n7;
        int n8 = this.numloci;
        if (this.oneRow) {
            n8 = this.numloci * this.ploidy;
        }
        int n9 = this.extraCol;
        if (this.useIndLabel) {
            ++n9;
        }
        if (this.usePopId) {
            ++n9;
        }
        if (this.usePopFlag) {
            ++n9;
        }
        if (this.usePhenoType) {
            ++n9;
        }
        String[][] stringArray = new String[n5][n8 += n9];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n8; ++j) {
                stringArray[i][j] = "  ";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        try {
            object2 = new FileInputStream(this.dataFile);
            object = new InputStreamReader((InputStream)object2, "UTF8");
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            while ((n4 = ((Reader)bufferedReader).read()) > -1) {
                stringBuffer.append((char)n4);
            }
            ((Reader)bufferedReader).close();
            string2 = stringBuffer.toString();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Can not Read Data Source", "Error", 0);
            return null;
        }
        object2 = new StringTokenizer(string2, "\n");
        object = new String();
        int n10 = 0;
        n4 = 0;
        int n11 = this.ploidy;
        int n12 = 0;
        if (this.oneRow) {
            n11 = 1;
            n12 = this.ploidy - 1;
        }
        while (((StringTokenizer)object2).hasMoreTokens()) {
            object = ((StringTokenizer)object2).nextToken();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object);
            if (!stringTokenizer.hasMoreTokens()) continue;
            if (n10 < n7) {
                if (!this.parseData(stringArray, n10, (String)object, n9, 0, n12)) {
                    return null;
                }
                ++n10;
                continue;
            }
            if (this.usePhaseInfo && n4 == n11) {
                if (!this.parseData(stringArray, n10, (String)object, n9, 0, n12)) {
                    return null;
                }
                n4 = 0;
                ++n10;
                continue;
            }
            if (!this.parseData(stringArray, n10, (String)object, n9, 1, 0)) {
                return null;
            }
            ++n10;
            ++n4;
        }
        if (n10 < stringArray.length) {
            JOptionPane.showMessageDialog(null, "Bad Format in Data Source: \nExpect " + stringArray.length + " rows, currently have " + n10 + " rows", "Error", 0);
            return null;
        }
        if (this.recessiveAllele && this.recessiveAlleleShown == 0 && this.recessiveAlleleNotShown == 0) {
            int n13 = 0;
            if (this.useGeneName) {
                ++n13;
            }
            n3 = 1;
            if (this.oneRow) {
                n3 = this.ploidy;
            }
            for (n2 = 0; n2 < this.numloci; ++n2) {
                n = n9 + n3 * n2;
                string = stringArray[n13][n];
                if (string.equals(this.missingVal)) continue;
                boolean bl = true;
                for (int i = n7; i < stringArray.length; ++i) {
                    if (!stringArray[i][n].equals(string)) continue;
                    ++this.recessiveAlleleShown;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                ++this.recessiveAlleleNotShown;
            }
        }
        if (this.recessiveAllele && this.ploidy >= 3) {
            int n14 = 0;
            if (this.useGeneName) {
                ++n14;
            }
            n3 = 1;
            if (this.oneRow) {
                n3 = this.ploidy;
            }
            for (n2 = 0; n2 < this.numloci; ++n2) {
                n = n9 + n3 * n2;
                string = stringArray[n14][n];
                if (string.equals(this.notambiguous)) {
                    --this.recessiveAlleleNotShown;
                    ++this.noambiguityCount;
                }
                if (!string.equals(this.missingVal)) continue;
                ++this.ambiguousNorecessiveCount;
            }
        }
        return stringArray;
    }

    private boolean parseData(String[][] stringArray, int n, String string, int n2, int n3, int n4) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n5 = 0;
        if (n3 == 0) {
            n5 = n2;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            try {
                stringArray[n][n5] = string3;
                n5 += n4 + 1;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = n >= stringArray.length ? "Number of rows are more than expected (" + stringArray.length + ")" : "Data entries are more than expected (" + stringArray[n].length + ") at line " + (n + 1);
                JOptionPane.showMessageDialog(null, "Bad Format in Data Source: \n" + string2, "Error", 0);
                return false;
            }
        }
        if (n5 != stringArray[0].length) {
            string2 = "Expect " + stringArray[0].length + " data entries at line " + (n + 1);
            JOptionPane.showMessageDialog(null, "Bad Format in Data Source: \n" + string2, "Error", 0);
            return false;
        }
        return true;
    }

    public boolean checkSimName(String string) {
        if (string == null) {
            return false;
        }
        if (this.simList.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.simList.size(); ++i) {
            String string2 = (String)this.simList.elementAt(i);
            if (!string2.equals(string)) continue;
            return false;
        }
        return true;
    }

    public boolean addSimObj(String string) {
        if (this.checkSimName(string)) {
            this.simList.add(string);
            return true;
        }
        return false;
    }

    public boolean removeSimObj(String string) {
        for (int i = 0; i < this.simList.size(); ++i) {
            String string2 = (String)this.simList.elementAt(i);
            if (string2.compareTo(string) != 0) continue;
            this.simList.remove(i);
            --i;
            File file = new File(this.workingPath, string);
            DelDir.removeDir(file);
            return true;
        }
        return false;
    }

    public NSimObj getSimObj(String string) {
        for (int i = 0; i < this.simList.size(); ++i) {
            String string2 = (String)this.simList.elementAt(i);
            if (string2.compareTo(string) != 0) continue;
            File file = new File(this.workingPath, string);
            String string3 = file.getAbsolutePath();
            File file2 = new File(string3, ".sim");
            NSimObj nSimObj = ObjIO.loadSimObj(this, string2);
            if (nSimObj != null) {
                nSimObj.setProjObj(this);
            }
            return nSimObj;
        }
        return null;
    }

    public String[] getSimList() {
        String[] stringArray = new String[this.simList.size()];
        for (int i = 0; i < this.simList.size(); ++i) {
            stringArray[i] = (String)this.simList.elementAt(i);
        }
        return stringArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    private static InputStream OpenInputFile(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("**Error: unable to open input file.");
            fileInputStream = null;
        }
        return fileInputStream;
    }
}

