/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Random;
import javax.swing.JPanel;

public class RstDraw
extends JPanel {
    private int yHeight = 140;
    private int xLength;
    private int anchorLength = 6;
    private int numRows;
    private int numBins = 50;
    private boolean single_row = true;
    private int bhFactor = this.yHeight;
    private int bWidth = 25;
    private int rowHeight = 200;
    private int rowLength = 900;
    private double[][] plotdata;
    private int[] plotlabels;
    private int[] popid;
    private boolean nopopinfo;
    private boolean labelpop = false;
    private Color[] colors;
    private int file_x;
    private int file_y;

    public RstDraw(double[][] dArray, int[] nArray, int[] nArray2) {
        this.bWidth = 620 / dArray[0].length > 2 ? 620 / dArray[0].length : 2;
        this.setPreferredSize(new Dimension(this.bWidth * dArray[0].length + 100, this.rowHeight));
        this.xLength = this.bWidth * dArray[0].length + 20;
        this.setBackground(Color.white);
        this.plotdata = dArray;
        if (this.colors == null) {
            this.set_color(this.plotdata.length);
        }
        this.plotlabels = nArray;
        this.popid = nArray2;
        if (nArray2 == null) {
            this.nopopinfo = true;
        }
        this.setFont(new Font("TimesRoman", 0, 11));
        this.file_x = this.bWidth * dArray[0].length + 100;
        this.file_y = this.rowHeight;
    }

    public void reLoadData(double[][] dArray, int[] nArray, int[] nArray2, boolean bl) {
        this.single_row = bl;
        if (bl) {
            this.numRows = 1;
            this.bWidth = 620 / dArray[0].length > 2 ? 620 / dArray[0].length : 2;
            this.xLength = this.bWidth * dArray[0].length + 20;
            this.setPreferredSize(new Dimension(this.bWidth * dArray[0].length + 100, this.numRows * this.rowHeight));
            this.file_x = this.bWidth * dArray[0].length + 100;
            this.file_y = this.numRows * this.rowHeight;
        } else {
            this.bWidth = 25;
            double d = (double)dArray[0].length / (double)this.numBins;
            this.numRows = dArray[0].length / this.numBins + 1;
            if (d == Math.floor(d)) {
                --this.numRows;
            }
            this.setPreferredSize(new Dimension(this.bWidth * this.numBins + 100, this.numRows * this.rowHeight));
            this.xLength = this.bWidth * this.numBins + 20;
            this.file_x = this.bWidth * this.numBins + 100;
            this.file_y = this.numRows * this.rowHeight;
        }
        this.plotdata = dArray;
        if (this.colors == null) {
            this.set_color(this.plotdata.length);
        }
        this.plotlabels = nArray;
        this.popid = nArray2;
        if (nArray2 == null) {
            this.nopopinfo = true;
        }
        this.repaint();
    }

    private void set_color(int n) {
        int n2;
        this.colors = new Color[n];
        for (n2 = 0; n2 < n; ++n2) {
            this.colors[n2] = null;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 == 0) {
                this.colors[n2] = new Color(1.0f, 0.0f, 0.0f);
            }
            if (n2 == 1) {
                this.colors[n2] = new Color(0.0f, 1.0f, 0.0f);
            }
            if (n2 == 2) {
                this.colors[n2] = new Color(0.0f, 0.0f, 1.0f);
            }
            if (n2 == 3) {
                this.colors[n2] = new Color(1.0f, 1.0f, 0.0f);
            }
            if (n2 == 4) {
                this.colors[n2] = new Color(1.0f, 0.0f, 1.0f);
            }
            if (n2 == 5) {
                this.colors[n2] = new Color(0.0f, 1.0f, 1.0f);
            }
            if (n2 == 6) {
                this.colors[n2] = new Color(0.98f, 0.6f, 0.0f);
            }
            if (n2 == 7) {
                this.colors[n2] = new Color(0.5f, 0.25f, 0.37f);
            }
            if (n2 == 8) {
                this.colors[n2] = new Color(0.98f, 0.6f, 0.37f);
            }
            if (n2 == 9) {
                this.colors[n2] = new Color(0.1f, 0.6f, 0.75f);
            }
            if (n2 <= 9) continue;
            this.colors[n2] = this.randomize_color();
        }
    }

    private Color randomize_color() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        Random random = new Random();
        while (this.exist_in_colormap(f = random.nextFloat(), f2 = random.nextFloat(), f3 = random.nextFloat())) {
        }
        return new Color(f, f2, f3);
    }

    private boolean exist_in_colormap(float f, float f2, float f3) {
        for (int i = 0; i < this.colors.length; ++i) {
            float f4;
            float f5;
            if (this.colors[i] == null) {
                return false;
            }
            float f6 = (float)this.colors[i].getRed() / 255.0f;
            float f7 = (f6 - f) * (f6 - f) + ((f5 = (float)this.colors[i].getGreen() / 255.0f) - f2) * (f5 - f2) + ((f4 = (float)this.colors[i].getBlue() / 255.0f) - f3) * (f4 - f3);
            if (!((double)f7 <= 0.02)) continue;
            return true;
        }
        return false;
    }

    public void paintComponent(Graphics graphics) {
        this.clear(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (int i = 0; i < this.plotdata.length; ++i) {
            this.drawData(graphics2D, this.plotdata[i], this.colors[i]);
        }
        this.drawFrame(graphics2D);
        if (!this.single_row) {
            this.drawLabel(graphics2D, this.plotlabels);
        }
        if (this.labelpop) {
            this.labelPop(graphics2D);
        }
    }

    private void drawFrame(Graphics2D graphics2D) {
        String[] stringArray = new String[]{"1.00", "0.80", "0.60", "0.40", "0.20", "0.00"};
        if (this.single_row) {
            this.numRows = 1;
        }
        for (int i = 0; i < this.numRows; ++i) {
            int n = 40;
            int n2 = i * this.rowHeight + 30;
            graphics2D.drawLine(n, n2 - 5, n, n2 + this.yHeight);
            graphics2D.drawLine(n, n2 + this.yHeight, n + this.xLength, n2 + this.yHeight);
            for (int j = 0; j < 6; ++j) {
                graphics2D.drawLine(n - this.anchorLength, n2 + j * this.yHeight / 5, n, n2 + j * this.yHeight / 5);
                graphics2D.drawString(stringArray[j], n - this.anchorLength - 30, n2 + j * this.yHeight / 5 + 3);
            }
        }
    }

    private void drawData(Graphics2D graphics2D, double[] dArray, Color color) {
        for (int i = 0; i < dArray.length; ++i) {
            int n = 0;
            int n2 = i;
            if (!this.single_row) {
                n = i / this.numBins;
                n2 = i % this.numBins;
            }
            int n3 = (int)(dArray[i] * (double)this.bhFactor);
            int n4 = 40 + n2 * this.bWidth;
            int n5 = n * this.rowHeight + 30 + this.yHeight - n3;
            graphics2D.setColor(color);
            graphics2D.fillRect(n4, n5, this.bWidth, n3);
            graphics2D.setColor(Color.black);
            if (this.single_row) continue;
            graphics2D.drawRect(n4, n5, this.bWidth, n3);
        }
    }

    private void drawLabel(Graphics2D graphics2D, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = i / this.numBins;
            int n2 = i % this.numBins;
            int n3 = 40 + n2 * this.bWidth + this.bWidth / 2;
            int n4 = n * this.rowHeight + 30 + this.yHeight;
            graphics2D.drawLine(n3, n4, n3, n4 + this.anchorLength);
            int n5 = 0;
            if (i % 2 == 1) {
                n5 = 2 * this.anchorLength;
            }
            if (this.nopopinfo) {
                graphics2D.drawString(new String("" + nArray[i]), n3 - this.anchorLength, n4 + 3 * this.anchorLength + n5);
                continue;
            }
            graphics2D.drawString(new String("" + nArray[i] + "(" + this.popid[i] + ")"), n3 - this.anchorLength, n4 + 3 * this.anchorLength + n5);
        }
    }

    public void setPoplabel(boolean bl) {
        this.labelpop = bl;
    }

    private void labelPop(Graphics graphics) {
        if (this.nopopinfo) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.popid.length; ++i) {
            if ((i <= 0 || this.popid[i] == this.popid[i - 1]) && (i == 0 || i != this.popid.length - 1)) continue;
            int n3 = i - (i - 1 - n) / 2;
            int n4 = 40 + n3 * this.bWidth + this.bWidth / 2;
            int n5 = 30 + this.yHeight;
            graphics.drawLine(n4, n5, n4, n5 + this.anchorLength);
            graphics.drawString(new String("" + this.popid[i - 1]), n4 - this.anchorLength, n5 + 3 * this.anchorLength + n2 % 2 * this.anchorLength);
            n = i;
            ++n2;
            n4 = 40 + i * this.bWidth;
            if (i != this.popid.length - 1) {
                graphics.drawLine(n4, n5, n4, n5 - this.yHeight);
                continue;
            }
            graphics.drawLine(n4 + this.bWidth, n5, n4 + this.bWidth, n5 - this.yHeight);
        }
    }

    protected void clear(Graphics graphics) {
        super.paintComponent(graphics);
    }

    protected void saveImage(String string) {
        BufferedImage bufferedImage = new BufferedImage(this.file_x, this.file_y, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        this.paint(graphics2D);
        try {
            File file = new File(string);
            JimiRasterImage jimiRasterImage = Jimi.createRasterImage(bufferedImage.getSource());
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fileOutputStream != null) {
                Jimi.putImage("image/jpeg", (JimiImage)jimiRasterImage, (OutputStream)fileOutputStream);
            }
        }
        catch (JimiException jimiException) {
            jimiException.printStackTrace();
        }
    }
}

