/*
 * Decompiled with CFR 0.152.
 */
package Proc;

import Gui.MainFrame;
import Gui.ProjTree;
import Obj.NSimObj;
import Obj.PlotData;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class AppProc
extends Thread {
    private String appName;
    private String str;
    private Process proc;
    private ProjTree projTree;
    private MainFrame target;
    private NSimObj sim;
    private boolean record;
    private boolean end;
    private boolean isKilled;
    private boolean isStarted;
    private boolean isFast;
    private boolean recStart;
    private boolean lnpdStart;
    private boolean alpha_decide;
    private int maxdata;
    private int freq;
    private int alphacount;
    private int fstcount;
    private int reccount;
    private int likcount;
    private int lnpdcount;
    private Vector[] fst;
    private double[][] fstHist;
    private Vector[] alpha;
    private double[][] alphaHist;
    private double[] lnpdHist;
    private double[] likHist;
    private double[] recHist;
    private Vector recmb;
    private Vector llhd;
    private Vector lnpd;
    private boolean controlGui;

    public AppProc(String string, MainFrame mainFrame, ProjTree projTree, NSimObj nSimObj, boolean bl) {
        int n;
        this.appName = string;
        this.controlGui = bl;
        this.target = mainFrame;
        this.sim = nSimObj;
        this.projTree = projTree;
        int n2 = 0;
        this.maxdata = 1;
        if (!nSimObj.FREQSCORR) {
            this.fst = null;
            this.fstHist = null;
        } else {
            n2 = nSimObj.ONEFST ? 1 : nSimObj.getMAXPOPS();
            this.maxdata += n2;
            this.fst = new Vector[n2];
            this.fstHist = new double[n2][];
            for (n = 0; n < n2; ++n) {
                this.fst[n] = new Vector();
                this.fstHist[n] = new double[nSimObj.NUMREPS];
            }
            n2 = 0;
        }
        if (nSimObj.NOADMIX || nSimObj.POPNOADMIX) {
            this.alpha = null;
            this.alphaHist = null;
        } else {
            n2 = nSimObj.POPALPHAS ? nSimObj.getMAXPOPS() : 1;
            if (!nSimObj.INFERALPHA) {
                n2 = 1;
            }
            this.maxdata += n2;
            this.alpha = new Vector[n2];
            this.alphaHist = new double[n2][];
            for (n = 0; n < n2; ++n) {
                this.alpha[n] = new Vector();
                this.alphaHist[n] = new double[nSimObj.NUMREPS];
            }
            n2 = 0;
        }
        if (nSimObj.RECOMBINE || nSimObj.POPRECOMBINE) {
            this.recmb = new Vector();
            this.recHist = new double[nSimObj.NUMREPS];
            ++this.maxdata;
            this.alpha = new Vector[1];
            this.alpha[0] = new Vector();
            this.alphaHist = new double[1][];
            this.alphaHist[0] = new double[nSimObj.NUMREPS];
        } else {
            this.recmb = null;
            this.recHist = null;
        }
        if (nSimObj.COMPUTEPROB) {
            this.llhd = new Vector();
            this.likHist = new double[nSimObj.NUMREPS];
            this.lnpd = new Vector();
            this.lnpdHist = new double[nSimObj.NUMREPS];
            this.maxdata += 2;
        } else {
            this.llhd = null;
            this.likHist = null;
            this.lnpd = null;
            this.lnpdHist = null;
        }
        this.freq = (nSimObj.BURNIN + nSimObj.NUMREPS) / 2000;
        if (this.freq < 1) {
            this.freq = 1;
        }
    }

    public void run() {
        try {
            this.proc = Runtime.getRuntime().exec(this.appName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
            TextArea textArea = this.target.getConsole();
            textArea.setText("");
            this.record = false;
            this.end = false;
            this.isKilled = false;
            this.isStarted = false;
            this.isFast = false;
            this.lnpdStart = false;
            this.recStart = false;
            this.alpha_decide = false;
            this.fstcount = 0;
            this.alphacount = 0;
            if (this.controlGui) {
                this.target.updateUI(3);
            }
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    this.parseData(string);
                }
                if (this.proc != null) {
                    this.projTree.appendRstNode(this.sim.getSimName(), this.sim.getRstName(), this.sim.getMAXPOPS());
                    this.savePlotData();
                }
                if (this.controlGui) {
                    this.target.updateUI(2);
                }
            }
            catch (IOException iOException) {
                System.exit(0);
                return;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private void parseData(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            if (!this.record) {
                this.target.getConsole().append(string + "\n");
            }
            return;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("Rep#:")) {
            if (!this.record) {
                StringTokenizer stringTokenizer2;
                this.target.getConsole().append(string + "\n");
                if (!this.alpha_decide && this.sim.USEPOPINFO && this.alpha != null) {
                    stringTokenizer2 = new StringTokenizer(string);
                    stringTokenizer2.nextToken();
                    boolean bl = false;
                    while (stringTokenizer2.hasMoreTokens()) {
                        String string3 = stringTokenizer2.nextToken();
                        if (string3.length() < 5 || !string3.substring(0, 5).equals("Alpha")) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.alpha = null;
                        this.alphaHist = null;
                    }
                    stringTokenizer2 = null;
                    this.alpha_decide = true;
                }
                if (!this.recStart && this.sim.RECOMBINE) {
                    stringTokenizer2 = new StringTokenizer(string);
                    stringTokenizer2.nextToken();
                    String string4 = stringTokenizer2.nextToken();
                    if (string4 != null && string4.equals("Rec")) {
                        this.recStart = true;
                    }
                }
            }
            this.record = true;
            this.isStarted = true;
            return;
        }
        if (string2.equals("MCMC")) {
            this.record = false;
            this.end = true;
            this.target.getConsole().append("\n\n" + string + "\n");
            return;
        }
        if (!this.record) {
            this.target.getConsole().append(string + "\n");
            return;
        }
        if (string2.equals("No")) {
            this.recStart = true;
            this.target.getConsole().append("\n" + string + "\n\n");
            this.record = false;
            return;
        }
        if (string2.equals("Admixture")) {
            this.target.getConsole().append("\n" + string + "\n");
            this.record = false;
            return;
        }
        if (string2.equals("BURNIN")) {
            this.target.getConsole().append("\n" + string + "\n\n");
            this.record = false;
            this.lnpdStart = true;
            return;
        }
        if (string2.endsWith(":")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n % this.freq != 0 && !this.lnpdStart) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement(string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (n % this.freq == 0) {
            this.storeData(vector);
        }
        if (this.lnpdStart) {
            this.parseHistData(vector);
        }
        if (n % 100 == 0) {
            this.target.getConsole().append(string + "\n");
        }
    }

    private void parseHistData(Vector vector) {
        double d;
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = 1;
        int n2 = vector.size();
        if (n >= n2) {
            return;
        }
        if (this.recStart) {
            if (this.recHist != null) {
                try {
                    d = Double.parseDouble((String)vector.elementAt(n));
                    if (this.reccount < this.recHist.length) {
                        this.recHist[this.reccount++] = d;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException);
                }
            }
            ++n;
        }
        if (n >= n2) {
            return;
        }
        if (this.alphaHist != null) {
            for (int i = 0; i < this.alphaHist.length; ++i) {
                try {
                    double d2 = Double.parseDouble((String)vector.elementAt(n++));
                    if (this.alphacount >= this.alphaHist[i].length) continue;
                    this.alphaHist[i][this.alphacount] = d2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException);
                }
            }
            ++this.alphacount;
        }
        if (this.fstHist != null) {
            for (int i = 0; i < this.fstHist.length; ++i) {
                try {
                    double d3 = Double.parseDouble((String)vector.elementAt(n++));
                    if (this.fstcount >= this.fstHist[i].length) continue;
                    this.fstHist[i][this.fstcount] = d3;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException);
                }
            }
            ++this.fstcount;
        }
        if (this.likHist != null) {
            try {
                d = Double.parseDouble((String)vector.elementAt(n++));
                if (this.likcount < this.likHist.length) {
                    this.likHist[this.likcount++] = d;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException);
            }
        }
        if (n >= n2 && this.sim.COMPUTEPROB) {
            this.lnpdHist = new double[this.lnpdHist.length - 1];
            return;
        }
        if (this.lnpdHist != null) {
            try {
                double d4 = Double.parseDouble((String)vector.elementAt(n));
                if (this.lnpdcount < this.lnpdHist.length) {
                    this.lnpdHist[this.lnpdcount++] = d4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException);
            }
        }
    }

    private void storeData(Vector vector) {
        int n;
        if (vector == null || vector.size() == 0) {
            return;
        }
        String string = (String)vector.elementAt(0);
        int n2 = 1;
        int n3 = vector.size();
        if (n2 >= n3) {
            return;
        }
        if (this.recStart) {
            this.recmb.addElement(string);
            this.recmb.addElement(vector.elementAt(n2++));
        }
        if (n2 >= n3) {
            return;
        }
        if (this.alpha != null) {
            for (n = 0; n < this.alpha.length; ++n) {
                this.alpha[n].addElement(string);
                this.alpha[n].addElement(vector.elementAt(n2++));
            }
        }
        if (n2 >= n3) {
            return;
        }
        if (this.fst != null) {
            for (n = 0; n < this.fst.length; ++n) {
                this.fst[n].addElement(string);
                this.fst[n].addElement(vector.elementAt(n2++));
            }
        }
        if (n2 >= n3) {
            return;
        }
        if (this.llhd != null) {
            this.llhd.addElement(string);
            this.llhd.addElement(vector.elementAt(n2++));
        }
        if (n2 >= n3) {
            return;
        }
        if (this.lnpdStart && this.lnpd != null) {
            this.lnpd.addElement(string);
            this.lnpd.addElement(vector.elementAt(n2));
        }
    }

    public double[] getNewData(String string, int n, int n2) {
        Vector vector = null;
        if (string.equals("Fst")) {
            if (this.fst == null) {
                return null;
            }
            if (n >= this.fst.length) {
                return null;
            }
            vector = this.fst[n];
        }
        if (string.equals("Alpha")) {
            if (this.alpha == null) {
                return null;
            }
            if (n >= this.alpha.length) {
                return null;
            }
            vector = this.alpha[n];
        }
        if (string.equals("Rec")) {
            if (this.recmb == null) {
                return null;
            }
            vector = this.recmb;
        }
        if (string.equals("Like")) {
            vector = this.llhd;
        }
        if (string.equals("LnPD")) {
            vector = this.lnpd;
        }
        if (vector.size() < n2 + 2) {
            return null;
        }
        this.isFast = vector.size() >= n2 + 4;
        double[] dArray = new double[2];
        try {
            dArray[0] = Double.parseDouble((String)vector.elementAt(n2));
            dArray[1] = Double.parseDouble((String)vector.elementAt(n2 + 1));
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(numberFormatException);
        }
        return dArray;
    }

    private double[] getHistData(String string, int n) {
        if (string.equals("Fst")) {
            if (this.fstHist == null) {
                return null;
            }
            if (n >= this.fstHist.length) {
                return null;
            }
            return this.fstHist[n];
        }
        if (string.equals("Alpha")) {
            if (this.alphaHist == null) {
                return null;
            }
            if (n >= this.alphaHist.length) {
                return null;
            }
            return this.alphaHist[n];
        }
        if (string.equals("Rec")) {
            return this.recHist;
        }
        if (string.equals("Like")) {
            return this.likHist;
        }
        if (string.equals("Lnpd")) {
            return this.lnpdHist;
        }
        return null;
    }

    private Vector getDataSet(String string, int n) {
        Vector vector = null;
        if (string.equals("Fst")) {
            if (this.fst == null) {
                return null;
            }
            if (n >= this.fst.length) {
                return null;
            }
            vector = this.fst[n];
        }
        if (string.equals("Alpha")) {
            if (this.alpha == null) {
                return null;
            }
            if (n >= this.alpha.length) {
                return null;
            }
            vector = this.alpha[n];
        }
        if (string.equals("Rec")) {
            if (this.recmb == null) {
                return null;
            }
            vector = this.recmb;
        }
        if (string.equals("Like")) {
            vector = this.llhd;
        }
        if (string.equals("LnPD")) {
            vector = this.lnpd;
        }
        return vector;
    }

    public boolean isEnd() {
        return this.end;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isRecStarted() {
        return this.recStart;
    }

    public boolean isKilled() {
        return this.isKilled;
    }

    public boolean isFast() {
        return this.isFast;
    }

    public boolean isBurinFinished() {
        return this.lnpdStart;
    }

    private double[] vec2logarray(Vector vector) {
        if (vector == null) {
            return null;
        }
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            try {
                dArray[i] = Double.parseDouble((String)vector.elementAt(i));
                if (i % 2 != 1) continue;
                dArray[i] = Math.log(dArray[i]) / Math.log(10.0);
                continue;
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        return dArray;
    }

    private double[] vec2array(Vector vector) {
        if (vector == null) {
            return null;
        }
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            try {
                dArray[i] = Double.parseDouble((String)vector.elementAt(i));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException);
            }
        }
        return dArray;
    }

    private void savePlotData() {
        PlotData plotData;
        Object object;
        String string = this.sim.getSimPath();
        File file = new File(string, "PlotData");
        String string2 = file.getAbsolutePath();
        if (this.fst != null) {
            object = new double[this.fst.length][];
            for (int i = 0; i < ((double[][])object).length; ++i) {
                object[i] = this.vec2array(this.fst[i]);
            }
            plotData = new PlotData((double[][])object);
            plotData.writeDataFile(string2, this.sim.getRstName() + "_fst");
        }
        if (this.alpha != null) {
            object = new double[this.alpha.length][];
            for (int i = 0; i < ((double[][])object).length; ++i) {
                object[i] = this.vec2logarray(this.alpha[i]);
            }
            plotData = new PlotData((double[][])object);
            plotData.writeDataFile(string2, this.sim.getRstName() + "_alpha");
        }
        if (this.llhd != null) {
            object = new double[][]{this.vec2array(this.llhd)};
            plotData = new PlotData((double[][])object);
            plotData.writeDataFile(string2, this.sim.getRstName() + "_lhd");
        }
        if (this.recmb != null) {
            object = new double[][]{this.vec2array(this.recmb)};
            plotData = new PlotData((double[][])object);
            plotData.writeDataFile(string2, this.sim.getRstName() + "_recmb");
        }
        if (this.lnpd != null) {
            object = new double[][]{this.vec2array(this.lnpd)};
            plotData = new PlotData((double[][])object);
            plotData.writeDataFile(string2, this.sim.getRstName() + "_lnpd");
        }
        if (this.fstHist != null) {
            object = new PlotData(this.fstHist);
            object.writeDataFile(string2, this.sim.getRstName() + "_fsthist");
        }
        if (this.alphaHist != null) {
            object = new PlotData(this.alphaHist);
            object.writeDataFile(string2, this.sim.getRstName() + "_alphahist");
        }
        if (this.lnpdHist != null) {
            object = new double[][]{this.lnpdHist};
            plotData = new PlotData((double[][])object);
            plotData.writeDataFile(string2, this.sim.getRstName() + "_lnpdhist");
        }
        if (this.recHist != null) {
            object = new double[][]{this.recHist};
            plotData = new PlotData((double[][])object);
            plotData.writeDataFile(string2, this.sim.getRstName() + "_recmbhist");
        }
        if (this.likHist != null) {
            object = new double[][]{this.likHist};
            plotData = new PlotData((double[][])object);
            plotData.writeDataFile(string2, this.sim.getRstName() + "_lhdhist");
        }
    }

    public void killProc() {
        if (this.proc != null) {
            this.proc.destroy();
        }
        this.proc = null;
        if (this.controlGui) {
            this.target.updateUI(2);
        }
        this.isKilled = true;
        super.stop();
    }
}

