/*
 * Decompiled with CFR 0.152.
 */
package jas.util.pluginmanager;

import jas.swingstudio.JavaAnalysisStudio;
import jas.util.JASDialog;
import jas.util.JASState;
import jas.util.pluginmanager.PluginDownloadProgress;
import jas.util.pluginmanager.PluginManager;
import jas.util.pluginmanager.PluginManagerUI;
import jas.util.pluginmanager.PluginProperties;
import jas.util.pluginmanager.VersionNumberCompare;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InstallPluginsUI
extends JASDialog {
    private static JFrame frame;
    private PluginProperties[] plugins;
    private PluginManager pluginmanager;
    private PluginManagerUI pluginmanagerui;
    private JList pluginslist;
    private JLabel name;
    private JLabel author;
    private JLabel version;
    private JLabel requires;
    private JTextArea description;
    private JRadioButton installUser;
    private JRadioButton installSystem;
    private JButton install;
    private Thread installguithread;
    private Container c;
    private boolean accessdirs;

    public InstallPluginsUI(PluginManager pluginManager, PluginManagerUI pluginManagerUI) {
        super((Frame)frame, "Install Plugins", true, 13);
        this.pluginmanager = pluginManager;
        this.pluginmanagerui = pluginManagerUI;
        this.showInstallUI();
    }

    private void showInstallUI() {
        super.setHelpTopic("userInterface.pluginmanager");
        this.c = this.getContentPane();
        this.c.removeAll();
        this.c.setLayout(new BorderLayout());
        this.c.add("North", new JLabel("The following plugins are available for installation"));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.pluginslist = new JList();
        this.pluginslist.setCellRenderer(new Renderer());
        this.pluginslist.setVisibleRowCount(8);
        this.pluginslist.addListSelectionListener(new ListHandler());
        jPanel.add("Center", new JScrollPane(this.pluginslist));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(5, 1));
        jPanel3.add(new JLabel("Name: ", 4));
        jPanel3.add(new JLabel("Author: ", 4));
        jPanel3.add(new JLabel("Version: ", 4));
        jPanel3.add(new JLabel("Requires: ", 4));
        jPanel3.add(new JLabel("Description ", 4));
        jPanel2.add("West", jPanel3);
        JPanel jPanel4 = new JPanel(new GridLayout(5, 1));
        this.name = new JLabel();
        jPanel4.add(this.name);
        this.author = new JLabel();
        jPanel4.add(this.author);
        this.version = new JLabel();
        jPanel4.add(this.version);
        this.requires = new JLabel();
        jPanel4.add(this.requires);
        jPanel4.add(Box.createGlue());
        jPanel2.add("Center", jPanel4);
        this.description = new JTextArea(6, 30);
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add("North", new JScrollPane(this.description));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.installUser = new JRadioButton();
        this.installUser.setText("Install in user directory: " + this.pluginmanager.getUserDirectory());
        buttonGroup.add(this.installUser);
        jPanel5.add("Center", this.installUser);
        this.installSystem = new JRadioButton("Install in system directory: " + this.pluginmanager.getSystemDirectory());
        buttonGroup.add(this.installSystem);
        jPanel5.add("South", this.installSystem);
        this.accessdirs = this.checkFileAccess();
        this.install = new JButton("Install selected plugins");
        this.install.setEnabled(false);
        this.getRootPane().setDefaultButton(this.install);
        this.install.addActionListener(new ActionHandler());
        Box box = new Box(0);
        box.add(Box.createGlue());
        box.add(this.install);
        box.add(Box.createGlue());
        jPanel2.add("South", jPanel5);
        jPanel.add("South", jPanel2);
        this.c.add("Center", jPanel);
        this.c.add("South", box);
        this.updateList();
        this.show();
    }

    private boolean checkFileAccess() {
        boolean bl = false;
        boolean bl2 = false;
        File file = new File(this.pluginmanager.getSystemDirectory());
        File file2 = new File(this.pluginmanager.getUserDirectory());
        if (!file.exists()) {
            file = new File(file.getParent());
        }
        if (!file2.exists()) {
            file2 = new File(file2.getParent());
        }
        if (file2.canWrite()) {
            bl2 = true;
        }
        if (file.canWrite()) {
            bl = true;
        }
        if (bl & bl2) {
            this.installSystem.setSelected(true);
            return true;
        }
        if (bl2) {
            this.installSystem.setEnabled(false);
            this.installUser.setSelected(true);
            return true;
        }
        if (bl) {
            this.installUser.setEnabled(false);
            this.installSystem.setSelected(true);
            return true;
        }
        this.installUser.setEnabled(false);
        this.installSystem.setEnabled(false);
        return false;
    }

    private void updateList() {
        Vector vector = this.pluginmanager.getNotInstalledPluginList();
        this.plugins = new PluginProperties[vector.size()];
        vector.copyInto(this.plugins);
        if (this.plugins != null) {
            this.pluginslist.setListData(this.plugins);
        }
        this.pack();
    }

    private Object[] checkSelectedPlugins() {
        Object[] objectArray = this.pluginslist.getSelectedValues();
        Vector<PluginProperties> vector = new Vector<PluginProperties>();
        VersionNumberCompare versionNumberCompare = new VersionNumberCompare();
        int n = 0;
        while (n < objectArray.length) {
            PluginProperties pluginProperties = (PluginProperties)objectArray[n];
            try {
                int n2 = versionNumberCompare.compareVersions(JavaAnalysisStudio.getVersionNumber(), pluginProperties.minJASversion, false);
                if (n2 == 1) {
                    Object[] objectArray2 = new String[]{"OK"};
                    String string = pluginProperties.name + " requires JAS version " + pluginProperties.minJASversion + " or greater. Latest JAS version available at www-sldnt.slac.stanford.edu/jas.";
                    int n3 = JOptionPane.showOptionDialog(this.c, string, "Installing Plugins", -1, 0, null, objectArray2, objectArray2[0]);
                } else if (n2 != 1 & n2 != 0) {
                    vector.addElement(pluginProperties);
                }
            }
            catch (VersionNumberCompare.VersionCompareException versionCompareException) {
                // empty catch block
            }
            ++n;
        }
        if (vector.size() > 0) {
            Object[] objectArray3 = new Object[vector.size()];
            vector.copyInto(objectArray3);
            return objectArray3;
        }
        return null;
    }

    private String makeInstallDirectories() {
        if (this.installUser.isSelected()) {
            String string = this.pluginmanager.getUserDirectory();
            File file = new File(string);
            if (!file.isDirectory()) {
                file.mkdir();
            }
            return string;
        }
        String string = this.pluginmanager.getSystemDirectory();
        File file = new File(string);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        return string;
    }

    public void onOK() {
        if (this.installguithread != null) {
            this.installguithread.stop();
            this.installguithread = null;
        }
        this.dispose();
    }

    protected void enableHelp(JASState jASState) {
        jASState.setEnabled(true);
    }

    public void onCancel() {
        if (this.installguithread != null) {
            this.installguithread.stop();
            this.installguithread = null;
        }
        this.dispose();
    }

    static /* synthetic */ PluginManagerUI access$200(InstallPluginsUI installPluginsUI) {
        return installPluginsUI.pluginmanagerui;
    }

    static /* synthetic */ void access$300(InstallPluginsUI installPluginsUI) {
        installPluginsUI.updateList();
    }

    class Renderer
    extends JLabel
    implements ListCellRenderer {
        Renderer() {
            this.setOpaque(true);
            this.setFont(UIManager.getFont("Tree.font"));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof PluginProperties) {
                this.setText(((PluginProperties)object).name);
            }
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object e = InstallPluginsUI.this.pluginslist.getSelectedValue();
            if (e instanceof PluginProperties) {
                InstallPluginsUI.this.install.setEnabled(true);
                PluginProperties pluginProperties = (PluginProperties)e;
                InstallPluginsUI.this.name.setText(pluginProperties.name);
                InstallPluginsUI.this.author.setText(pluginProperties.author);
                InstallPluginsUI.this.version.setText(pluginProperties.latestversion);
                InstallPluginsUI.this.requires.setText(pluginProperties.requires);
                InstallPluginsUI.this.description.setText(pluginProperties.description);
            } else {
                InstallPluginsUI.this.install.setEnabled(false);
                InstallPluginsUI.this.name.setText(null);
                InstallPluginsUI.this.author.setText(null);
                InstallPluginsUI.this.version.setText(null);
                InstallPluginsUI.this.requires.setText(null);
                InstallPluginsUI.this.description.setText(null);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == InstallPluginsUI.this.install) {
                if (!InstallPluginsUI.this.accessdirs) {
                    Object[] objectArray = new String[]{"OK"};
                    int n = JOptionPane.showOptionDialog(InstallPluginsUI.this.c, "You do not have write access to an install directory.", "Installing Plugins", -1, 0, null, objectArray, objectArray[0]);
                } else {
                    Object[] objectArray = InstallPluginsUI.this.checkSelectedPlugins();
                    if (objectArray != null) {
                        InstallPluginsUI.this.installguithread = new InstallGUIThread(objectArray);
                        InstallPluginsUI.this.installguithread.start();
                    }
                }
            }
        }
    }

    class InstallGUIThread
    extends Thread {
        PluginDownloadProgress pdlp;
        Object[] selected;
        String path;

        InstallGUIThread(Object[] objectArray) {
            this.selected = objectArray;
        }

        public void run() {
            this.path = InstallPluginsUI.this.makeInstallDirectories();
            this.pdlp = new PluginDownloadProgress(this.selected, this.path);
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ InstallGUIThread this$1;
                {
                    this.this$1 = installGUIThread;
                }

                public void run() {
                    InstallPluginsUI.access$200(InstallGUIThread.access$100(this.this$1)).updateTree();
                    InstallPluginsUI.access$300(InstallGUIThread.access$100(this.this$1));
                    InstallGUIThread.access$100(this.this$1).show();
                }
            });
        }

        static /* synthetic */ InstallPluginsUI access$100(InstallGUIThread installGUIThread) {
            return installGUIThread.InstallPluginsUI.this;
        }
    }
}

