/*
 * Decompiled with CFR 0.152.
 */
package jas.util.pluginmanager;

import jas.util.pluginmanager.PluginDownloadProgress;
import jas.util.pluginmanager.PluginProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JOptionPane;

public class PluginDownloadThread
extends Thread {
    private PluginDownloadProgress progress;
    private String path;
    private Object[] plugins;
    private JOptionPane minversionpane;
    boolean stopthread;

    public PluginDownloadThread(PluginDownloadProgress pluginDownloadProgress, Object[] objectArray, String string) {
        super("Plugin downloader");
        this.path = string;
        this.plugins = objectArray;
        this.progress = pluginDownloadProgress;
        this.start();
    }

    public void run() {
        if (this.stopthread) {
            return;
        }
        int n = 0;
        while (n < this.plugins.length) {
            if (this.stopthread) {
                return;
            }
            try {
                Object object = this.plugins[n];
                if (object instanceof PluginProperties) {
                    PluginProperties pluginProperties = (PluginProperties)object;
                    File file = this.path.compareTo("update") == 0 ? new File(pluginProperties.path) : new File(this.path);
                    int n2 = 0;
                    while (n2 < pluginProperties.urldownloads.length) {
                        if (this.stopthread) {
                            return;
                        }
                        URL uRL = pluginProperties.urldownloads[n2];
                        String string = pluginProperties.files[n2];
                        this.progress.downloading(string);
                        this.download(file.getPath() + "/" + string, uRL);
                        ++n2;
                    }
                    if (this.stopthread) {
                        return;
                    }
                    this.progress.done();
                }
            }
            catch (IOException iOException) {
                this.progress.onCancel();
                System.out.println(iOException);
            }
            catch (Exception exception) {
                this.progress.onCancel();
                System.out.println(exception);
            }
            ++n;
        }
    }

    private void download(String string, URL uRL) throws Exception {
        URLConnection uRLConnection = uRL.openConnection();
        this.progress.setMaximum(Math.max(0, uRLConnection.getContentLength()));
        this.copy(uRLConnection.getInputStream(), new FileOutputStream(string), true, true);
    }

    private void copy(InputStream inputStream, OutputStream outputStream, boolean bl, boolean bl2) throws Exception {
        int n;
        inputStream = new BufferedInputStream(inputStream);
        outputStream = new BufferedOutputStream(outputStream);
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n);
            if (bl2) {
                this.progress.setValue(n2 += n);
            }
            if (!bl || !this.stopthread) continue;
            inputStream.close();
            outputStream.close();
            return;
        }
        inputStream.close();
        outputStream.close();
    }

    void stopRequest() {
        this.stopthread = true;
    }
}

