/*
 * Decompiled with CFR 0.152.
 */
package Gui;

import Controller.StructureApp;
import Gui.DataRowRenderer;
import Plot.RstPlotManager;
import Util.InFile;
import Util.Lexer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MainFrame
extends JFrame
implements ActionListener {
    private StructureApp app;
    private JSplitPane splitPane;
    private JScrollPane screenPane;
    private JScrollPane listScrollPane;
    private JDesktopPane rightPane;
    private TextArea console;
    private JInternalFrame dataframe;
    private JInternalFrame projframe;
    private JInternalFrame simframe;
    private JInternalFrame resultframe;
    private JInternalFrame rstplotframe;
    private JInternalFrame summaryframe;
    private JMenuBar rst_mbar;
    private FrameSetListener framelistener = new FrameSetListener();
    private RstPlotManager rm;
    private JMenuBar menuBar;
    private JToolBar toolBar;
    private JMenuItem load_rst_menu;
    private JMenuItem data_open_menu;
    private JMenuItem data_close_menu;
    private JMenuItem new_proj_menu;
    private JMenuItem open_proj_menu;
    private JMenuItem close_proj_menu;
    private JMenuItem save_proj_menu;
    private JMenuItem exit_menu;
    private JMenuItem print_menu;
    private JMenuItem copy_menu;
    private JMenuItem cut_menu;
    private JMenuItem paste_menu;
    private JMenuItem proj_job_menu;
    private JMenuItem proj_joblog_menu;
    private JMenuItem proj_killjob_menu;
    private JMenuItem proj_pgen_menu;
    private JMenuItem sim_param_menu;
    private JMenuItem sim_run_menu;
    private JMenuItem sim_stop_menu;
    private JMenuItem sim_new_menu;
    private JMenuItem sim_del_menu;
    private JMenu plot_data_menu;
    private JMenuItem data_fst_menu;
    private JMenuItem data_alpha_menu;
    private JMenuItem data_like_menu;
    private JMenuItem data_lnpd_menu;
    private JMenuItem data_rec_menu;
    private JMenuItem triangle_menu;
    private JMenuItem view_proj_menu;
    private JMenuItem view_sim_menu;
    private JMenuItem view_result_menu;
    private JMenuItem view_clear_menu;
    private JMenuItem help_topic_menu;
    private JMenuItem help_about_menu;
    private JButton open_proj_button;
    private JButton save_proj_button;
    private JButton new_proj_button;
    private JButton sim_run_button;
    private JButton sim_stop_button;
    private JButton sim_new_button;
    private JButton sim_del_button;
    private JButton help_topic_button;
    private File fc_dir;

    public MainFrame(StructureApp structureApp) {
        this.app = structureApp;
        this.createMenuItem();
    }

    private void createMenuItem() {
        Dimension dimension = new Dimension(23, 23);
        this.data_open_menu = new JMenuItem("Open Data File ...");
        this.load_rst_menu = new JMenuItem("Load structure results ...");
        this.data_close_menu = new JMenuItem("Close File");
        this.new_proj_menu = new JMenuItem("New Project ...");
        this.open_proj_menu = new JMenuItem("Open Project ...");
        this.close_proj_menu = new JMenuItem("Close Project");
        this.save_proj_menu = new JMenuItem("Save Project");
        this.exit_menu = new JMenuItem("Exit");
        this.print_menu = new JMenuItem("Print ...");
        this.open_proj_button = new JButton(new ImageIcon("images/New_Job.gif"));
        this.open_proj_button.setPreferredSize(dimension);
        this.open_proj_button.setToolTipText("Open Project");
        this.save_proj_button = new JButton(new ImageIcon("images/Save_All.gif"));
        this.save_proj_button.setPreferredSize(dimension);
        this.save_proj_button.setToolTipText("Save Project");
        this.new_proj_button = new JButton(new ImageIcon("images/New_Program_Wizard.gif"));
        this.new_proj_button.setToolTipText("New Project");
        this.new_proj_button.setPreferredSize(dimension);
        this.copy_menu = new JMenuItem("Copy");
        this.cut_menu = new JMenuItem("Cut");
        this.paste_menu = new JMenuItem("Paste");
        this.proj_job_menu = new JMenuItem("Start a Job");
        this.proj_joblog_menu = new JMenuItem("View Job Log");
        this.proj_killjob_menu = new JMenuItem("Kill Running Job");
        this.proj_pgen_menu = new JMenuItem("Generate parameter files...");
        this.sim_param_menu = new JMenuItem("Modify current set ...");
        this.sim_run_menu = new JMenuItem("Run");
        this.sim_stop_menu = new JMenuItem("Stop");
        this.sim_new_menu = new JMenuItem("New ... ");
        this.sim_del_menu = new JMenuItem("Remove Parameter Set ... ");
        this.sim_new_button = new JButton(new ImageIcon("images/new2.gif"));
        this.sim_new_button.setPreferredSize(dimension);
        this.sim_new_button.setToolTipText("New Parameter Set");
        this.sim_del_button = new JButton(new ImageIcon("images/delete.gif"));
        this.sim_del_button.setPreferredSize(dimension);
        this.sim_del_button.setToolTipText("Remove Parameter Set");
        this.sim_run_button = new JButton(new ImageIcon("images/Run.gif"));
        this.sim_run_button.setPreferredSize(dimension);
        this.sim_run_button.setToolTipText("Run");
        this.sim_stop_button = new JButton(new ImageIcon("images/Stop.gif"));
        this.sim_stop_button.setPreferredSize(dimension);
        this.sim_stop_button.setToolTipText("Stop");
        this.plot_data_menu = new JMenu("Run-time");
        this.data_fst_menu = new JMenuItem("Fst");
        this.data_alpha_menu = new JMenuItem("Alpha");
        this.data_like_menu = new JMenuItem("Likelihood");
        this.data_lnpd_menu = new JMenuItem("Ln P(D) ");
        this.data_rec_menu = new JMenuItem("Recombination Rate");
        this.triangle_menu = new JMenuItem("Triangle Plot");
        this.view_proj_menu = new JMenuItem("Project Info");
        this.view_sim_menu = new JMenuItem("Active Parameter Set Info");
        this.view_result_menu = new JMenuItem("Simulation Summary");
        this.view_clear_menu = new JMenuItem("Clear Output Console");
        this.help_topic_menu = new JMenuItem("Help Document");
        this.help_about_menu = new JMenuItem("About Structure");
        this.help_topic_button = new JButton(new ImageIcon("images/Home.gif"));
        this.help_topic_button.setPreferredSize(dimension);
        this.help_topic_button.setToolTipText("About Structure");
    }

    public JSplitPane createPane(int n, int n2) {
        this.listScrollPane = new JScrollPane();
        this.listScrollPane.getViewport().add(this.app.getProjTree());
        this.rightPane = new JDesktopPane();
        this.console = new TextArea(5, 5);
        this.console.setBackground(Color.black);
        this.console.setForeground(Color.white);
        this.console.setEditable(false);
        this.screenPane = new JScrollPane(this.console);
        JSplitPane jSplitPane = new JSplitPane(1, this.listScrollPane, this.rightPane);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(n / 4);
        Dimension dimension = new Dimension(n / 8, n2 / 6);
        this.listScrollPane.setMinimumSize(dimension);
        this.rightPane.setMinimumSize(dimension);
        this.screenPane.setMinimumSize(dimension);
        jSplitPane.setPreferredSize(new Dimension(6 * n / 7, 5 * n2 / 7));
        this.screenPane.setMaximumSize(dimension);
        this.splitPane = new JSplitPane(0, jSplitPane, this.screenPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(4 * n2 / 7);
        return this.splitPane;
    }

    public JMenuBar createMenuBar() {
        this.menuBar = new JMenuBar();
        this.toolBar = new JToolBar();
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("Edit");
        JMenu jMenu3 = new JMenu("Project");
        JMenu jMenu4 = new JMenu("Parameter Set");
        JMenu jMenu5 = new JMenu("View");
        JMenu jMenu6 = new JMenu("Help");
        JMenu jMenu7 = new JMenu("Plotting");
        this.load_rst_menu.setActionCommand("loadrst");
        this.load_rst_menu.addActionListener(this);
        this.data_open_menu.setActionCommand("datafile");
        this.data_open_menu.addActionListener(this);
        this.data_close_menu.setActionCommand("closefile");
        this.data_close_menu.addActionListener(this);
        this.new_proj_menu.setActionCommand("newproject");
        this.new_proj_menu.addActionListener(this);
        this.new_proj_button.setActionCommand("newproject");
        this.new_proj_button.addActionListener(this);
        this.open_proj_menu.setActionCommand("openproj");
        this.open_proj_menu.addActionListener(this);
        this.open_proj_button.setActionCommand("openproj");
        this.open_proj_button.addActionListener(this);
        this.close_proj_menu.setActionCommand("closeproj");
        this.close_proj_menu.addActionListener(this);
        this.save_proj_menu.setActionCommand("saveproj");
        this.save_proj_menu.addActionListener(this);
        this.save_proj_button.setActionCommand("saveproj");
        this.save_proj_button.addActionListener(this);
        this.print_menu.setActionCommand("print");
        this.print_menu.addActionListener(this);
        this.exit_menu.setActionCommand("exit");
        this.exit_menu.addActionListener(this);
        this.proj_job_menu.setActionCommand("startjob");
        this.proj_job_menu.addActionListener(this);
        this.proj_joblog_menu.setActionCommand("joblog");
        this.proj_joblog_menu.addActionListener(this);
        this.proj_killjob_menu.setActionCommand("killjob");
        this.proj_killjob_menu.addActionListener(this);
        this.proj_pgen_menu.setActionCommand("genparam");
        this.proj_pgen_menu.addActionListener(this);
        this.sim_new_menu.setActionCommand("simnew");
        this.sim_new_menu.addActionListener(this);
        this.sim_new_button.setActionCommand("simnew");
        this.sim_new_button.addActionListener(this);
        this.sim_del_menu.setActionCommand("simdel");
        this.sim_del_menu.addActionListener(this);
        this.sim_del_button.setActionCommand("simdel");
        this.sim_del_button.addActionListener(this);
        this.sim_param_menu.setActionCommand("simsetting");
        this.sim_param_menu.addActionListener(this);
        this.sim_run_menu.setActionCommand("simrun");
        this.sim_run_menu.addActionListener(this);
        this.sim_run_button.setActionCommand("simrun");
        this.sim_run_button.addActionListener(this);
        this.sim_stop_menu.setActionCommand("simstop");
        this.sim_stop_menu.addActionListener(this);
        this.sim_stop_button.setActionCommand("simstop");
        this.sim_stop_button.addActionListener(this);
        this.view_proj_menu.setActionCommand("viewproj");
        this.view_proj_menu.addActionListener(this);
        this.view_sim_menu.setActionCommand("viewsim");
        this.view_sim_menu.addActionListener(this);
        this.view_result_menu.setActionCommand("viewsummary");
        this.view_result_menu.addActionListener(this);
        this.data_fst_menu.setActionCommand("viewfst");
        this.data_fst_menu.addActionListener(this);
        this.data_alpha_menu.setActionCommand("viewalpha");
        this.data_alpha_menu.addActionListener(this);
        this.data_like_menu.setActionCommand("viewlike");
        this.data_like_menu.addActionListener(this);
        this.data_lnpd_menu.setActionCommand("viewlnpd");
        this.data_lnpd_menu.addActionListener(this);
        this.data_rec_menu.setActionCommand("viewrec");
        this.data_rec_menu.addActionListener(this);
        this.triangle_menu.setActionCommand("triangle");
        this.triangle_menu.addActionListener(this);
        this.view_clear_menu.setActionCommand("clearconsole");
        this.view_clear_menu.addActionListener(this);
        this.help_topic_menu.setActionCommand("helpdoc");
        this.help_topic_menu.addActionListener(this);
        this.help_about_menu.setActionCommand("about");
        this.help_about_menu.addActionListener(this);
        this.help_topic_button.setActionCommand("about");
        this.help_topic_button.addActionListener(this);
        jMenu.add(this.data_open_menu);
        jMenu.add(this.data_close_menu);
        jMenu.addSeparator();
        jMenu.add(this.new_proj_menu);
        jMenu.add(this.open_proj_menu);
        jMenu.add(this.close_proj_menu);
        jMenu.add(this.save_proj_menu);
        jMenu.addSeparator();
        jMenu.add(this.load_rst_menu);
        jMenu.addSeparator();
        jMenu.add(this.app.getHistoryMenu());
        jMenu.addSeparator();
        jMenu.add(this.exit_menu);
        jMenu2.add(this.copy_menu);
        jMenu2.add(this.cut_menu);
        jMenu2.add(this.paste_menu);
        jMenu4.add(this.app.getSimMenu());
        jMenu4.addSeparator();
        jMenu4.add(this.sim_param_menu);
        jMenu4.add(this.sim_new_menu);
        jMenu4.add(this.sim_del_menu);
        jMenu4.addSeparator();
        jMenu4.add(this.sim_run_menu);
        jMenu4.add(this.sim_stop_menu);
        jMenu3.add(this.proj_job_menu);
        jMenu3.add(this.proj_joblog_menu);
        jMenu3.add(this.proj_killjob_menu);
        jMenu3.addSeparator();
        jMenu3.add(this.proj_pgen_menu);
        jMenu5.add(this.view_proj_menu);
        jMenu5.add(this.view_sim_menu);
        jMenu5.add(this.view_result_menu);
        this.plot_data_menu.add(this.data_fst_menu);
        this.plot_data_menu.add(this.data_alpha_menu);
        this.plot_data_menu.add(this.data_rec_menu);
        this.plot_data_menu.add(this.data_like_menu);
        this.plot_data_menu.add(this.data_lnpd_menu);
        jMenu7.add(this.plot_data_menu);
        jMenu7.addSeparator();
        jMenu7.add(this.triangle_menu);
        jMenu5.add(this.view_clear_menu);
        jMenu6.add(this.help_topic_menu);
        jMenu6.add(this.help_about_menu);
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu3);
        this.menuBar.add(jMenu4);
        this.menuBar.add(jMenu7);
        this.menuBar.add(jMenu5);
        this.menuBar.add(jMenu6);
        this.toolBar.addSeparator();
        this.toolBar.add(this.open_proj_button);
        this.toolBar.add(this.save_proj_button);
        this.toolBar.add(this.new_proj_button);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.sim_new_button);
        this.toolBar.add(this.sim_del_button);
        this.toolBar.addSeparator();
        this.toolBar.add(this.sim_run_button);
        this.toolBar.add(this.sim_stop_button);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.help_topic_button);
        return this.menuBar;
    }

    public void updateUI(int n) {
        if (n == 0) {
            this.new_proj_menu.setEnabled(true);
            this.new_proj_button.setEnabled(true);
            this.open_proj_menu.setEnabled(true);
            this.open_proj_button.setEnabled(true);
            this.close_proj_menu.setEnabled(false);
            this.save_proj_menu.setEnabled(false);
            this.save_proj_button.setEnabled(false);
            this.proj_job_menu.setEnabled(false);
            this.proj_joblog_menu.setEnabled(false);
            this.proj_killjob_menu.setEnabled(false);
            this.proj_pgen_menu.setEnabled(false);
            this.app.getSimMenu().setEnabled(false);
            this.sim_param_menu.setEnabled(false);
            this.sim_run_menu.setEnabled(false);
            this.sim_run_button.setEnabled(false);
            this.sim_stop_menu.setEnabled(false);
            this.sim_stop_button.setEnabled(false);
            this.sim_new_menu.setEnabled(false);
            this.sim_new_button.setEnabled(false);
            this.sim_del_menu.setEnabled(false);
            this.sim_del_button.setEnabled(false);
            this.view_proj_menu.setEnabled(false);
            this.view_sim_menu.setEnabled(false);
            this.view_result_menu.setEnabled(false);
            this.view_clear_menu.setEnabled(false);
            this.plot_data_menu.setEnabled(false);
            this.triangle_menu.setEnabled(false);
            this.console.setText("");
            if (this.dataframe != null) {
                this.dataframe.dispose();
            }
            if (this.projframe != null) {
                this.projframe.dispose();
                this.projframe = null;
            }
            if (this.simframe != null) {
                this.simframe.dispose();
            }
            if (this.resultframe != null) {
                this.resultframe.dispose();
                this.rst_mbar = null;
            }
            if (this.rstplotframe != null) {
                this.rstplotframe.dispose();
            }
            if (this.summaryframe != null) {
                this.summaryframe.dispose();
            }
            return;
        }
        if (n == 1) {
            this.new_proj_menu.setEnabled(false);
            this.open_proj_menu.setEnabled(false);
            this.close_proj_menu.setEnabled(true);
            this.save_proj_menu.setEnabled(true);
            this.new_proj_button.setEnabled(false);
            this.open_proj_button.setEnabled(false);
            this.save_proj_button.setEnabled(true);
            this.proj_job_menu.setEnabled(true);
            this.proj_joblog_menu.setEnabled(false);
            this.proj_killjob_menu.setEnabled(false);
            this.proj_pgen_menu.setEnabled(true);
            this.app.getSimMenu().setEnabled(true);
            this.sim_param_menu.setEnabled(false);
            this.sim_run_menu.setEnabled(false);
            this.sim_stop_menu.setEnabled(false);
            this.sim_new_menu.setEnabled(true);
            this.sim_run_button.setEnabled(false);
            this.sim_stop_button.setEnabled(false);
            this.sim_new_button.setEnabled(true);
            this.sim_del_menu.setEnabled(true);
            this.sim_del_button.setEnabled(true);
            this.view_proj_menu.setEnabled(true);
            this.view_sim_menu.setEnabled(false);
            this.view_result_menu.setEnabled(true);
            this.view_clear_menu.setEnabled(true);
            this.plot_data_menu.setEnabled(false);
            this.triangle_menu.setEnabled(true);
            return;
        }
        if (n == 2) {
            this.new_proj_menu.setEnabled(false);
            this.open_proj_menu.setEnabled(false);
            this.close_proj_menu.setEnabled(true);
            this.save_proj_menu.setEnabled(true);
            this.new_proj_button.setEnabled(false);
            this.open_proj_button.setEnabled(false);
            this.save_proj_button.setEnabled(true);
            this.proj_job_menu.setEnabled(true);
            this.proj_joblog_menu.setEnabled(false);
            this.proj_killjob_menu.setEnabled(false);
            this.proj_pgen_menu.setEnabled(true);
            this.app.getSimMenu().setEnabled(true);
            this.sim_param_menu.setEnabled(true);
            this.sim_run_menu.setEnabled(true);
            this.sim_stop_menu.setEnabled(false);
            this.sim_new_menu.setEnabled(true);
            this.sim_run_button.setEnabled(true);
            this.sim_stop_button.setEnabled(false);
            this.sim_new_button.setEnabled(true);
            this.sim_del_menu.setEnabled(true);
            this.sim_del_button.setEnabled(true);
            this.view_proj_menu.setEnabled(true);
            this.view_sim_menu.setEnabled(true);
            this.view_result_menu.setEnabled(true);
            this.view_clear_menu.setEnabled(true);
            this.plot_data_menu.setEnabled(false);
            this.triangle_menu.setEnabled(true);
            return;
        }
        if (n == 3) {
            this.new_proj_menu.setEnabled(false);
            this.open_proj_menu.setEnabled(false);
            this.close_proj_menu.setEnabled(false);
            this.save_proj_menu.setEnabled(true);
            this.new_proj_button.setEnabled(false);
            this.open_proj_button.setEnabled(false);
            this.save_proj_button.setEnabled(true);
            this.proj_job_menu.setEnabled(false);
            this.proj_joblog_menu.setEnabled(false);
            this.proj_killjob_menu.setEnabled(false);
            this.proj_pgen_menu.setEnabled(true);
            this.app.getSimMenu().setEnabled(false);
            this.sim_param_menu.setEnabled(true);
            this.sim_run_menu.setEnabled(false);
            this.sim_stop_menu.setEnabled(true);
            this.sim_new_menu.setEnabled(true);
            this.sim_run_button.setEnabled(false);
            this.sim_stop_button.setEnabled(true);
            this.sim_new_button.setEnabled(true);
            this.sim_del_menu.setEnabled(true);
            this.sim_del_button.setEnabled(true);
            this.view_proj_menu.setEnabled(true);
            this.view_sim_menu.setEnabled(true);
            this.view_result_menu.setEnabled(true);
            this.view_clear_menu.setEnabled(false);
            this.plot_data_menu.setEnabled(true);
            this.triangle_menu.setEnabled(true);
            return;
        }
        if (n == 4) {
            this.new_proj_menu.setEnabled(false);
            this.open_proj_menu.setEnabled(false);
            this.close_proj_menu.setEnabled(false);
            this.save_proj_menu.setEnabled(true);
            this.new_proj_button.setEnabled(false);
            this.open_proj_button.setEnabled(false);
            this.save_proj_button.setEnabled(true);
            this.proj_job_menu.setEnabled(false);
            this.proj_joblog_menu.setEnabled(true);
            this.proj_killjob_menu.setEnabled(true);
            this.proj_pgen_menu.setEnabled(true);
            this.app.getSimMenu().setEnabled(false);
            this.sim_param_menu.setEnabled(false);
            this.sim_run_menu.setEnabled(false);
            this.sim_stop_menu.setEnabled(false);
            this.sim_new_menu.setEnabled(true);
            this.sim_run_button.setEnabled(false);
            this.sim_stop_button.setEnabled(false);
            this.sim_new_button.setEnabled(true);
            this.sim_del_menu.setEnabled(false);
            this.sim_del_button.setEnabled(false);
            this.view_proj_menu.setEnabled(true);
            this.view_sim_menu.setEnabled(true);
            this.view_result_menu.setEnabled(true);
            this.view_clear_menu.setEnabled(false);
            this.plot_data_menu.setEnabled(true);
            this.triangle_menu.setEnabled(true);
            return;
        }
    }

    public void setRstMenu(JMenuBar jMenuBar) {
        this.rst_mbar = jMenuBar;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.compareTo("exit") == 0) {
            this.app.exit_structure();
        }
        if (string.compareTo("newproject") == 0) {
            this.app.newProject();
            return;
        }
        if (string.compareTo("closeproj") == 0) {
            this.app.closeProj();
        }
        if (string.equals("closefile")) {
            JInternalFrame jInternalFrame = this.rightPane.getSelectedFrame();
            if (jInternalFrame != this.dataframe && jInternalFrame != this.projframe && jInternalFrame != this.simframe && jInternalFrame != this.resultframe && jInternalFrame != this.rstplotframe && jInternalFrame != this.summaryframe) {
                jInternalFrame.dispose();
            }
            return;
        }
        if (string.compareTo("saveproj") == 0) {
            this.app.saveProj();
        }
        if (string.compareTo("openproj") == 0) {
            this.app.openProj();
            return;
        }
        if (string.compareTo("simnew") == 0) {
            this.app.newSim();
            return;
        }
        if (string.compareTo("simdel") == 0) {
            this.app.removeSimObj();
            return;
        }
        if (string.compareTo("simsetting") == 0) {
            this.app.simSetting();
            return;
        }
        if (string.compareTo("simrun") == 0) {
            this.app.runProc();
            return;
        }
        if (string.compareTo("simstop") == 0) {
            this.app.stopProc();
            return;
        }
        if (string.compareTo("datafile") == 0) {
            this.loadData();
            return;
        }
        if (string.equals("loadrst")) {
            this.app.loadOutsideRst();
        }
        if (string.equals("startjob")) {
            this.app.startJob();
            return;
        }
        if (string.equals("joblog")) {
            this.app.showJobLog();
            return;
        }
        if (string.equals("killjob")) {
            this.app.killJob();
            return;
        }
        if (string.equals("genparam")) {
            this.app.genParamFiles();
        }
        if (string.compareTo("viewfst") == 0) {
            this.app.plotDynamic("Fst");
            return;
        }
        if (string.equals("viewalpha")) {
            this.app.plotDynamic("Alpha");
            return;
        }
        if (string.equals("viewrec")) {
            this.app.plotDynamic("Rec");
            return;
        }
        if (string.equals("viewlike")) {
            this.app.plotDynamic("Like");
            return;
        }
        if (string.equals("viewlnpd")) {
            this.app.plotDynamic("LnPD");
            return;
        }
        if (string.compareTo("sviewfst") == 0) {
            this.app.plotStatic("Fst");
            return;
        }
        if (string.equals("sviewalpha")) {
            this.app.plotStatic("Alpha");
            return;
        }
        if (string.equals("sviewrec")) {
            this.app.plotStatic("Rec");
            return;
        }
        if (string.equals("sviewlnpd")) {
            this.app.plotStatic("LnPD");
            return;
        }
        if (string.equals("sviewlike")) {
            this.app.plotStatic("Like");
            return;
        }
        if (string.equals("histfst")) {
            this.app.plotStatic("FstHist");
            return;
        }
        if (string.equals("histalpha")) {
            this.app.plotStatic("AlphaHist");
            return;
        }
        if (string.equals("histrec")) {
            this.app.plotStatic("RecHist");
            return;
        }
        if (string.equals("histlike")) {
            this.app.plotStatic("LikHist");
            return;
        }
        if (string.equals("histlnpd")) {
            this.app.plotStatic("LnpdHist");
            return;
        }
        if (string.equals("triplot")) {
            this.app.triPlot(1);
        }
        if (string.equals("triangle")) {
            this.app.triPlot(0);
            return;
        }
        if (string.compareTo("viewproj") == 0) {
            this.app.loadDataFrame("proj", null);
            return;
        }
        if (string.equals("viewsim")) {
            this.app.loadDataFrame("sim", null);
            return;
        }
        if (string.equals("viewsummary")) {
            this.app.loadSummary();
            return;
        }
        if (string.equals("clearconsole")) {
            this.console.setText("");
            return;
        }
        if (string.equals("print")) {
            this.processPrinting();
            return;
        }
        if (string.equals("barplot")) {
            this.app.loadBarPlot();
        }
        if (string.equals("helpdoc")) {
            JOptionPane.showMessageDialog(this, "Help document (readme.pdf) is availble in \"Help Files\" directory\nIt is also available online in HTML format\n\n", "Structure Document", 1);
            return;
        }
        if (string.equals("about")) {
            JOptionPane.showMessageDialog(this, "\nStructure 2.2 (March 2007)\nDaniel Falush, Matthew Stephens, Jonathan Pritchard\nCode written by Daniel Falush and Jonathan Pritchard\nFrontend by Xiaoquan Wen\n\nCITATIONS\n\n [1] J.K.Pritchard, M.Stephens and P.Donnelly 2000. \"Inference of population          \n     structure from multilocus genotype data\" Genetics 155:945-959 \n\n [2] D.Falush,  M.Stephens and J.K.Pritchard 2003.  \"Inference of population          \n     structure using multilocus genotype data: Linked loci and correlated allele\n   frequencies\" Genetics 164: 1567-1587 \n\n [3] D.Falush,  M.Stephens and J.K. Pritchard 2007. \"Inference of population          \n     structure using multilocus genotype data: dominant markers and null alleles\"\n     Molecular Ecology Notes\n\nRELEASE HISTORY\n\n  Structure 1.0 (June 2000)\n  Jonathan Pritchard, Matthew Stephens, Peter Donnelly\n  Code written by Jonathan Pritchard\n\n  Structure 2.0 (March 2002)\n  Daniel Falush, Matthew Stephens, Jonathan Pritchard\n  Code written by Daniel Falush and Jonathan Pritchard\n\n", "About Structure 2.2", 1);
            return;
        }
    }

    public TextArea getConsole() {
        return this.console;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void loadData() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.fc_dir);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            Object object;
            Serializable serializable;
            int n2;
            Object object2;
            File file = jFileChooser.getSelectedFile();
            this.fc_dir = file.getParentFile();
            String string = file.getAbsolutePath();
            InputStream inputStream = MainFrame.OpenInputFile(string);
            if (inputStream == null) {
                return;
            }
            Lexer lexer = new Lexer(inputStream);
            while (lexer.getNextString() != null) {
            }
            int n3 = lexer.getTokenCol();
            int n4 = lexer.getLine();
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            inputStream = MainFrame.OpenInputFile(string);
            if (inputStream == null) {
                return;
            }
            lexer = new Lexer(inputStream);
            Object[][] objectArray = new String[n4][n3];
            InFile inFile = null;
            try {
                inFile = new InFile(string);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Can not Read Data Source", "Error", 0);
                return;
            }
            String string2 = "";
            String string3 = "";
            int n5 = 0;
            Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
            while (true) {
                try {
                    string3 = inFile.readLine();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string3 == null) break;
                object2 = new StringTokenizer(string3);
                if (!((StringTokenizer)object2).hasMoreTokens()) continue;
                n2 = 0;
                int n6 = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object2).nextToken();
                    try {
                        objectArray[n5][n2++] = string2;
                        ++n6;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                }
                serializable = new Integer(n6);
                if (hashtable.containsKey(serializable)) {
                    object = (Integer)hashtable.get(serializable);
                    int n7 = (Integer)object;
                    hashtable.put((Integer)serializable, new Integer(++n7));
                } else {
                    hashtable.put(new Integer(n6), new Integer(1));
                }
                ++n5;
            }
            object2 = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                object2[n2] = new String("" + (n2 + 1));
            }
            JTable jTable = new JTable(objectArray, (Object[])object2);
            objectArray = null;
            jTable.setAutoResizeMode(0);
            jTable.setPreferredScrollableViewportSize(new Dimension(650, 420));
            JScrollPane jScrollPane = new JScrollPane(jTable);
            serializable = new JInternalFrame(new String("Data - " + string), true, true, true, true);
            ((JInternalFrame)serializable).getContentPane().add(jScrollPane);
            ((Component)serializable).setSize(650, 450);
            ((JComponent)serializable).setVisible(true);
            this.rightPane.add((Component)serializable);
            try {
                ((JInternalFrame)serializable).setMaximum(true);
                ((JInternalFrame)serializable).setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            object = string + "\n\n";
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n8 = (Integer)enumeration.nextElement();
                Integer n9 = (Integer)hashtable.get(n8);
                object = (String)object + new String(n9 + " Lines with " + n8 + " Columns\n");
            }
            JOptionPane.showMessageDialog(this, object, "Structure: Open Data File", 1);
            return;
        }
    }

    private void processPrinting() {
    }

    private static InputStream OpenInputFile(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("**Error: unable to open input file.");
            fileInputStream = null;
        }
        return fileInputStream;
    }

    public void showData(final String[][] stringArray, final String[] stringArray2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, int n2) {
        String[] stringArray3 = new String[stringArray[0].length];
        final int n3 = stringArray[0].length;
        final int n4 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            stringArray3[i] = " ";
        }
        JTable jTable = new JTable(new AbstractTableModel(){
            int rows;
            int cols;
            {
                this.rows = n4;
                this.cols = n3;
            }

            public String getColumnName(int n) {
                return stringArray2[n];
            }

            public int getRowCount() {
                return this.rows;
            }

            public int getColumnCount() {
                return this.cols;
            }

            public Object getValueAt(int n, int n2) {
                return stringArray[n][n2];
            }
        });
        int n5 = n2;
        if (bl5) {
            n5 *= n;
        }
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < n3; ++i) {
            if (i < n3 - n5) continue;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setCellRenderer(new DataRowRenderer(n4, bl, bl2, bl4, bl5, n, bl3));
        }
        jTable.setAutoResizeMode(0);
        jTable.setPreferredScrollableViewportSize(new Dimension(650, 420));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.dataframe = new JInternalFrame("Project Data", true, true, true, true);
        this.dataframe.setDefaultCloseOperation(0);
        this.dataframe.addInternalFrameListener(this.framelistener);
        this.dataframe.getContentPane().add(jScrollPane);
        this.dataframe.setSize(650, 450);
        this.dataframe.setVisible(true);
        this.rightPane.add(this.dataframe);
        try {
            this.dataframe.setSelected(true);
            this.dataframe.setMaximum(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void loadSummaryFrame(JInternalFrame jInternalFrame, String string) {
        this.hideAllFrames();
        if (this.summaryframe != null) {
            this.summaryframe.dispose();
        }
        this.summaryframe = jInternalFrame;
        this.summaryframe.setTitle(string);
        this.summaryframe.setSize(650, 450);
        this.summaryframe.setVisible(true);
        this.rightPane.add(this.summaryframe);
        try {
            this.summaryframe.setSelected(true);
            this.summaryframe.setMaximum(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public int getCurrState() {
        return this.app.getCurrState();
    }

    public void loadDataFrame(String string, String string2, String string3) {
        if (string.equals("proj")) {
            this.hideAllFrames();
            if (this.projframe == null) {
                this.projframe = new JInternalFrame(string2, true, true, true, true);
                this.projframe.setDefaultCloseOperation(0);
                this.projframe.addInternalFrameListener(this.framelistener);
                JTextArea jTextArea = new JTextArea(string3);
                jTextArea.setFont(new Font("TimesRoman", 0, 15));
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                jTextArea.setCaretPosition(0);
                jTextArea.setEditable(false);
                this.projframe.getContentPane().add(jScrollPane);
                this.projframe.setSize(650, 450);
                this.projframe.setVisible(true);
                this.rightPane.add(this.projframe);
            }
            if (!this.projframe.isVisible()) {
                this.projframe.setVisible(true);
            }
            try {
                this.projframe.setSelected(true);
                this.projframe.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            return;
        }
        if (string.equals("data")) {
            this.hideAllFrames();
            if (!this.dataframe.isVisible()) {
                this.dataframe.setVisible(true);
            }
            try {
                this.dataframe.setSelected(true);
                this.dataframe.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                System.err.println(propertyVetoException);
            }
            return;
        }
        if (string.equals("sim")) {
            this.hideAllFrames();
            if (this.simframe != null) {
                this.simframe.dispose();
            }
            this.simframe = new JInternalFrame(string2, true, true, true, true);
            JTextArea jTextArea = new JTextArea(string3);
            jTextArea.setFont(new Font("TimesRoman", 0, 15));
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jTextArea.setCaretPosition(0);
            jTextArea.setEditable(false);
            this.simframe.getContentPane().add(jScrollPane);
            this.simframe.setSize(650, 450);
            this.simframe.pack();
            this.simframe.setVisible(true);
            this.rightPane.add(this.simframe);
            try {
                this.simframe.setSelected(true);
                this.simframe.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            return;
        }
        if (string.equals("result")) {
            this.hideAllFrames();
            if (this.resultframe != null) {
                this.resultframe.dispose();
            }
            this.resultframe = new JInternalFrame(string2, true, true, true, true);
            JTextArea jTextArea = new JTextArea(string3);
            string3 = null;
            jTextArea.setFont(new Font("TimesRoman", 0, 15));
            jTextArea.setMargin(new Insets(0, 25, 0, 10));
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jTextArea.setCaretPosition(0);
            jTextArea.setEditable(false);
            this.resultframe.setJMenuBar(this.rst_mbar);
            this.resultframe.getContentPane().setLayout(new BorderLayout());
            this.resultframe.getContentPane().add((Component)jScrollPane, "Center");
            this.resultframe.pack();
            this.resultframe.setVisible(true);
            this.rightPane.add(this.resultframe);
            try {
                this.resultframe.setSelected(true);
                this.resultframe.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            return;
        }
    }

    void hideAllFrames() {
        if (this.dataframe != null) {
            this.dataframe.setVisible(false);
        }
        if (this.projframe != null) {
            this.projframe.setVisible(false);
        }
        if (this.simframe != null) {
            this.simframe.setVisible(false);
        }
        if (this.resultframe != null) {
            this.resultframe.setVisible(false);
        }
        if (this.rstplotframe != null) {
            this.rstplotframe.setVisible(false);
        }
        if (this.summaryframe != null) {
            this.summaryframe.setVisible(false);
        }
    }

    class FrameSetListener
    implements InternalFrameListener {
        FrameSetListener() {
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
            jInternalFrame.setVisible(false);
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }
    }
}

