/*
 * Decompiled with CFR 0.152.
 */
package Gui.Param;

import Gui.Param.AncestDlg;
import Obj.NProjObj;
import Obj.NSimObj;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AdditionalPanel
extends JPanel
implements ActionListener {
    private JCheckBox probBox;
    private JCheckBox distBox;
    private JCheckBox startBox;
    private JCheckBox updateBox;
    private JCheckBox printqBox;
    private JButton ancestButton;
    private JButton defaultButton;
    private JTextField metroField;
    private boolean updateflag;
    private boolean prob = true;
    private boolean dist;
    private boolean printq;
    private boolean start;
    private int metro = 10;
    private AncestDlg ancestDlg;
    private NSimObj sim;

    public AdditionalPanel(NSimObj nSimObj) {
        NProjObj nProjObj;
        String string;
        this.sim = nSimObj;
        this.updateBox = new JCheckBox("Update allele frequencies with POPFLAG=1 data");
        this.probBox = new JCheckBox("Compute probability of the data (for estimating K)");
        this.distBox = new JCheckBox("Print credible regions  ");
        this.startBox = new JCheckBox("Initalize at POPINFO  ");
        this.printqBox = new JCheckBox("Print Q-hat  ");
        this.probBox.setSelected(true);
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        this.ancestButton = new JButton("Configure ...");
        this.ancestButton.setActionCommand("ancest");
        this.ancestButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.ancestButton);
        this.ancestButton.setEnabled(false);
        this.defaultButton = new JButton("Default Setting");
        this.defaultButton.setActionCommand("default");
        this.defaultButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.defaultButton);
        JLabel jLabel = new JLabel("              ");
        JLabel jLabel2 = new JLabel("             ");
        JLabel jLabel3 = new JLabel("             ");
        JLabel jLabel4 = new JLabel("Freq. of Metropolis update for Q ");
        this.metroField = new JTextField(10);
        this.metroField.setText("10");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.metroField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 1));
        jPanel4.add(this.updateBox);
        jPanel4.add(this.probBox);
        jPanel4.add(this.distBox);
        jPanel4.add(this.startBox);
        jPanel4.add(jLabel4);
        jPanel4.add(this.printqBox);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(0, 1));
        jPanel5.add(new JLabel("          "));
        jPanel5.add(jLabel2);
        jPanel5.add(jPanel);
        jPanel5.add(jLabel3);
        jPanel5.add(jPanel3);
        jPanel5.add(jLabel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        this.add(jPanel4);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        this.add(jPanel5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        if (!nSimObj.isNew()) {
            this.prob = nSimObj.COMPUTEPROB;
            this.dist = nSimObj.ANCESTDIST;
            this.start = nSimObj.STARTPOPINFO;
            this.metro = nSimObj.METROFREQ;
            this.updateflag = nSimObj.PFROMPOPFLAGONLY;
            this.updateBox.setSelected(this.updateflag);
            this.printq = nSimObj.PRINTQ;
            this.probBox.setSelected(this.prob);
            this.distBox.setSelected(this.dist);
            this.printqBox.setSelected(this.printq);
            this.startBox.setSelected(this.start);
            this.metroField.setText("" + this.metro);
            this.ancestButton.setEnabled(this.dist);
            if (this.dist) {
                this.ancestDlg = new AncestDlg(this, nSimObj, false);
            }
        }
        if ((string = (nProjObj = nSimObj.getProjObj()).getConfig()).indexOf("POPFLAG 0") >= 0) {
            this.updateBox.setEnabled(false);
        }
        nProjObj = null;
        string = null;
        this.updateBox.addItemListener(checkBoxListener);
        this.distBox.addItemListener(checkBoxListener);
        this.startBox.addItemListener(checkBoxListener);
        this.probBox.addItemListener(checkBoxListener);
        this.printqBox.addItemListener(checkBoxListener);
    }

    public void reset() {
        this.probBox.setSelected(true);
        this.prob = true;
        this.distBox.setSelected(false);
        this.updateBox.setSelected(false);
        this.updateflag = false;
        this.dist = false;
        this.startBox.setSelected(false);
        this.start = false;
        this.ancestButton.setEnabled(false);
        this.printq = false;
        this.printqBox.setSelected(false);
        this.metroField.setText("10");
        this.metro = 10;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("default")) {
            this.reset();
            return;
        }
        if (actionEvent.getActionCommand().equals("ancest")) {
            if (this.ancestDlg == null) {
                this.ancestDlg = new AncestDlg(this, this.sim, true);
            }
            this.ancestDlg.showDialog();
            return;
        }
    }

    public boolean validateData() {
        String string = "";
        String string2 = this.metroField.getText();
        try {
            this.metro = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = string + new String("\nMETROFREQ Must be an Integer");
        }
        if (string.compareTo("") != 0) {
            String string3 = "Errors:\n";
            string = string3.concat(string);
            string = string + new String("\n\n");
            JOptionPane.showMessageDialog(this, string, "errors", 0);
            return false;
        }
        return true;
    }

    public void updateData() {
        this.sim.METROFREQ = this.metro;
        this.sim.STARTPOPINFO = this.start;
        this.sim.PRINTQ = this.printq;
        this.sim.ANCESTDIST = this.dist;
        if (this.dist) {
            if (this.ancestDlg == null) {
                this.sim.NUMBOXES = 1000;
                this.sim.ANCESTPINT = 0.9f;
            } else {
                this.ancestDlg.updateData();
            }
        }
        this.sim.COMPUTEPROB = this.prob;
        this.sim.PFROMPOPFLAGONLY = this.updateflag;
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            boolean bl = true;
            if (itemEvent.getStateChange() == 2) {
                bl = false;
            }
            if (itemSelectable == AdditionalPanel.this.probBox) {
                AdditionalPanel.this.prob = bl;
            } else if (itemSelectable == AdditionalPanel.this.startBox) {
                AdditionalPanel.this.start = bl;
            } else if (itemSelectable == AdditionalPanel.this.distBox) {
                AdditionalPanel.this.dist = bl;
            } else if (itemSelectable == AdditionalPanel.this.printqBox) {
                AdditionalPanel.this.printq = bl;
            } else if (itemSelectable == AdditionalPanel.this.updateBox) {
                AdditionalPanel.this.updateflag = bl;
            }
            AdditionalPanel.this.ancestButton.setEnabled(AdditionalPanel.this.dist);
        }
    }
}

