/*
 * Decompiled with CFR 0.152.
 */
package jas.bean;

import jas.bean.PageContext;
import jas.bean.PageContextHook;
import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.job.HistogramAccess;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.TreeAdaptorSite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.tree.TreeModel;

public class Plot
extends JPanel
implements PageContextHook {
    protected String m_data;
    protected JASHist m_hist = new JASHist();

    public Plot() {
        super(new BorderLayout());
        this.add((Component)this.m_hist, "Center");
        this.setPreferredSize(new Dimension(200, 200));
    }

    public void setData(String string) {
        this.m_data = string;
    }

    public String getData() {
        return this.m_data;
    }

    private void showData() throws Exception {
        JavaAnalysisStudio javaAnalysisStudio = JavaAnalysisStudio.getApp();
        TreeModel treeModel = javaAnalysisStudio.getTreeModel();
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_data, ":");
        while (stringTokenizer.hasMoreTokens()) {
            JASHistData jASHistData;
            String string = stringTokenizer.nextToken();
            TreeAdaptorSite treeAdaptorSite = this.findNode(treeModel, string);
            Object object = treeAdaptorSite.getAssociatedObject();
            if (object instanceof DataSource) {
                jASHistData = this.m_hist.addData((DataSource)object);
                jASHistData.show(true);
                continue;
            }
            if (object instanceof HistogramAccess) {
                jASHistData = this.m_hist.addData(((HistogramAccess)object).getData());
                jASHistData.show(true);
                continue;
            }
            throw new IllegalArgumentException("Path " + string + " does not lead to data");
        }
    }

    protected TreeAdaptorSite findNode(TreeModel treeModel, String string) throws IllegalArgumentException {
        TreeAdaptorSite treeAdaptorSite = (TreeAdaptorSite)treeModel.getRoot();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            TreeAdaptorSite treeAdaptorSite2 = null;
            String string2 = stringTokenizer.nextToken();
            Enumeration enumeration = treeAdaptorSite.children();
            while (enumeration.hasMoreElements()) {
                TreeAdaptorSite treeAdaptorSite3 = (TreeAdaptorSite)enumeration.nextElement();
                if (!treeAdaptorSite3.getName().equals(string2)) continue;
                treeAdaptorSite2 = treeAdaptorSite3;
                break;
            }
            if (treeAdaptorSite2 == null) {
                throw new IllegalArgumentException("Node " + string2 + " in " + string + " not found");
            }
            treeAdaptorSite = treeAdaptorSite2;
        }
        return treeAdaptorSite;
    }

    public void init(PageContext pageContext) throws Exception {
        if (this.m_data != null) {
            this.showData();
        }
    }

    public void destroy() {
        this.m_hist.destroy();
    }
}

