/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.FitAdapter1D;
import jas.hist.FitFailed;
import jas.hist.FitUpdate;
import jas.hist.Fittable1DFunction;
import jas.hist.XYDataSource;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;

public abstract class Fitter
extends Observable
implements Observer,
Runnable,
Serializable {
    public static final int FITTING = 0;
    public static final int FIT = 1;
    public static final int FAILED = 2;
    public static final int READYTOFIT = 3;
    public static final int NOTREADYTOFIT = 4;
    public static final int OUTAHERE = 5;
    static final long serialVersionUID = -7769799329320822801L;
    private XYDataSource m_data;
    private Fittable1DFunction m_func;
    private int state = 4;
    private Thread thread;
    private boolean observing = false;

    public abstract double getChiSquared();

    public abstract double[] getParameterSigmas();

    protected abstract void fit(Fittable1DFunction var1, double[] var2, double[] var3, double[] var4) throws FitFailed;

    public void fit() throws FitFailed {
        if (this.state != 3) {
            throw new FitFailed("Not ready to fit");
        }
        this.internalFit();
        this.observeData();
    }

    public synchronized void start() {
        if (this.state == 3) {
            this.thread = new Thread((Runnable)this, "Fit thread");
            this.thread.start();
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Fitter fitter;
        try {
            try {
                this.internalFit();
                this.observeData();
            }
            catch (FitFailed fitFailed) {
                Object var3_2 = null;
                Fitter fitter3 = this;
                synchronized (fitter3) {
                    this.thread = null;
                    return;
                }
            }
            Object var3_1 = null;
            fitter = this;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Fitter fitter2 = this;
            synchronized (fitter2) {
                this.thread = null;
                throw throwable;
            }
        }
        synchronized (fitter) {
            this.thread = null;
            return;
        }
    }

    public synchronized void update(Observable observable, Object object) {
        if (observable == this.m_data) {
            if (this.state == 1) {
                this.setState(3);
            }
            this.start();
        }
    }

    public int getState() {
        return this.state;
    }

    private synchronized void observeData() {
        if (!this.observing && this.m_data instanceof Observable) {
            ((Observable)((Object)this.m_data)).addObserver(this);
        }
    }

    private synchronized void setState(int n) {
        this.state = n;
        this.setChanged();
        this.notifyObservers(new FitUpdate(n));
    }

    private synchronized void setState(int n, FitFailed fitFailed) {
        this.state = n;
        this.setChanged();
        this.notifyObservers(new FitUpdate(n, fitFailed));
    }

    protected void setPercentComplete(int n) {
        this.setChanged();
        this.notifyObservers(new FitUpdate(this.state, n));
    }

    private void internalFit() throws FitFailed {
        this.setState(0);
        try {
            int n = this.m_data.getNPoints();
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = this.m_data.getX(n2);
                dArray2[n2] = this.m_data.getY(n2);
                dArray3[n2] = this.m_data.getPlusError(n2);
                if (dArray3[n2] != this.m_data.getMinusError(n2)) {
                    throw new FitFailed("Cannot fit data with asymmetric error bars");
                }
                ++n2;
            }
            this.fit(new FitAdapter1D(this.m_func), dArray, dArray2, dArray3);
            this.setState(1);
        }
        catch (FitFailed fitFailed) {
            this.setState(2, fitFailed);
            throw fitFailed;
        }
    }

    public synchronized void setFunction(Fittable1DFunction fittable1DFunction) {
        if (this.m_func != null && this.m_func.getFit() == this) {
            this.m_func.clearFit();
        }
        this.m_func = fittable1DFunction;
        if (this.m_func != null & this.m_data != null) {
            this.setState(3);
        }
    }

    public Fittable1DFunction getFunction() {
        return this.m_func;
    }

    public synchronized void setData(XYDataSource xYDataSource) {
        if (this.observing) {
            ((Observable)((Object)this.m_data)).deleteObserver(this);
            this.observing = false;
        }
        this.m_data = xYDataSource;
        if (this.m_func != null & this.m_data != null) {
            this.setState(3);
        }
    }

    public XYDataSource getData() {
        return this.m_data;
    }

    protected synchronized void dispose() {
        if (this.thread != null) {
            this.thread.stop();
        }
        this.setState(5);
        this.deleteObservers();
        this.setData(null);
        this.setFunction(null);
    }
}

