/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.BinnedDataManager;
import jas.hist.DataManager;
import jas.hist.DataManagerException;
import jas.hist.DataSource;
import jas.hist.DateDataManager;
import jas.hist.DateScatterDataManager;
import jas.hist.DefaultDataManager;
import jas.hist.DoubleDataManager;
import jas.hist.DoubleScatterDataManager;
import jas.hist.FitListener;
import jas.hist.Fitter;
import jas.hist.FunctionData;
import jas.hist.IntegerDataManager;
import jas.hist.JASHist1DFunctionData;
import jas.hist.JASHistAxis;
import jas.hist.JASHistData;
import jas.hist.JASHistPropertyDialog;
import jas.hist.ManagedAxis;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.SaveAsDialog;
import jas.hist.ScatterPlotSource;
import jas.hist.StatisticsBlock;
import jas.hist.StringDataManager;
import jas.hist.SupportsFunctions;
import jas.hist.TwoDDataManager;
import jas.hist.VectorGraphicsTransferable;
import jas.hist.XMLPrintWriter;
import jas.hist.XYDataSource;
import jas.plot.Axis;
import jas.plot.DataArea;
import jas.plot.HasPopupItems;
import jas.plot.JASPlotMouseListener;
import jas.plot.Legend;
import jas.plot.PlotPanel;
import jas.plot.PrintHelper;
import jas.plot.Title;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class JASHist
extends JComponent
implements JASPlotMouseListener {
    public static final int NONE = 0;
    public static final int BEVEL_IN = 1;
    public static final int BEVEL_OUT = 2;
    public static final int ETCHED = 3;
    public static final int LINE = 4;
    public static final int SHADOW = 5;
    public static final int LEGEND_NEVER = 0;
    public static final int LEGEND_AUTOMATIC = 1;
    public static final int LEGEND_ALWAYS = 2;
    private static Vector fitListeners;
    private Title title;
    private StatisticsBlock stats;
    private boolean isInit = false;
    private boolean changed = false;
    private int showLegend = 1;
    private DataArea dataArea;
    private DataManager dataManager;
    private Legend legend;
    private PlotPanel contentPane = new JASHistPlotPanel();
    static final long serialVersionUID = 4433180397297758071L;
    static /* synthetic */ Class class$java$awt$Frame;

    public JASHist() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
        this.setPreferredSize(new Dimension(200, 200));
        ManagedAxis managedAxis = new ManagedAxis(2);
        ManagedAxis managedAxis2 = new ManagedAxis(1);
        this.legend = new Legend();
        this.contentPane.add(this.legend);
        this.legend.setVisible(false);
        this.stats = new StatisticsBlock();
        this.contentPane.add(this.stats);
        this.stats.setVisible(false);
        this.dataArea = new JASHistDataArea(managedAxis, managedAxis2);
        this.dataManager = new DefaultDataManager(this, this.dataArea);
        this.contentPane.add(this.dataArea);
        this.changed = false;
        this.isInit = false;
    }

    DataManager getDataManager() {
        return this.dataManager;
    }

    public DataArea getDataArea() {
        return this.dataArea;
    }

    public boolean supportsProperties() {
        return !(this.dataManager instanceof DefaultDataManager);
    }

    public void showProperties() {
        this.showProperties((byte)0);
    }

    public void showProperties(byte by) {
        new JASHistPropertyDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = JASHist.class$("java.awt.Frame")) : class$java$awt$Frame, this), this, by).show();
    }

    public void addNotify() {
        this.isInit = true;
        this.dataManager.init();
        super.addNotify();
    }

    public void writeXML(Writer writer, boolean bl) {
        XMLPrintWriter xMLPrintWriter = new XMLPrintWriter(writer);
        xMLPrintWriter.print(this, bl);
    }

    public boolean getAllowUserInteraction() {
        return this.contentPane.getAllowUserInteraction();
    }

    public void setAllowUserInteraction(boolean bl) {
        this.contentPane.setAllowUserInteraction(bl);
        this.setChanged();
    }

    public void setShowStatistics(boolean bl) {
        this.stats.setVisible(bl);
        this.contentPane.revalidate();
        this.setChanged();
    }

    public boolean getShowStatistics() {
        return this.stats.isVisible();
    }

    public void setBackground(Color color) {
        this.contentPane.setBackground(color);
        this.setChanged();
    }

    public Color getBackground() {
        if (this.contentPane.isPaintingBackground()) {
            return this.contentPane.getBackground();
        }
        return super.getBackground();
    }

    public void setForegroundColor(Color color) {
        super.setForeground(color);
        this.setChanged();
    }

    public Color getDataAreaColor() {
        return this.dataArea.getBackground();
    }

    public void setDataAreaColor(Color color) {
        this.dataArea.setBackground(color);
        this.setChanged();
    }

    public void setDataAreaBorderType(int n) {
        this.dataArea.setBorderType(n);
        this.dataArea.revalidate();
        this.setChanged();
    }

    public int getDataAreaBorderType() {
        return this.dataArea.getBorderType();
    }

    public void setDataAreaBorder(Border border) {
        this.dataArea.setBorder(border);
    }

    public Border getDataAreaBorder() {
        return this.dataArea.getBorder();
    }

    public JASHistAxis getXAxis() {
        return this.dataManager.getXAxis();
    }

    public JASHistAxis getYAxis() {
        return this.dataManager.getYAxis(0);
    }

    public JASHistAxis getYAxis(int n) {
        return this.dataManager.getYAxis(n);
    }

    public JASHistAxis[] getYAxes() {
        return this.dataManager.getYAxes();
    }

    public void setShowLegend(int n) {
        this.showLegend = n;
        this.dataManager.showLegend();
    }

    public int getShowLegend() {
        return this.showLegend;
    }

    public JASHistData addData(DataSource dataSource) throws DataManagerException {
        if (dataSource instanceof Rebinnable1DHistogramData) {
            return this.add1DData((Rebinnable1DHistogramData)dataSource);
        }
        if (dataSource instanceof XYDataSource) {
            return this.addXYData((XYDataSource)dataSource);
        }
        if (dataSource instanceof Rebinnable2DHistogramData) {
            return this.add2DData((Rebinnable2DHistogramData)dataSource);
        }
        if (dataSource instanceof ScatterPlotSource) {
            return this.addScatterData((ScatterPlotSource)dataSource);
        }
        if (dataSource instanceof FunctionData) {
            return this.addFunctionData((FunctionData)dataSource);
        }
        throw new DataManagerException("Unknown DataSource subclass: " + dataSource);
    }

    private JASHistData add1DData(Rebinnable1DHistogramData rebinnable1DHistogramData) throws DataManagerException {
        if (this.dataManager instanceof DefaultDataManager) {
            int n = rebinnable1DHistogramData.getAxisType();
            if (n == 1) {
                this.dataManager = new DoubleDataManager(this, this.dataArea, this.legend, this.stats, 50);
            } else if (n == 4) {
                this.dataManager = new IntegerDataManager(this, this.dataArea, this.legend, this.stats, 50);
            } else if (n == 2) {
                this.dataManager = new StringDataManager(this, this.dataArea, this.legend, this.stats);
            } else if (n == 3) {
                this.dataManager = new DateDataManager(this, this.dataArea, this.legend, this.stats, 50);
            } else {
                throw new DataManagerException("Unsupported axis type");
            }
            if (this.isInit) {
                this.dataManager.init();
            }
        }
        JASHistData jASHistData = this.dataManager.add(rebinnable1DHistogramData);
        this.setChanged();
        return jASHistData;
    }

    private JASHistData addXYData(XYDataSource xYDataSource) throws DataManagerException {
        if (this.dataManager instanceof DefaultDataManager) {
            int n = xYDataSource.getAxisType();
            if (n == 1) {
                this.dataManager = new DoubleDataManager(this, this.dataArea, this.legend, this.stats, 50);
            } else if (n == 4) {
                this.dataManager = new IntegerDataManager(this, this.dataArea, this.legend, this.stats, 50);
            } else if (n == 3) {
                this.dataManager = new DateDataManager(this, this.dataArea, this.legend, this.stats, 50);
            } else {
                throw new DataManagerException("Unsupported axis type");
            }
            if (this.isInit) {
                this.dataManager.init();
            }
        }
        JASHistData jASHistData = this.dataManager.add(xYDataSource);
        this.setChanged();
        return jASHistData;
    }

    private JASHistData addScatterData(ScatterPlotSource scatterPlotSource) throws DataManagerException {
        if (this.dataManager instanceof DefaultDataManager) {
            int n = scatterPlotSource.getXAxisType();
            int n2 = scatterPlotSource.getYAxisType();
            if (n2 != 1) {
                throw new DataManagerException("Scatterplot Y Axis must be of type DOUBLE");
            }
            if (n == 1) {
                this.dataManager = new DoubleScatterDataManager(this, this.dataArea, this.legend, this.stats);
            } else if (n == 3) {
                this.dataManager = new DateScatterDataManager(this, this.dataArea, this.legend, this.stats);
            }
            if (this.isInit) {
                this.dataManager.init();
            }
        }
        JASHistData jASHistData = this.dataManager.add(scatterPlotSource);
        this.setChanged();
        return jASHistData;
    }

    private JASHistData add2DData(Rebinnable2DHistogramData rebinnable2DHistogramData) throws DataManagerException {
        if (this.dataManager instanceof DefaultDataManager) {
            int n = rebinnable2DHistogramData.getXAxisType();
            int n2 = rebinnable2DHistogramData.getYAxisType();
            if (n == 1) {
                this.dataManager = new DoubleScatterDataManager(this, this.dataArea, this.legend, this.stats);
            } else if (n == 3) {
                this.dataManager = new DateScatterDataManager(this, this.dataArea, this.legend, this.stats);
            } else {
                throw new DataManagerException("Unsupported X Axis type for ScatterPlot");
            }
            if (this.isInit) {
                this.dataManager.init();
            }
        }
        JASHistData jASHistData = this.dataManager.add(rebinnable2DHistogramData);
        this.setChanged();
        return jASHistData;
    }

    private JASHistData addFunctionData(FunctionData functionData) throws DataManagerException {
        JASHist1DFunctionData jASHist1DFunctionData = ((BinnedDataManager)this.dataManager).addFunction((Basic1DFunction)functionData);
        this.setChanged();
        return jASHist1DFunctionData;
    }

    int numberOfDataSets() {
        return this.dataManager.numberOfDataSources();
    }

    int numberOfFunctions() {
        if (this.dataManager instanceof SupportsFunctions) {
            return ((SupportsFunctions)((Object)this.dataManager)).numberOfFunctions();
        }
        return 0;
    }

    public Enumeration getDataSources() {
        return this.dataManager.getDataSources();
    }

    public int getNumberOfDataSources() {
        return this.dataManager.numberOfDataSources();
    }

    public Enumeration get1DFunctions() {
        if (this.dataManager instanceof SupportsFunctions) {
            return ((SupportsFunctions)((Object)this.dataManager)).getFunctions();
        }
        return null;
    }

    public void destroy() {
        this.dataManager.destroy();
        this.contentPane.removeAll();
    }

    public void removeAllData() {
        this.dataManager.destroy();
        this.dataManager = new DefaultDataManager(this, this.dataArea);
        this.setChanged();
    }

    private void resetAxis(JASHistAxis jASHistAxis) {
        jASHistAxis.setRangeAutomatic(true);
        jASHistAxis.setAllowSuppressedZero(true);
        jASHistAxis.setLogarithmic(false);
        this.setChanged();
    }

    public void fillFunctionMenu(JMenu jMenu) {
        if (this.dataManager instanceof SupportsFunctions) {
            ((SupportsFunctions)((Object)this.dataManager)).fillFunctionMenu(jMenu);
            jMenu.setEnabled(true);
        } else {
            jMenu.setEnabled(false);
        }
    }

    public void fillSliceMenu(JMenu jMenu) {
        if (this.dataManager instanceof TwoDDataManager) {
            ((TwoDDataManager)this.dataManager).fillSliceMenu(jMenu);
            jMenu.setEnabled(true);
        } else {
            jMenu.setEnabled(false);
        }
    }

    public String getTitle() {
        if (this.title == null) {
            return null;
        }
        return this.title.getText();
    }

    public Title getTitleObject() {
        return this.title;
    }

    public void setTitleObject(Title title) {
        if (this.title != null) {
            this.contentPane.remove(this.title);
        }
        this.title = title;
        this.contentPane.add(this.title);
        this.contentPane.invalidate();
        this.setChanged();
    }

    public void setTitle(String string) {
        if (string != null && string.length() != 0) {
            if (this.title == null) {
                this.title = new Title(string);
                this.contentPane.add(this.title);
                this.contentPane.invalidate();
                this.validate();
            } else {
                this.title.setText(string);
            }
            this.setChanged();
        } else if (this.title != null) {
            this.contentPane.remove(this.title);
            this.contentPane.invalidate();
            this.validate();
            this.title = null;
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void setChanged() {
        this.changed = true;
        this.validate();
        this.repaint();
    }

    public static void addFitListener(FitListener fitListener) {
        if (fitListeners == null) {
            fitListeners = new Vector(1, 1);
        }
        fitListeners.addElement(fitListener);
    }

    static void notifyFitListeners(Fitter fitter) {
        if (fitListeners != null) {
            Enumeration enumeration = fitListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((FitListener)enumeration.nextElement()).fitStarted(fitter);
            }
        }
    }

    public void mouseEventNotify(MouseEvent mouseEvent) {
        this.processMouseEvent(mouseEvent);
    }

    public void deselected() {
        this.contentPane.deselected();
    }

    public StatisticsBlock getStats() {
        return this.stats;
    }

    public void setStats(StatisticsBlock statisticsBlock) {
        this.stats = statisticsBlock;
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend legend) {
        this.legend = legend;
    }

    public void saveAs() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this);
        saveAsDialog.pack();
        saveAsDialog.doModal();
    }

    public void copy() {
        VectorGraphicsTransferable vectorGraphicsTransferable = new VectorGraphicsTransferable(this);
        this.getToolkit().getSystemClipboard().setContents(vectorGraphicsTransferable, vectorGraphicsTransferable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class JASHistDataArea
    extends DataArea {
        JASHistDataArea(Axis axis, Axis axis2) {
            super(axis, axis2);
        }

        public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
            if (component == this || !(component instanceof HasPopupItems)) {
                jPopupMenu.add(new SetTitleMenuItem());
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this, "Show Statistics"){
                    private final /* synthetic */ JASHistDataArea this$1;
                    {
                        this.this$1 = jASHistDataArea;
                    }

                    public void fireActionPerformed(ActionEvent actionEvent) {
                        JASHistDataArea.access$400(this.this$1).setShowStatistics(!JASHistDataArea.access$400(this.this$1).getShowStatistics());
                    }
                };
                jCheckBoxMenuItem.setSelected(JASHist.this.getShowStatistics());
                jPopupMenu.add(jCheckBoxMenuItem);
                JASHist.this.dataManager.modifyPopupMenu(jPopupMenu, component);
                super.modifyPopupMenu(jPopupMenu, component);
            }
        }

        static /* synthetic */ JASHist access$400(JASHistDataArea jASHistDataArea) {
            return jASHistDataArea.JASHist.this;
        }
    }

    private final class SetTitleMenuItem
    extends JCheckBoxMenuItem {
        SetTitleMenuItem() {
            super("Show Title");
            this.setSelected(JASHist.this.title != null && JASHist.this.title.isVisible());
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            if (JASHist.this.title == null || JASHist.this.title.getText().length() == 0) {
                JASHist.this.setTitle("Title");
                JASHist.this.title.edit();
            } else {
                JASHist.this.title.setVisible(!JASHist.this.title.isVisible());
            }
        }
    }

    private final class JASHistPlotPanel
    extends PlotPanel
    implements HasPopupItems {
        private JASHistPlotPanel() {
        }

        public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
            if (jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.addSeparator();
            }
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Default Plot Layout"){

                protected final void fireActionPerformed(ActionEvent actionEvent) {
                    JASHist.this.contentPane.restoreDefaultLayout();
                }
            };
            boolean bl = JASHist.this.contentPane.hasDefaultLayout();
            jCheckBoxMenuItem.setSelected(bl);
            jCheckBoxMenuItem.setEnabled(!bl);
            jPopupMenu.add(jCheckBoxMenuItem);
            jPopupMenu.add(new JMenuItem(this, "Plot Properties..."){
                private final /* synthetic */ JASHistPlotPanel this$1;
                {
                    this.this$1 = jASHistPlotPanel;
                }

                protected final void fireActionPerformed(ActionEvent actionEvent) {
                    JASHistPlotPanel.access$100(this.this$1).showProperties();
                }
            });
            jPopupMenu.add(new JMenuItem(this, "Copy Plot to Clipboard..."){
                private final /* synthetic */ JASHistPlotPanel this$1;
                {
                    this.this$1 = jASHistPlotPanel;
                }

                protected final void fireActionPerformed(ActionEvent actionEvent) {
                    JASHistPlotPanel.access$100(this.this$1).copy();
                }
            });
            jPopupMenu.add(new JMenuItem(this, "Save Plot As..."){
                private final /* synthetic */ JASHistPlotPanel this$1;
                {
                    this.this$1 = jASHistPlotPanel;
                }

                protected final void fireActionPerformed(ActionEvent actionEvent) {
                    JASHistPlotPanel.access$100(this.this$1).saveAs();
                }
            });
            jPopupMenu.add(new JMenuItem(this, "Print Plot..."){
                private final /* synthetic */ JASHistPlotPanel this$1;
                {
                    this.this$1 = jASHistPlotPanel;
                }

                protected final void fireActionPerformed(ActionEvent actionEvent) {
                    try {
                        PrintHelper printHelper = PrintHelper.instance();
                        printHelper.printTarget(this.this$1);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    }
}

