/*
 * Decompiled with CFR 0.152.
 */
package jas.util.xml;

import jas.util.ColorConverter;
import java.awt.Color;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XMLNodeTraverser {
    public void traverse(Node node) throws BadXMLException {
        if (node instanceof Element) {
            this.handleElementAttributes((Element)node);
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.handleSubNode(node2, node2.getNodeName());
            node2 = node2.getNextSibling();
        }
    }

    protected void handleSubNode(Node node, String string) throws BadXMLException {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                this.handleElement((Element)node, string);
                break;
            }
            case 3: {
                this.handleTextNode((Text)node, string);
                break;
            }
            default: {
                this.handleOtherNode(node, string);
            }
        }
    }

    protected void handleElementAttributes(Element element) throws BadXMLException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            this.handleAttributeNode(attr, attr.getName(), attr.getValue());
            ++n;
        }
    }

    protected void handleElement(Element element, String string) throws BadXMLException {
        throw new BadXMLException("Unhandled Element node " + element);
    }

    protected void handleTextNode(Text text, String string) throws BadXMLException {
    }

    protected void handleAttributeNode(Attr attr, String string, String string2) throws BadXMLException {
        throw new BadXMLException("Unhandled Attribute node " + attr);
    }

    protected void handleOtherNode(Node node, String string) throws BadXMLException {
        throw new BadXMLException("Unhandled Other node " + node + " type=" + node.getNodeType());
    }

    public int toInt(String string) throws BadXMLException {
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            throw new BadXMLException("Bad integer value " + string);
        }
    }

    public boolean toBoolean(String string) throws BadXMLException {
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new BadXMLException("Bad boolean value " + string);
    }

    public double toDouble(String string) throws BadXMLException {
        try {
            if (string.equals("NaN")) {
                return Double.NaN;
            }
            return new Double(string);
        }
        catch (Throwable throwable) {
            throw new BadXMLException("Bad double value " + string);
        }
    }

    public Color toColor(String string) throws BadXMLException {
        try {
            return ColorConverter.stringToHTMLColor(string);
        }
        catch (ColorConverter.ColorConversionException colorConversionException) {
            throw new BadXMLException(colorConversionException.getMessage());
        }
    }

    public static class BadXMLException
    extends Exception {
        public BadXMLException() {
        }

        public BadXMLException(String string) {
            super(string);
        }
    }
}

