/*
 * Decompiled with CFR 0.152.
 */
package Graph;

import Graph.Axis;
import Graph.DataSet;
import Graph.LoadMessage;
import Graph.Markers;
import Graph.TextLine;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;

public class Graph2D
extends Canvas {
    private Color DefaultBackground = null;
    protected Vector axis = new Vector(4);
    protected Vector dataset = new Vector(10);
    protected Markers markers = null;
    protected LoadMessage load_thread = null;
    protected Color DataBackground = null;
    public int loadingData = 0;
    public int borderTop = 20;
    public int borderBottom = 20;
    public int borderLeft = 20;
    public int borderRight = 20;
    public boolean frame = true;
    public Color framecolor;
    public boolean drawgrid = true;
    public Color gridcolor = Color.pink;
    public boolean drawzero = true;
    public Color zerocolor = Color.orange;
    public Rectangle datarect = new Rectangle();
    public boolean clearAll = true;
    public boolean paintAll = true;
    public boolean square = false;
    public TextLine lastText = null;

    public DataSet loadFile(URL uRL) {
        byte[] byArray = new byte[50];
        int n = 0;
        int n2 = 100;
        int n3 = 100;
        int n4 = 0;
        double[] dArray = new double[n2];
        InputStream inputStream = null;
        boolean bl = false;
        try {
            int n5;
            inputStream = uRL.openStream();
            block9: while ((n5 = inputStream.read()) > -1) {
                switch (n5) {
                    case 35: {
                        bl = true;
                        continue block9;
                    }
                    case 10: 
                    case 13: {
                        bl = false;
                    }
                    case 9: 
                    case 32: {
                        if (n <= 0) continue block9;
                        String string = new String(byArray, 0, 0, n);
                        dArray[n4] = Double.valueOf(string);
                        if (++n4 >= n2) {
                            double[] dArray2 = new double[n2 += n3];
                            System.arraycopy(dArray, 0, dArray2, 0, n4);
                            dArray = dArray2;
                        }
                        n = 0;
                        continue block9;
                    }
                }
                if (bl) continue;
                byArray[n] = (byte)n5;
                ++n;
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to load Data set from file ");
            exception.printStackTrace();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
        return this.loadDataSet(dArray, n4 / 2);
    }

    public DataSet loadDataSet(double[] dArray, int n) {
        DataSet dataSet;
        try {
            dataSet = new DataSet(dArray, n);
            this.dataset.addElement(dataSet);
            dataSet.g2d = this;
        }
        catch (Exception exception) {
            System.out.println("Failed to load Data set ");
            exception.printStackTrace();
            return null;
        }
        return dataSet;
    }

    public void attachDataSet(DataSet dataSet) {
        if (dataSet != null) {
            this.dataset.addElement(dataSet);
            dataSet.g2d = this;
        }
    }

    public void detachDataSet(DataSet dataSet) {
        if (dataSet != null) {
            if (dataSet.xaxis != null) {
                dataSet.xaxis.detachDataSet(dataSet);
            }
            if (dataSet.yaxis != null) {
                dataSet.yaxis.detachDataSet(dataSet);
            }
            this.dataset.removeElement(dataSet);
        }
    }

    public void detachDataSets() {
        if (this.dataset == null | this.dataset.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.dataset.size(); ++i) {
            DataSet dataSet = (DataSet)this.dataset.elementAt(i);
            if (dataSet.xaxis != null) {
                dataSet.xaxis.detachDataSet(dataSet);
            }
            if (dataSet.yaxis == null) continue;
            dataSet.yaxis.detachDataSet(dataSet);
        }
        this.dataset.removeAllElements();
    }

    public Axis createAxis(int n) {
        Axis axis;
        try {
            axis = new Axis(n);
            axis.g2d = this;
            this.axis.addElement(axis);
        }
        catch (Exception exception) {
            System.out.println("Failed to create Axis");
            exception.printStackTrace();
            return null;
        }
        return axis;
    }

    public void attachAxis(Axis axis) {
        if (axis == null) {
            return;
        }
        try {
            this.axis.addElement(axis);
            axis.g2d = this;
        }
        catch (Exception exception) {
            System.out.println("Failed to attach Axis");
            exception.printStackTrace();
        }
    }

    public void detachAxis(Axis axis) {
        if (axis != null) {
            axis.detachAll();
            axis.g2d = null;
            this.axis.removeElement(axis);
        }
    }

    public void detachAxes() {
        if (this.axis == null | this.axis.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.axis.size(); ++i) {
            ((Axis)this.axis.elementAt(i)).detachAll();
            ((Axis)this.axis.elementAt((int)i)).g2d = null;
        }
        this.axis.removeAllElements();
    }

    public double getXmax() {
        double d = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return d;
        }
        for (int i = 0; i < this.dataset.size(); ++i) {
            DataSet dataSet = (DataSet)this.dataset.elementAt(i);
            d = i == 0 ? dataSet.getXmax() : Math.max(d, dataSet.getXmax());
        }
        return d;
    }

    public double getYmax() {
        double d = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return d;
        }
        for (int i = 0; i < this.dataset.size(); ++i) {
            DataSet dataSet = (DataSet)this.dataset.elementAt(i);
            d = i == 0 ? dataSet.getYmax() : Math.max(d, dataSet.getYmax());
        }
        return d;
    }

    public double getXmin() {
        double d = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return d;
        }
        for (int i = 0; i < this.dataset.size(); ++i) {
            DataSet dataSet = (DataSet)this.dataset.elementAt(i);
            d = i == 0 ? dataSet.getXmin() : Math.min(d, dataSet.getXmin());
        }
        return d;
    }

    public double getYmin() {
        double d = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return d;
        }
        for (int i = 0; i < this.dataset.size(); ++i) {
            DataSet dataSet = (DataSet)this.dataset.elementAt(i);
            d = i == 0 ? dataSet.getYmin() : Math.min(d, dataSet.getYmin());
        }
        return d;
    }

    public void setMarkers(Markers markers) {
        this.markers = markers;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public void setGraphBackground(Color color) {
        if (color == null) {
            return;
        }
        this.setBackground(color);
    }

    public void setDataBackground(Color color) {
        if (color == null) {
            return;
        }
        this.DataBackground = color;
    }

    public void paint(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.bounds();
        rectangle.x = 0;
        rectangle.y = 0;
        if (this.DefaultBackground == null) {
            this.DefaultBackground = this.getBackground();
        }
        if (this.DataBackground == null) {
            this.DataBackground = this.getBackground();
        }
        if (!this.paintAll) {
            return;
        }
        rectangle.x += this.borderLeft;
        rectangle.y += this.borderTop;
        rectangle.width -= this.borderLeft + this.borderRight;
        rectangle.height -= this.borderBottom + this.borderTop;
        this.paintFirst(graphics2, rectangle);
        if (!this.axis.isEmpty()) {
            rectangle = this.drawAxis(graphics2, rectangle);
        } else {
            if (this.clearAll) {
                Color color = graphics.getColor();
                graphics.setColor(this.DataBackground);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor(color);
            }
            this.drawFrame(graphics2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.paintBeforeData(graphics2, rectangle);
        if (!this.dataset.isEmpty()) {
            this.datarect.x = rectangle.x;
            this.datarect.y = rectangle.y;
            this.datarect.width = rectangle.width;
            this.datarect.height = rectangle.height;
            for (int i = 0; i < this.dataset.size(); ++i) {
                ((DataSet)this.dataset.elementAt(i)).draw_data(graphics2, rectangle);
            }
        }
        this.paintLast(graphics2, rectangle);
        graphics2.dispose();
    }

    public void paintFirst(Graphics graphics, Rectangle rectangle) {
    }

    public void paintBeforeData(Graphics graphics, Rectangle rectangle) {
    }

    public void paintLast(Graphics graphics, Rectangle rectangle) {
        if (this.lastText != null) {
            this.lastText.draw(graphics, rectangle.width / 2, rectangle.height / 2, 0);
        }
    }

    public void update(Graphics graphics) {
        if (this.clearAll) {
            Color color = graphics.getColor();
            Rectangle rectangle = this.bounds();
            rectangle.x = 0;
            rectangle.y = 0;
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }
        if (this.paintAll) {
            this.paint(graphics);
        }
    }

    public boolean keyDown(Event event, int n) {
        if (n == 114) {
            this.repaint();
            return true;
        }
        return false;
    }

    public void startedloading() {
        ++this.loadingData;
        if (this.loadingData != 1) {
            return;
        }
        if (this.load_thread == null) {
            this.load_thread = new LoadMessage(this);
        }
        this.load_thread.setFont(new Font("Helvetica", 0, 25));
        this.load_thread.begin();
    }

    public void finishedloading() {
        --this.loadingData;
        if (this.loadingData > 0) {
            return;
        }
        if (this.load_thread != null) {
            this.load_thread.end();
        }
        this.load_thread = null;
    }

    public void loadmessage(String string) {
        if (this.load_thread == null) {
            this.load_thread = new LoadMessage(this);
        }
        this.load_thread.setMessage(string);
    }

    protected Rectangle ForceSquare(Graphics graphics, Rectangle rectangle) {
        double d;
        Axis axis;
        int n;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return rectangle;
        }
        for (n = 0; n < this.axis.size(); ++n) {
            axis = (Axis)this.axis.elementAt(n);
            d = axis.maximum - axis.minimum;
            if (axis.isVertical()) {
                d3 = Math.max(d, d3);
                continue;
            }
            d2 = Math.max(d, d2);
        }
        if (d2 <= 0.0 | d3 <= 0.0) {
            return rectangle;
        }
        d = d2 > d3 ? d2 : d3;
        for (n = 0; n < this.axis.size(); ++n) {
            axis = (Axis)this.axis.elementAt(n);
            axis.maximum = axis.minimum + d;
        }
        Rectangle rectangle2 = this.getDataRectangle(graphics, rectangle);
        if (rectangle2.width > rectangle2.height) {
            n2 = (int)((double)n2 + (double)(rectangle2.width - rectangle2.height) / 2.0);
            n4 -= rectangle2.width - rectangle2.height;
        } else {
            n3 = (int)((double)n3 + (double)(rectangle2.height - rectangle2.width) / 2.0);
            n5 -= rectangle2.height - rectangle2.width;
        }
        return new Rectangle(n2, n3, n4, n5);
    }

    protected Rectangle getDataRectangle(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        block6: for (int i = 0; i < this.axis.size(); ++i) {
            Axis axis = (Axis)this.axis.elementAt(i);
            int n5 = axis.getAxisWidth(graphics);
            switch (axis.getAxisPos()) {
                case 2: {
                    n += n5;
                    n3 -= n5;
                    continue block6;
                }
                case 3: {
                    n3 -= n5;
                    continue block6;
                }
                case 4: {
                    n2 += n5;
                    n4 -= n5;
                    continue block6;
                }
                case 5: {
                    n4 -= n5;
                }
            }
        }
        return new Rectangle(n, n2, n3, n4);
    }

    protected Rectangle drawAxis(Graphics graphics, Rectangle rectangle) {
        if (this.square) {
            rectangle = this.ForceSquare(graphics, rectangle);
        }
        Rectangle rectangle2 = this.getDataRectangle(graphics, rectangle);
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        int n3 = rectangle2.width;
        int n4 = rectangle2.height;
        if (this.clearAll) {
            Color color = graphics.getColor();
            graphics.setColor(this.DataBackground);
            graphics.fillRect(n, n2, n3, n4);
            graphics.setColor(color);
        }
        if (this.frame) {
            this.drawFrame(graphics, n, n2, n3, n4);
        }
        block6: for (int i = 0; i < this.axis.size(); ++i) {
            Axis axis = (Axis)this.axis.elementAt(i);
            axis.data_window = new Dimension(n3, n4);
            switch (axis.getAxisPos()) {
                case 2: {
                    rectangle.x += axis.width;
                    rectangle.width -= axis.width;
                    axis.positionAxis(rectangle.x, rectangle.x, n2, n2 + n4);
                    if (rectangle.x == n) {
                        axis.gridcolor = this.gridcolor;
                        axis.drawgrid = this.drawgrid;
                        axis.zerocolor = this.zerocolor;
                        axis.drawzero = this.drawzero;
                    }
                    axis.drawAxis(graphics);
                    axis.drawgrid = false;
                    axis.drawzero = false;
                    continue block6;
                }
                case 3: {
                    rectangle.width -= axis.width;
                    axis.positionAxis(rectangle.x + rectangle.width, rectangle.x + rectangle.width, n2, n2 + n4);
                    if (rectangle.x + rectangle.width == n + n3) {
                        axis.gridcolor = this.gridcolor;
                        axis.drawgrid = this.drawgrid;
                        axis.zerocolor = this.zerocolor;
                        axis.drawzero = this.drawzero;
                    }
                    axis.drawAxis(graphics);
                    axis.drawgrid = false;
                    axis.drawzero = false;
                    continue block6;
                }
                case 4: {
                    rectangle.y += axis.width;
                    rectangle.height -= axis.width;
                    axis.positionAxis(n, n + n3, rectangle.y, rectangle.y);
                    if (rectangle.y == n2) {
                        axis.gridcolor = this.gridcolor;
                        axis.drawgrid = this.drawgrid;
                        axis.zerocolor = this.zerocolor;
                        axis.drawzero = this.drawzero;
                    }
                    axis.drawAxis(graphics);
                    axis.drawgrid = false;
                    axis.drawzero = false;
                    continue block6;
                }
                case 5: {
                    rectangle.height -= axis.width;
                    axis.positionAxis(n, n + n3, rectangle.y + rectangle.height, rectangle.y + rectangle.height);
                    if (rectangle.y + rectangle.height == n2 + n4) {
                        axis.gridcolor = this.gridcolor;
                        axis.drawgrid = this.drawgrid;
                        axis.zerocolor = this.zerocolor;
                        axis.drawzero = this.drawzero;
                    }
                    axis.drawAxis(graphics);
                    axis.drawgrid = false;
                    axis.drawzero = false;
                }
            }
        }
        return rectangle;
    }

    protected void drawFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        if (this.framecolor != null) {
            graphics.setColor(this.framecolor);
        }
        graphics.drawRect(n, n2, n3, n4);
        graphics.setColor(color);
    }
}

