/*
 * Decompiled with CFR 0.152.
 */
package Graph;

import Graph.DataSet;
import Graph.TextLine;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class VectorSet
extends DataSet {
    private static final int VECTOR_STRIDE = 4;
    private boolean drawlegend = false;
    public static final int MEAN = 1;
    public static final int MINIMUM = 2;
    public static final int MAXIMUM = 3;
    public double scale = 0.1;
    protected int stride = 4;
    protected int scalingType = 1;
    private double vmean;
    private double vmin;
    private double vmax;

    public VectorSet() throws Exception {
        super(4);
        this.stride = 4;
    }

    public VectorSet(double[] dArray, int n) throws Exception {
        super(dArray, n, 4);
        this.stride = 4;
    }

    public VectorSet(double d) throws Exception {
        super(4);
        this.scale = d;
    }

    public VectorSet(double[] dArray, int n, double d) throws Exception {
        this(dArray, n);
        this.scale = d;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public void setScalingType(int n) {
        if (n == 1 || n == 3 || n == 2) {
            this.scalingType = n;
        }
    }

    public double getScaleFactor() {
        double d = this.xrange > this.yrange ? this.scale * this.yrange : this.scale * this.xrange;
        if (this.vmean <= 0.0) {
            return 1.0;
        }
        if (this.scalingType == 1) {
            return d / this.vmean;
        }
        if (this.scalingType == 2) {
            return d / this.vmin;
        }
        if (this.scalingType == 3) {
            return d / this.vmax;
        }
        return 1.0;
    }

    public void legend() {
        super.legend(-1, -1, (String)null);
        this.drawlegend = true;
    }

    public void legend(String string) {
        super.legend(-1, -1, string);
        this.drawlegend = true;
    }

    public void legend(int n, int n2, String string) {
        super.legend(n, n2, string);
        this.drawlegend = true;
    }

    public void legend(double d, double d2, String string) {
        super.legend(d, d2, string);
        this.drawlegend = true;
    }

    public void draw_data(Graphics graphics, Rectangle rectangle) {
        if (this.xaxis != null) {
            this.xmax = this.xaxis.maximum;
            this.xmin = this.xaxis.minimum;
        }
        if (this.yaxis != null) {
            this.ymax = this.yaxis.maximum;
            this.ymin = this.yaxis.minimum;
        }
        this.xrange = this.xmax - this.xmin;
        this.yrange = this.ymax - this.ymin;
        this.draw_legend(graphics, rectangle);
        if (this.clipping) {
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Color color = graphics.getColor();
        if (this.linecolor != null) {
            graphics.setColor(this.linecolor);
        } else {
            graphics.setColor(color);
        }
        this.drawVectors(graphics, rectangle);
        graphics.setColor(color);
    }

    protected void draw_legend(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        TextLine textLine = new TextLine();
        if (!this.drawlegend) {
            return;
        }
        double d = this.xrange * (double)this.legend_length / (double)rectangle.width / this.getScaleFactor();
        textLine.parseDouble(d, 3);
        int n = this.legend_length + textLine.getWidth(graphics) + textLine.charWidth(graphics, ' ');
        if (this.legend_ix == 0 && this.legend_iy == 0) {
            this.legend_ix = (int)((double)rectangle.x + (this.legend_dx - this.xmin) / this.xrange * (double)rectangle.width);
            this.legend_iy = (int)((double)rectangle.y + (1.0 - (this.legend_dy - this.ymin) / this.yrange) * (double)rectangle.height);
        } else if (this.legend_ix == -1 && this.legend_iy == -1) {
            this.legend_ix = rectangle.x + rectangle.width / 2 - n / 2;
            this.legend_iy = rectangle.y - textLine.getAscent(graphics) / 2;
        }
        if (this.linecolor != null) {
            graphics.setColor(this.linecolor);
        }
        graphics.drawLine(this.legend_ix, this.legend_iy, this.legend_ix + this.legend_length, this.legend_iy);
        int n2 = this.legend_ix + (int)(0.25 * (double)this.legend_length + 0.5);
        int n3 = this.legend_iy - (int)(0.25 * (double)this.legend_length + 0.5);
        graphics.drawLine(this.legend_ix, this.legend_iy, n2, n3);
        n2 = this.legend_ix + (int)(0.25 * (double)this.legend_length + 0.5);
        n3 = this.legend_iy + (int)(0.25 * (double)this.legend_length + 0.5);
        graphics.drawLine(this.legend_ix, this.legend_iy, n2, n3);
        textLine.draw(graphics, this.legend_ix + this.legend_length + textLine.charWidth(graphics, ' '), n3, 1);
        graphics.setColor(color);
        if (this.legend_text != null && !this.legend_text.isNull()) {
            this.legend_text.draw(graphics, this.legend_ix + n / 2, n3 - textLine.getAscent(graphics) - this.legend_text.getDescent(graphics) - this.legend_text.getLeading(graphics), 0);
        }
    }

    protected void drawVectors(Graphics graphics, Rectangle rectangle) {
        if (this.data == null || this.data.length < this.stride) {
            return;
        }
        for (int i = 0; i < this.length; i += this.stride) {
            double d = this.data[i];
            double d2 = this.data[i + 1];
            double d3 = this.data[i + 2] * this.getScaleFactor();
            double d4 = this.data[i + 3] * this.getScaleFactor();
            double d5 = d + d3;
            double d6 = d2 + d4;
            if (!this.inside(d, d2) && !this.inside(d5, d6)) continue;
            int n = (int)((double)rectangle.x + (d - this.xmin) / this.xrange * (double)rectangle.width);
            int n2 = (int)((double)rectangle.y + (1.0 - (d2 - this.ymin) / this.yrange) * (double)rectangle.height);
            int n3 = (int)((double)rectangle.x + (d5 - this.xmin) / this.xrange * (double)rectangle.width);
            int n4 = (int)((double)rectangle.y + (1.0 - (d6 - this.ymin) / this.yrange) * (double)rectangle.height);
            graphics.drawLine(n, n2, n3, n4);
            d3 = n3 - n;
            d4 = n4 - n2;
            n = n3 - (int)(0.25 * (d3 - d4) + 0.5);
            n2 = n4 - (int)(0.25 * (d3 + d4) + 0.5);
            graphics.drawLine(n, n2, n3, n4);
            n = n3 - (int)(0.25 * (d3 + d4) + 0.5);
            n2 = n4 - (int)(0.25 * (-d3 + d4) + 0.5);
            graphics.drawLine(n, n2, n3, n4);
        }
    }

    protected void range(int n) {
        double d = 0.0;
        if (this.length > n) {
            this.dxmax = this.data[0];
            this.dymax = this.data[1];
            this.dxmin = this.dxmax;
            this.dymin = this.dymax;
            d = this.data[2] * this.data[2] + this.data[3] * this.data[3];
            this.vmean = Math.sqrt(d);
            this.vmin = d;
            this.vmax = d;
        } else {
            this.dxmin = 0.0;
            this.dxmax = 0.0;
            this.dymin = 0.0;
            this.dymax = 0.0;
            this.vmean = 0.0;
            this.vmin = 0.0;
            this.vmax = 0.0;
        }
        for (int i = n; i < this.length; i += n) {
            if (this.dxmax < this.data[i]) {
                this.dxmax = this.data[i];
            } else if (this.dxmin > this.data[i]) {
                this.dxmin = this.data[i];
            }
            if (this.dymax < this.data[i + 1]) {
                this.dymax = this.data[i + 1];
            } else if (this.dymin > this.data[i + 1]) {
                this.dymin = this.data[i + 1];
            }
            d = this.data[i + 2] * this.data[i + 2] + this.data[i + 3] * this.data[i + 3];
            this.vmean += Math.sqrt(d);
            if (this.vmin > d) {
                this.vmin = d;
            }
            if (!(this.vmax < d)) continue;
            this.vmax = d;
        }
        if (this.length > n) {
            this.vmin = Math.sqrt(this.vmin);
            this.vmax = Math.sqrt(this.vmax);
            this.vmean /= (double)this.dataPoints();
        }
        if (this.xaxis == null) {
            this.xmin = this.dxmin;
            this.xmax = this.dxmax;
        }
        if (this.yaxis == null) {
            this.ymin = this.dymin;
            this.ymax = this.dymax;
        }
    }
}

