/*
 * Decompiled with CFR 0.152.
 */
package Gui.Param;

import Obj.NSimObj;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LambdDlg
extends JDialog {
    private int buttonHit;
    private JTextField lambdField;
    private JCheckBox specBox;
    private JButton okButton;
    private JButton cancelButton;
    private JButton defaultButton;
    private float lambd = 1.0f;
    private boolean spec;
    private NSimObj sim;

    public LambdDlg(Component component, NSimObj nSimObj, boolean bl) {
        this.sim = nSimObj;
        JLabel jLabel = new JLabel("Initial LAMBDA: ");
        this.lambdField = new JTextField(10);
        this.lambdField.setText("1.0");
        jLabel.setLabelFor(this.lambdField);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Default")) {
                    LambdDlg.this.reset();
                    return;
                }
                if (actionEvent.getActionCommand().equals("ok")) {
                    if (!LambdDlg.this.validateData()) {
                        return;
                    }
                    LambdDlg.this.buttonHit = 0;
                }
                if (actionEvent.getActionCommand().equals("cancel")) {
                    LambdDlg.this.buttonHit = 2;
                    LambdDlg.this.reset();
                }
                LambdDlg.this.setVisible(false);
            }
        };
        this.okButton = new JButton("   OK  ");
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(actionListener);
        this.cancelButton = new JButton("Cancel ");
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(actionListener);
        this.defaultButton = new JButton("Default");
        this.defaultButton.addActionListener(actionListener);
        this.specBox = new JCheckBox("  Infer a Separate LAMBDA for Each Population ");
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        this.specBox.addItemListener(checkBoxListener);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.lambdField);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.cancelButton);
        jPanel4.add(this.defaultButton);
        jPanel4.add(this.okButton);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder(20, 20, 4, 20));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel5.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel5.add(jPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel5.add(jPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        gridBagLayout.setConstraints(this.specBox, gridBagConstraints);
        jPanel5.add(this.specBox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(25, 20, 20, 20);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel5.add(jPanel4);
        this.setContentPane(jPanel5);
        this.setLocationRelativeTo(component);
        if (!nSimObj.isNew() && !bl) {
            this.lambd = nSimObj.LAMBDA;
            this.spec = nSimObj.POPSPECIFICLAMBDA;
            this.lambdField.setText("" + this.lambd);
            this.specBox.setSelected(this.spec);
        }
    }

    public void reset() {
        this.lambdField.setText("1.0");
        this.lambd = 1.0f;
        this.specBox.setSelected(false);
        this.spec = false;
    }

    public int showDialog() {
        this.setModal(true);
        this.pack();
        super.show();
        return this.buttonHit;
    }

    public boolean validateData() {
        String string = "";
        String string2 = this.lambdField.getText();
        try {
            this.lambd = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = string + new String("\nLAMBDA Must be a Real Number");
        }
        if (string.compareTo("") != 0) {
            String string3 = "Errors:\n";
            string = string3.concat(string);
            string = string + new String("\n\n");
            JOptionPane.showMessageDialog(this, string, "errors", 0);
            return false;
        }
        return true;
    }

    public void updateData() {
        this.sim.LAMBDA = this.lambd;
        this.sim.POPSPECIFICLAMBDA = this.spec;
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            boolean bl = true;
            if (itemEvent.getStateChange() == 2) {
                bl = false;
            }
            if (itemSelectable == LambdDlg.this.specBox) {
                LambdDlg.this.spec = bl;
            }
        }
    }
}

