/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataSource;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist;
import jas.hist.JASHistAxis;
import jas.hist.JASHistData;
import jas.hist.ManagedAxis;
import jas.plot.Axis;
import jas.plot.DataArea;
import jas.plot.DoubleAxis;
import jas.plot.EditableLabel;
import java.awt.Component;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.JPopupMenu;

abstract class DataManager {
    protected static final Enumeration nullEnumeration = new NullEnumeration();
    protected ManagedAxis xm;
    protected ManagedAxis[] ym = new ManagedAxis[2];
    protected final JASHist plot;
    protected final DataArea da;

    DataManager(JASHist jASHist, DataArea dataArea) {
        this.plot = jASHist;
        this.da = dataArea;
        dataArea.setSpecialComponent(null);
        this.xm = (ManagedAxis)dataArea.getXAxis();
        this.ym[0] = (ManagedAxis)dataArea.getYAxis();
    }

    JASHist getPlot() {
        return this.plot;
    }

    abstract void init();

    abstract JASHistData add(DataSource var1);

    abstract void remove(JASHistData var1);

    abstract void requestShow(JASHistData var1);

    abstract void requestHide(JASHistData var1);

    abstract void invalidate();

    abstract boolean isRealized();

    abstract void XAxisUpdated();

    abstract void computeYAxisRange();

    abstract void computeXAxisRange();

    abstract void update(HistogramUpdate var1, JASHistData var2);

    abstract int numberOfDataSources();

    abstract Enumeration getDataSources();

    abstract void destroy();

    abstract void modifyPopupMenu(JPopupMenu var1, Component var2);

    protected abstract void showLegend();

    abstract void styleUpdate(JASHistData var1);

    abstract void axisChanged(JASHistData var1);

    public EditableLabel getLabel(Axis axis) {
        return this.da.getLabel(axis);
    }

    public void setLabel(Axis axis, EditableLabel editableLabel) {
        this.da.setLabel(axis, editableLabel);
    }

    JASHistAxis getXAxis() {
        return this.xm;
    }

    JASHistAxis[] getYAxes() {
        return this.ym;
    }

    JASHistAxis getYAxis(int n) {
        if (n >= this.ym.length) {
            throw new IllegalArgumentException("Y axis index out of range");
        }
        if (this.ym[n] == null) {
            this.createYAxis(n);
        }
        return this.ym[n];
    }

    protected void createYAxis(int n) {
        this.ym[n] = new ManagedAxis(this, 1, true);
        DoubleAxis doubleAxis = (DoubleAxis)this.ym[n].getType();
        doubleAxis.setUseSuggestedRange(true);
        this.ym[n].setOnLeftSide(false);
        this.da.add(this.ym[n], (Object)"yr");
        this.da.revalidate();
    }

    private static final class NullEnumeration
    implements Enumeration {
        private NullEnumeration() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }
}

