/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.HistogramUpdate;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.Statistics;
import java.util.Observable;

public class Gauss2D
extends Observable
implements Rebinnable2DHistogramData {
    double ymax = Math.random();
    double[] m_tupleX;
    double[] m_tupleY;
    int m_entries;
    String m_name;
    protected static final int MAXSIZE = 10000;

    public Gauss2D(String string, int n) {
        if (n > 10000) {
            throw new IllegalArgumentException("Gauss2D: Size too big");
        }
        this.m_tupleX = new double[10000];
        this.m_tupleY = new double[10000];
        this.m_entries = n;
        this.m_name = string;
        int n2 = 0;
        while (n2 < 10000) {
            double d = Math.random() + Math.random() + Math.random() + Math.random() + Math.random() + Math.random();
            double d2 = Math.random() + Math.random() + Math.random() + Math.random() + Math.random() + Math.random();
            this.m_tupleX[n2] = d / 6.0;
            this.m_tupleY[n2] = this.ymax * d2 / 6.0;
            ++n2;
        }
    }

    public String getTitle() {
        return this.m_name;
    }

    public double getXMin() {
        return 0.0;
    }

    public double getXMax() {
        return 1.0;
    }

    public double getYMin() {
        return 0.0;
    }

    public double getYMax() {
        return this.ymax;
    }

    public boolean isRebinnable() {
        return true;
    }

    public String[] getXAxisLabels() {
        return null;
    }

    public String[] getYAxisLabels() {
        return null;
    }

    public int getXBins() {
        return 40;
    }

    public int getYBins() {
        return 40;
    }

    public int getXAxisType() {
        return 1;
    }

    public int getYAxisType() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][][] rebin(int n, double d, double d2, int n2, double d3, double d4, boolean bl, boolean bl2, boolean bl3) {
        Gauss2D gauss2D = this;
        synchronized (gauss2D) {
            this.setChanged();
        }
        double[][] dArray = new double[n + (bl3 ? 2 : 0)][n2 + (bl3 ? 2 : 0)];
        double d5 = (d2 - d) / (double)n;
        double d6 = (d4 - d3) / (double)n2;
        int n3 = 0;
        while (n3 < this.m_entries) {
            int n4 = (int)((this.m_tupleX[n3] - d) / d5);
            int n5 = (int)((this.m_tupleY[n3] - d3) / d6);
            if (n4 >= 0 && n4 < n && n5 >= 0 && n5 < n2) {
                double[] dArray2 = dArray[n4];
                int n6 = n5;
                dArray2[n6] = dArray2[n6] + 1.0;
            } else if (bl3) {
                if (n4 < 0) {
                    n4 = n;
                }
                if (n4 > n) {
                    n4 = n + 1;
                }
                if (n5 < 0) {
                    n5 = n2;
                }
                if (n5 > n2) {
                    n5 = n2 + 1;
                }
                double[] dArray3 = dArray[n4];
                int n7 = n5;
                dArray3[n7] = dArray3[n7] + 1.0;
            }
            ++n3;
        }
        double[][][] dArrayArray = new double[][][]{dArray};
        return dArrayArray;
    }

    public int getSize() {
        return this.m_entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int n) {
        if (n > 10000) {
            throw new IllegalArgumentException("Gauss: Size too big");
        }
        this.m_entries = n;
        Gauss2D gauss2D = this;
        synchronized (gauss2D) {
            this.notifyObservers(new HistogramUpdate(2, true));
        }
    }

    public double getXData(int n) {
        return this.m_tupleX[n];
    }

    public double getYData(int n) {
        return this.m_tupleY[n];
    }

    public Statistics getStatistics() {
        return null;
    }
}

