/*
 * Decompiled with CFR 0.152.
 */
package Controller;

import Controller.StructureApp;
import Util.InFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class History
implements ActionListener {
    private int maxRecord = 4;
    private Vector projs;
    private JMenu listMenu;
    private StructureApp app;

    public History(StructureApp structureApp) {
        this.app = structureApp;
        File file = new File(System.getProperty("user.home"), ".structure");
        this.projs = new Vector();
        if (file.exists()) {
            this.loadProjVec(file.getAbsolutePath());
        }
    }

    private void loadProjVec(String string) {
        InFile inFile = null;
        try {
            inFile = new InFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        String string2 = new String();
        while (true) {
            try {
                string2 = inFile.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null) {
                return;
            }
            this.projs.add(new File(string2));
        }
    }

    public JMenu getHistoryMenu() {
        this.listMenu = new JMenu("Recent projects");
        if (this.projs.size() == 0) {
            JMenuItem jMenuItem = new JMenuItem(" (Empty) ");
            jMenuItem.setEnabled(false);
            this.listMenu.add(jMenuItem);
            return this.listMenu;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.projs.size(); ++i) {
            String string;
            String string2 = ((File)this.projs.elementAt(i)).getName();
            int n = 0;
            for (int j = 0; j < vector.size(); ++j) {
                string = (String)vector.elementAt(j);
                if (!string.equals(string2)) continue;
                ++n;
            }
            vector.addElement(string2);
            JMenuItem jMenuItem = null;
            jMenuItem = n == 0 ? new JMenuItem(string2) : new JMenuItem(string2 + "(" + (n + 1) + ")");
            string = ((File)this.projs.elementAt(i)).getAbsolutePath();
            jMenuItem.setActionCommand(string + ".spj");
            jMenuItem.addActionListener(this);
            this.listMenu.add(jMenuItem);
        }
        return this.listMenu;
    }

    public void updateHistory(String string, boolean bl) {
        for (int i = 0; i < this.projs.size(); ++i) {
            String string2 = ((File)this.projs.elementAt(i)).getAbsolutePath();
            if (!string2.equals(string)) continue;
            this.projs.removeElementAt(i);
        }
        if (this.projs.size() == this.maxRecord) {
            this.projs.removeElementAt(this.maxRecord - 1);
        }
        this.projs.insertElementAt(new File(string), 0);
        if (bl) {
            this.listMenu.removeAll();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.projs.size(); ++i) {
                String string3;
                String string4 = ((File)this.projs.elementAt(i)).getName();
                int n = 0;
                for (int j = 0; j < vector.size(); ++j) {
                    string3 = (String)vector.elementAt(j);
                    if (!string3.equals(string4)) continue;
                    ++n;
                }
                vector.addElement(string4);
                JMenuItem jMenuItem = null;
                jMenuItem = n == 0 ? new JMenuItem(string4) : new JMenuItem(string4 + "(" + (n + 1) + ")");
                string3 = ((File)this.projs.elementAt(i)).getAbsolutePath();
                jMenuItem.setActionCommand(string3 + ".spj");
                jMenuItem.addActionListener(this);
                this.listMenu.add(jMenuItem);
            }
        }
    }

    public void writeHistoryFile() {
        File file = new File(System.getProperty("user.home"), ".structure");
        PrintStream printStream = History.OpenOutputFile(file);
        for (int i = 0; i < this.projs.size(); ++i) {
            printStream.println(((File)this.projs.elementAt(i)).getAbsolutePath());
        }
        printStream.close();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.app.openProj(string);
    }

    private static PrintStream OpenOutputFile(File file) {
        PrintStream printStream;
        try {
            printStream = new PrintStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("**Error: unable to open output file.");
            printStream = null;
        }
        catch (SecurityException securityException) {
            System.err.println("**Error: no permission to write output file.");
            printStream = null;
        }
        catch (IOException iOException) {
            System.err.println("**Error: unknown error opening output file.");
            printStream = null;
        }
        return printStream;
    }
}

