/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import Plot.ArrayDataSource;
import jas.hist.JASHist;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistData;
import java.awt.Color;
import java.awt.Dimension;

public class HistPlot {
    private String cat;
    private double min;
    private double max;
    private String title;
    private double[] data;

    public HistPlot(double[] dArray, String string, String string2) {
        this.data = dArray;
        this.cat = string;
        this.title = string2;
    }

    double[] sortData() {
        int n;
        int n2 = 10;
        if (this.data == null) {
            return null;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (i == 0) {
                this.min = this.max = this.data[0];
            }
            if (this.data[i] > this.max) {
                this.max = this.data[i];
            }
            if (!(this.data[i] < this.min)) continue;
            this.min = this.data[i];
        }
        double d = (this.max - this.min) / (double)n2;
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = 0.0;
        }
        for (n = 0; n < this.data.length; ++n) {
            int n3 = (int)((this.data[n] - this.min) / d);
            if (n3 == n2) {
                // empty if block
            }
            int n4 = --n3;
            dArray[n4] = dArray[n4] + 1.0;
        }
        return dArray;
    }

    public JASHist draw() {
        double[] dArray = this.sortData();
        if (dArray == null) {
            return null;
        }
        JASHist jASHist = new JASHist();
        JASHistData jASHistData = jASHist.addData(new ArrayDataSource(dArray, this.title, this.min, this.max));
        ((JASHist1DHistogramStyle)jASHistData.getStyle()).setShowErrorBars(false);
        jASHistData.show(true);
        jASHist.setPreferredSize(new Dimension(500, 300));
        jASHist.setTitle(this.title);
        jASHist.getXAxis().setLabel(this.cat);
        jASHist.setAllowUserInteraction(false);
        jASHist.setBackground(Color.white);
        return jASHist;
    }
}

