/*
 * Decompiled with CFR 0.152.
 */
package jas.plot.java2;

import jas.plot.SetablePlotGraphics;
import jas.plot.Transformation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;

public class PlotGraphics12
implements SetablePlotGraphics {
    private static final boolean[] isFilled = new boolean[]{true, true, true, true, false, false, false, false, false, false};
    private GeneralPath path = new GeneralPath();
    private Graphics2D g;
    private Line2D.Double line = new Line2D.Double();
    private Arc2D.Double arc = new Arc2D.Double();
    private Rectangle2D.Double rect = new Rectangle2D.Double();
    private RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private Shape oldClip;
    private Transformation xt;
    private Transformation yt;
    private static final Transformation defaultTransformation = new Transformation(){

        public double convert(double d) {
            return d;
        }
    };

    public void setGraphics(Graphics graphics) {
        this.g = (Graphics2D)graphics;
        this.oldClip = this.g.getClip();
        this.g.setRenderingHints(this.rh);
        this.clearTransformation();
    }

    public void setTransformation(Transformation transformation, Transformation transformation2) {
        this.xt = transformation == null ? defaultTransformation : transformation;
        this.yt = transformation2 == null ? defaultTransformation : transformation2;
    }

    public void clearTransformation() {
        this.xt = defaultTransformation;
        this.yt = defaultTransformation;
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        this.line.setLine(this.xt.convert(d), this.yt.convert(d2), this.xt.convert(d3), this.yt.convert(d4));
        this.g.draw(this.line);
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = this.xt.convert(d);
        double d7 = this.yt.convert(d2);
        double d8 = this.xt.convert(d3);
        double d9 = this.yt.convert(d4);
        if (d8 < d6) {
            d5 = d6;
            d6 = d8;
            d8 = d5;
        }
        if (d9 < d7) {
            d5 = d7;
            d7 = d9;
            d9 = d5;
        }
        this.rect.setRect(d6, d7, d8 - d6, d9 - d7);
        this.g.fill(this.rect);
    }

    public void drawOval(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = this.xt.convert(d);
        double d7 = this.yt.convert(d2);
        double d8 = this.xt.convert(d3);
        double d9 = this.yt.convert(d4);
        if (d8 < d6) {
            d5 = d6;
            d6 = d8;
            d8 = d5;
        }
        if (d9 < d7) {
            d5 = d7;
            d7 = d9;
            d9 = d5;
        }
        this.arc.setArc(d6, d7, d8 - d6, d9 - d7, 0.0, 360.0, 1);
        this.g.draw(this.arc);
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = this.xt.convert(d);
        double d7 = this.yt.convert(d2);
        double d8 = this.xt.convert(d3);
        double d9 = this.yt.convert(d4);
        if (d8 < d6) {
            d5 = d6;
            d6 = d8;
            d8 = d5;
        }
        if (d9 < d7) {
            d5 = d7;
            d7 = d9;
            d9 = d5;
        }
        this.rect.setRect(d6, d7, d8 - d6, d9 - d7);
        this.g.draw(this.rect);
    }

    public void setColor(Color color) {
        this.g.setColor(color);
    }

    public void drawString(String string, double d, double d2) {
        this.g.drawString(string, (float)this.xt.convert(d), (float)this.yt.convert(d2));
    }

    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    public void drawSymbol(double d, double d2, double d3, int n) {
        Shape shape = this.getShapeForSymbol(d, d2, d3, n);
        if (isFilled[n]) {
            this.g.fill(shape);
        } else {
            this.g.draw(shape);
        }
    }

    private Shape getShapeForSymbol(double d, double d2, double d3, int n) {
        float f = (float)this.xt.convert(d);
        float f2 = (float)this.yt.convert(d2);
        float f3 = (float)d3 / 2.0f;
        switch (n) {
            case 0: 
            case 8: {
                this.arc.setArc(f - f3, f2 - f3, d3, d3, 0.0, 360.0, 2);
                return this.arc;
            }
            case 1: 
            case 9: {
                this.rect.setRect(f - f3, f2 - f3, d3, d3);
                return this.rect;
            }
            case 2: {
                this.path.reset();
                this.path.moveTo(f - f3, f2 + f3);
                this.path.lineTo(f + f3, f2 + f3);
                this.path.lineTo(f, f2 - f3);
                this.path.closePath();
                return this.path;
            }
            case 3: {
                this.path.reset();
                this.path.moveTo(f - f3, f2);
                this.path.lineTo(f, f2 + f3);
                this.path.lineTo(f + f3, f2);
                this.path.lineTo(f, f2 - f3);
                this.path.closePath();
                return this.path;
            }
            case 4: {
                this.path.reset();
                this.path.moveTo(f, f2 + f3);
                this.path.lineTo(f, f2 - f3);
                this.path.moveTo(f - f3, f2);
                this.path.lineTo(f + f3, f2);
                this.path.moveTo(f - f3, f2 - f3);
                this.path.lineTo(f + f3, f2 + f3);
                this.path.moveTo(f + f3, f2 - f3);
                this.path.lineTo(f - f3, f2 + f3);
                return this.path;
            }
            case 5: {
                this.line.setLine(f, f2 + f3, f, f2 - f3);
                return this.line;
            }
            case 6: {
                this.line.setLine(f - f3, f2, f + f3, f2);
                return this.line;
            }
            case 7: {
                this.path.reset();
                this.path.moveTo(f, f2 + f3);
                this.path.lineTo(f, f2 - f3);
                this.path.moveTo(f - f3, f2);
                this.path.lineTo(f + f3, f2);
                return this.path;
            }
        }
        throw new RuntimeException("Unknown symbol " + n);
    }

    public void drawPolyLine(double[] dArray, double[] dArray2, int n) {
        if (n <= 0) {
            return;
        }
        this.path.reset();
        this.path.moveTo((float)this.xt.convert(dArray[0]), (float)this.yt.convert(dArray2[0]));
        int n2 = 1;
        while (n2 < n) {
            this.path.lineTo((float)this.xt.convert(dArray[n2]), (float)this.yt.convert(dArray2[n2]));
            ++n2;
        }
        this.g.draw(this.path);
    }

    public void setFont(Font font) {
        this.g.setFont(font);
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public void drawPolySymbol(double[] dArray, double[] dArray2, double d, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.drawSymbol(dArray[n3], dArray2[n3], d, n);
            ++n3;
        }
    }

    public void drawImage(Image image, double d, double d2, ImageObserver imageObserver) {
        this.g.drawImage(image, (int)this.xt.convert(d), (int)this.yt.convert(d2), imageObserver);
    }

    public void drawImage(Image image, double d, double d2, int n, int n2, ImageObserver imageObserver) {
        this.g.drawImage(image, (int)this.xt.convert(d), (int)this.yt.convert(d2), n, n2, imageObserver);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.g.clipRect(n, n4, n2 - n, n3 - n4);
    }

    public void clearClip() {
        this.g.setClip(this.oldClip);
    }
}

