/*
 * Decompiled with CFR 0.152.
 */
package jas.util.pluginmanager;

import jas.swingstudio.JavaAnalysisStudio;
import jas.util.JASDialog;
import jas.util.JASState;
import jas.util.pluginmanager.PluginDownloadProgress;
import jas.util.pluginmanager.PluginManager;
import jas.util.pluginmanager.PluginManagerUI;
import jas.util.pluginmanager.PluginProperties;
import jas.util.pluginmanager.VersionNumberCompare;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UpdatePluginsUI
extends JASDialog {
    private static JFrame frame;
    private PluginManager pluginmanager;
    private PluginManagerUI pluginmanagerui;
    private PluginProperties[] plugins;
    private JList pluginslist;
    private JLabel name;
    private JLabel author;
    private JLabel currVersion;
    private JLabel latestVersion;
    private JLabel requires;
    private JLabel path;
    private JTextArea description;
    private JButton update;
    private Thread updateguithread;
    private Container c;

    public UpdatePluginsUI(PluginManager pluginManager, PluginManagerUI pluginManagerUI) {
        super((Frame)frame, "Update Plugins", true, 13);
        this.pluginmanager = pluginManager;
        this.pluginmanagerui = pluginManagerUI;
        this.showUpdatePluginsUI();
    }

    private void showUpdatePluginsUI() {
        super.setHelpTopic("userInterface.pluginmanager");
        this.c = this.getContentPane();
        this.c.add("North", new JLabel("New Versions of the following plugins are available:"));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.pluginslist = new JList();
        this.pluginslist.setCellRenderer(new Renderer());
        this.pluginslist.setVisibleRowCount(8);
        this.pluginslist.addListSelectionListener(new ListHandler());
        jPanel.add("Center", new JScrollPane(this.pluginslist));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(7, 1));
        jPanel3.add(new JLabel("Name: ", 4));
        jPanel3.add(new JLabel("Author: ", 4));
        jPanel3.add(new JLabel("Current Version: ", 4));
        jPanel3.add(new JLabel("Latest Version: ", 4));
        jPanel3.add(new JLabel("Requires: ", 4));
        jPanel3.add(new JLabel("Install Path:", 4));
        jPanel3.add(new JLabel("Description", 4));
        jPanel2.add("West", jPanel3);
        JPanel jPanel4 = new JPanel(new GridLayout(7, 1));
        this.name = new JLabel();
        jPanel4.add(this.name);
        this.author = new JLabel();
        jPanel4.add(this.author);
        this.currVersion = new JLabel();
        jPanel4.add(this.currVersion);
        this.latestVersion = new JLabel();
        jPanel4.add(this.latestVersion);
        this.requires = new JLabel();
        jPanel4.add(this.requires);
        this.path = new JLabel();
        jPanel4.add(this.path);
        jPanel4.add(Box.createGlue());
        jPanel2.add("Center", jPanel4);
        this.description = new JTextArea(6, 30);
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        jPanel2.add("South", new JScrollPane(this.description));
        jPanel.add("South", jPanel2);
        this.c.add("Center", jPanel);
        JPanel jPanel5 = new JPanel();
        this.update = new JButton("Update selected plugins");
        this.update.setEnabled(false);
        this.getRootPane().setDefaultButton(this.update);
        this.update.addActionListener(new ActionHandler());
        jPanel5.add(this.update);
        this.c.add("South", jPanel5);
        this.updateList();
        this.show();
    }

    private void updateList() {
        Vector vector = this.pluginmanager.getOutDatedPluginList();
        this.plugins = new PluginProperties[vector.size()];
        vector.copyInto(this.plugins);
        if (this.plugins != null) {
            this.pluginslist.setListData(this.plugins);
        }
        this.pack();
    }

    private Object[] checkSelectedPlugins() {
        Object[] objectArray;
        Object[] objectArray2 = this.pluginslist.getSelectedValues();
        Vector<PluginProperties> vector = new Vector<PluginProperties>();
        VersionNumberCompare versionNumberCompare = new VersionNumberCompare();
        int n = 0;
        while (n < objectArray2.length) {
            PluginProperties pluginProperties = (PluginProperties)objectArray2[n];
            File file = new File(pluginProperties.path);
            if (!file.canWrite()) {
                objectArray = new String[]{"OK"};
                int n2 = JOptionPane.showOptionDialog(this.c, "No write access to " + file.getAbsolutePath() + ". " + pluginProperties.name + " cannot be updated.", "Updating Plugins", -1, 0, null, objectArray, objectArray[0]);
            } else {
                try {
                    int n3 = versionNumberCompare.compareVersions(JavaAnalysisStudio.getVersionNumber(), pluginProperties.minJASversion, false);
                    if (n3 == 1) {
                        Object[] objectArray3 = new String[]{"OK"};
                        String string = pluginProperties.name + " requires JAS version " + pluginProperties.minJASversion + " or greater. Latest JAS version available at www-sldnt.slac.stanford.edu/jas.";
                        int n4 = JOptionPane.showOptionDialog(this.c, string, "Updating Plugins", -1, 0, null, objectArray3, objectArray3[0]);
                    } else if (n3 != 1 & n3 != 0) {
                        vector.addElement(pluginProperties);
                    }
                }
                catch (VersionNumberCompare.VersionCompareException versionCompareException) {
                    // empty catch block
                }
            }
            ++n;
        }
        if (vector.size() > 0) {
            objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public void onOK() {
        if (this.updateguithread != null) {
            this.updateguithread.stop();
            this.updateguithread = null;
        }
        this.dispose();
    }

    protected void enableHelp(JASState jASState) {
        jASState.setEnabled(true);
    }

    public void onCancel() {
        if (this.updateguithread != null) {
            this.updateguithread.stop();
            this.updateguithread = null;
        }
        this.dispose();
    }

    static /* synthetic */ PluginManagerUI access$100(UpdatePluginsUI updatePluginsUI) {
        return updatePluginsUI.pluginmanagerui;
    }

    static /* synthetic */ void access$200(UpdatePluginsUI updatePluginsUI) {
        updatePluginsUI.updateList();
    }

    class Renderer
    extends JLabel
    implements ListCellRenderer {
        Renderer() {
            this.setOpaque(true);
            this.setFont(UIManager.getFont("Tree.font"));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof PluginProperties) {
                this.setText(((PluginProperties)object).name);
            } else {
                this.setText(object.toString());
            }
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = UpdatePluginsUI.this.pluginslist.getSelectedIndex();
            Object e = UpdatePluginsUI.this.pluginslist.getSelectedValue();
            if (e instanceof PluginProperties) {
                UpdatePluginsUI.this.update.setEnabled(true);
                PluginProperties pluginProperties = (PluginProperties)e;
                UpdatePluginsUI.this.name.setText(pluginProperties.name);
                UpdatePluginsUI.this.author.setText(pluginProperties.author);
                UpdatePluginsUI.this.currVersion.setText(pluginProperties.currversion);
                UpdatePluginsUI.this.latestVersion.setText(pluginProperties.latestversion);
                UpdatePluginsUI.this.requires.setText(pluginProperties.requires);
                UpdatePluginsUI.this.path.setText(pluginProperties.path);
                UpdatePluginsUI.this.description.setText(pluginProperties.description);
            } else {
                UpdatePluginsUI.this.update.setEnabled(false);
                UpdatePluginsUI.this.name.setText(null);
                UpdatePluginsUI.this.author.setText(null);
                UpdatePluginsUI.this.currVersion.setText(null);
                UpdatePluginsUI.this.latestVersion.setText(null);
                UpdatePluginsUI.this.requires.setText(null);
                UpdatePluginsUI.this.path.setText(null);
                UpdatePluginsUI.this.description.setText(null);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray;
            if (actionEvent.getSource() == UpdatePluginsUI.this.update && (objectArray = UpdatePluginsUI.this.checkSelectedPlugins()) != null) {
                UpdatePluginsUI.this.updateguithread = new UpdateGUIThread(objectArray);
                UpdatePluginsUI.this.updateguithread.start();
            }
        }
    }

    class UpdateGUIThread
    extends Thread {
        private Object[] selected;

        UpdateGUIThread(Object[] objectArray) {
            this.selected = objectArray;
        }

        public void run() {
            PluginDownloadProgress pluginDownloadProgress = new PluginDownloadProgress(this.selected, "update");
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ UpdateGUIThread this$1;
                {
                    this.this$1 = updateGUIThread;
                }

                public void run() {
                    UpdatePluginsUI.access$100(UpdateGUIThread.access$000(this.this$1)).updateTree();
                    UpdatePluginsUI.access$200(UpdateGUIThread.access$000(this.this$1));
                    UpdateGUIThread.access$000(this.this$1).show();
                }
            });
        }

        static /* synthetic */ UpdatePluginsUI access$000(UpdateGUIThread updateGUIThread) {
            return updateGUIThread.UpdatePluginsUI.this;
        }
    }
}

