/*
 * Decompiled with CFR 0.152.
 */
package jas.util.xml;

import jas.util.IndentPrintWriter;
import jas.util.xml.XMLCharacterProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLWriter {
    protected boolean closed = true;
    private String dtdName = null;
    private Hashtable attributes = new Hashtable();
    private Stack openTags = new Stack();
    protected IndentPrintWriter writer;

    public XMLWriter(Writer writer, String string) {
        this.writer = new IndentPrintWriter(writer);
        this.writer.setIndentString(string);
    }

    public XMLWriter(Writer writer) {
        this(writer, "  ");
    }

    public void close() throws IOException {
        this.closeDoc();
        this.writer.close();
    }

    public void openDoc() {
        this.openDoc("1.0", "", false);
    }

    public void openDoc(String string, String string2, boolean bl) {
        String string3 = this.writer.getIndentString();
        this.writer.setIndentString(string3);
        this.closed = false;
        if (!XMLCharacterProperties.validVersionNum(string)) {
            throw new RuntimeException("Invalid version number: " + string);
        }
        this.writer.print("<?xml version=\"");
        this.writer.print(string);
        this.writer.print("\" ");
        if (string2 != null && !string2.equals("")) {
            if (!XMLCharacterProperties.validEncName(string2)) {
                throw new RuntimeException("Invalid encoding name: " + string2);
            }
            this.writer.print("encoding=\"");
            this.writer.print(string2);
            this.writer.print("\" ");
        }
        if (bl) {
            this.writer.print("standalone=\"yes\" ");
        }
        this.writer.println("?>");
        this.writer.setIndentString(string3);
    }

    public void referToDTD(String string, String string2, String string3) {
        if (this.dtdName != null) {
            throw new RuntimeException("ReferToDTD cannot be called twice");
        }
        this.dtdName = string;
        this.writer.println("<!DOCTYPE " + string + " PUBLIC \"" + string2 + "\" \"" + string3 + "\">");
    }

    public void referToDTD(String string, String string2) {
        if (this.dtdName != null) {
            throw new RuntimeException("ReferToDTD cannot be called twice");
        }
        this.dtdName = string;
        this.writer.println("<!DOCTYPE " + string + " SYSTEM \"" + string2 + "\">");
    }

    public void closeDoc() {
        if (!this.closed) {
            if (!this.openTags.isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer("Not all tags were closed before closing XML document:\n");
                while (!this.openTags.isEmpty()) {
                    stringBuffer.append("   </");
                    stringBuffer.append((String)this.openTags.pop());
                    stringBuffer.append(">\n");
                }
                throw new RuntimeException(stringBuffer.toString());
            }
            this.closed = true;
        }
    }

    public void printComment(String string) {
        if (string.indexOf("--") >= 0) {
            throw new RuntimeException("'--' sequence not allowed in comment");
        }
        this.writer.print("<!--");
        this.writer.print(XMLWriter.normalizeText(string));
        this.writer.println("-->");
    }

    public void print(String string) {
        this.writer.print(XMLWriter.normalizeText(string));
    }

    public void println(String string) {
        this.print(string);
        this.writer.println();
    }

    public void println() {
        this.writer.println();
    }

    public void print(double d) {
        this.print(String.valueOf(d));
    }

    public void openTag(String string, String string2) {
        this.openTag(string + ":" + string2);
    }

    public void openTag(String string) {
        this.checkNameValid(string);
        if (this.openTags.isEmpty() && this.dtdName != null && !this.dtdName.equals(string)) {
            throw new RuntimeException("First tag: '" + string + "' not equal to DTD id: '" + this.dtdName + "'");
        }
        this.writer.print("<" + string);
        this.printAttributes(string.length());
        this.writer.println(">");
        this.writer.indent();
        this.openTags.push(string);
    }

    public void closeTag() {
        if (this.openTags.isEmpty()) {
            this.writer.close();
            throw new RuntimeException("No open tags");
        }
        Object e = this.openTags.pop();
        this.writer.outdent();
        this.writer.print("</");
        this.writer.print(e);
        this.writer.println(">");
    }

    public void printTag(String string, String string2) {
        this.printTag(string + ":" + string2);
    }

    public void printTag(String string) {
        this.checkNameValid(string);
        this.writer.print("<" + string);
        this.printAttributes(string.length());
        this.writer.println("/>");
    }

    public void setAttribute(String string, String string2) {
        if (string != null && string2 != null) {
            this.attributes.put(string, string2);
        }
    }

    public void setAttribute(String string, String string2, String string3) {
        if (string != null && string2 != null) {
            this.attributes.put(string + ":" + string2, string3);
        }
    }

    public void setAttribute(String string, double d) {
        this.setAttribute(string, String.valueOf(d));
    }

    public void setAttribute(String string, float f) {
        this.setAttribute(string, String.valueOf(f));
    }

    public void setAttribute(String string, int n) {
        this.setAttribute(string, String.valueOf(n));
    }

    public void setAttribute(String string, long l) {
        this.setAttribute(string, String.valueOf(l));
    }

    public void setAttribute(String string, short s) {
        this.setAttribute(string, String.valueOf(s));
    }

    public void setAttribute(String string, boolean bl) {
        this.setAttribute(string, String.valueOf(bl));
    }

    public void setAttribute(String string, byte by) {
        this.setAttribute(string, String.valueOf(by));
    }

    public void setAttribute(String string, char c) {
        this.setAttribute(string, String.valueOf(c));
    }

    public void setAttribute(String string, String string2, double d) {
        this.setAttribute(string + ":" + string2, String.valueOf(d));
    }

    public void setAttribute(String string, String string2, int n) {
        this.setAttribute(string + ":" + string2, String.valueOf(n));
    }

    public void setAttribute(String string, String string2, boolean bl) {
        this.setAttribute(string + ":" + string2, String.valueOf(bl));
    }

    protected void printAttributes(int n) {
        int n2 = n + 1;
        boolean bl = false;
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            this.checkNameValid(string);
            String string2 = XMLWriter.normalize(this.attributes.get(string).toString());
            int n3 = string.length() + string2.length() + 3;
            if (n2 > 0 && n2 + n3 + 2 * this.writer.getIndent() > 60) {
                n2 = 0;
                this.writer.println();
                if (!bl) {
                    this.writer.indent();
                    bl = true;
                }
            } else {
                n2 += n3;
                this.writer.print(' ');
            }
            this.writer.print(string);
            this.writer.print("=\"");
            this.writer.print(string2);
            this.writer.print("\"");
        }
        this.attributes.clear();
        if (bl) {
            this.writer.outdent();
        }
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                throw new RuntimeException("No support for printing nodes of type Document");
            }
            case 1: {
                Object object;
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    object = namedNodeMap.item(n);
                    this.setAttribute(object.getNodeName(), object.getNodeValue());
                    ++n;
                }
                object = node.getChildNodes();
                if (object == null) {
                    this.printTag(node.getNodeName());
                    break;
                }
                this.openTag(node.getNodeName());
                int n2 = object.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    this.print(object.item(n3));
                    ++n3;
                }
                this.closeTag();
                break;
            }
            case 5: {
                this.writer.print('&');
                this.writer.print(node.getNodeName());
                this.writer.print(';');
                break;
            }
            case 4: {
                this.writer.print("<![CDATA[");
                this.writer.print(node.getNodeValue());
                this.writer.print("]]>");
                break;
            }
            case 3: {
                this.print(node.getNodeValue());
                break;
            }
            case 7: {
                this.writer.print("<?");
                this.writer.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.writer.print(' ');
                    this.writer.print(string);
                }
                this.writer.print("?>");
            }
        }
    }

    public static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    stringBuffer.append("&#");
                    stringBuffer.append(Integer.toString(c));
                    stringBuffer.append(';');
                    break;
                }
                default: {
                    if (c > '\u00ff') {
                        String string2 = "0000" + Integer.toHexString(c);
                        stringBuffer.append("&#x");
                        stringBuffer.append(string2.substring(string2.length() - 4));
                        stringBuffer.append(';');
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String normalizeText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                default: {
                    if (c > '\u00ff') {
                        String string2 = "0000" + Integer.toHexString(c);
                        stringBuffer.append("&#x");
                        stringBuffer.append(string2.substring(string2.length() - 4));
                        stringBuffer.append(';');
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void checkNameValid(String string) {
        if (!XMLCharacterProperties.validName(string)) {
            throw new RuntimeException("Invalid name: " + string);
        }
    }
}

