/*
 * Decompiled with CFR 0.152.
 */
package Controller;

import Controller.StructureApp;
import Gui.JobLogDlg;
import Gui.MainFrame;
import Gui.ProjTree;
import Obj.NProjObj;
import Obj.NSimObj;
import Obj.ObjIO;
import Proc.AppProc;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class JobManager
extends Thread {
    private NProjObj proj;
    private String[] simList;
    private MainFrame mainFrame;
    private ProjTree projTree;
    private int iteration;
    private int fromK;
    private int toK;
    private int seed;
    private boolean requireSeed;
    private JTextArea log;
    private AppProc runningThread;
    private StructureApp app;

    public JobManager(StructureApp structureApp, NProjObj nProjObj, String[] stringArray, int n, int n2, int n3, MainFrame mainFrame, ProjTree projTree, boolean bl, int n4) {
        this.app = structureApp;
        this.proj = nProjObj;
        this.simList = stringArray;
        this.iteration = n;
        this.mainFrame = mainFrame;
        this.projTree = projTree;
        this.fromK = n2;
        this.toK = n3;
        this.requireSeed = bl;
        this.seed = n4;
        this.log = new JTextArea();
    }

    public void run() {
        this.mainFrame.updateUI(4);
        this.log.setFont(new Font("TimesRoman", 0, 12));
        this.log.setLineWrap(true);
        this.log.setWrapStyleWord(true);
        this.log.setMargin(new Insets(10, 10, 10, 10));
        this.log.setText("");
        if (this.proj == null) {
            this.log.setText("No Project Information: Fatal Error, Stop the Job\n");
            return;
        }
        int n = 0;
        this.log.append("Start Job ... \n\n");
        for (int i = 0; i < this.simList.length; ++i) {
            this.log.append("Loading Simulation " + this.simList[i] + " ...\n\n");
            NSimObj nSimObj = ObjIO.loadSimObj(this.proj, this.simList[i]);
            if (nSimObj == null) continue;
            if (nSimObj == null) {
                this.log.append("Can Not Load the Simulation, Skip ... \n");
                continue;
            }
            int n2 = 1;
            for (int j = this.fromK; j <= this.toK; ++j) {
                for (int k = 0; k < this.iteration; ++k) {
                    String string = this.simList[i] + "_run_" + n2;
                    while (!nSimObj.setOutFile(string)) {
                        string = this.simList[i] + "_run_" + ++n2;
                    }
                    ++n2;
                    this.log.append("Set K = " + j + "\n");
                    this.log.append("Set Output Name as: " + string + "\n");
                    nSimObj.setMAXPOPS(j);
                    if (this.requireSeed) {
                        nSimObj.setRNDSEED(this.seed + n);
                        this.log.append("Set Random Seed: " + (this.seed + n) + "\n");
                        ++n;
                    }
                    nSimObj.writeParamFile();
                    String string2 = "bin/structure -m ";
                    String string3 = new String(string2 + "\"" + nSimObj.getParamFile() + "\"" + " -e " + "\"" + nSimObj.getExtraFile() + "\"");
                    this.runningThread = new AppProc(string3, this.mainFrame, this.projTree, nSimObj, false);
                    this.app.setRunningInstance(this.runningThread, nSimObj);
                    this.runningThread.start();
                    while (this.runningThread.isAlive()) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {}
                    }
                    this.log.append("Simulation " + this.simList[i] + " finished\n\n");
                }
            }
        }
        this.log.append("*******************************\n\nJob is Completed!\n");
        JOptionPane.showMessageDialog(null, "Job is Completed !", "Structure", 1);
        this.app.returnControl();
        this.mainFrame.updateUI(this.mainFrame.getCurrState());
    }

    public void killJob() {
        if (this.runningThread == null || !this.runningThread.isAlive()) {
            return;
        }
        this.runningThread.killProc();
        super.stop();
        this.log.append("\n\nJob is Killed by user\n");
        this.app.returnControl();
        this.mainFrame.updateUI(this.mainFrame.getCurrState());
        this.app.setRunningInstance(null, null);
    }

    public void showLog() {
        JobLogDlg jobLogDlg = new JobLogDlg(this.log);
        jobLogDlg.showDialog();
    }
}

