/*
 * Decompiled with CFR 0.152.
 */
package Controller;

import Controller.History;
import Controller.JobManager;
import Controller.PFGenManager;
import Controller.SummaryGenerator;
import Dialog.ta_scroll;
import Gui.MainFrame;
import Gui.Param.ParamDlg;
import Gui.ProjTree;
import Gui.RemoveSimDlg;
import Gui.SchedulerDlg;
import Gui.SimListMenu;
import Gui.StartRunDlg;
import Gui.Wizard.WizardController;
import Loader.RstLoader;
import Obj.NProjObj;
import Obj.NSimObj;
import Obj.ObjIO;
import Obj.PlotData;
import Plot.AlphaPlotManager;
import Plot.FstPlotManager;
import Plot.LikePlotManager;
import Plot.LnpdPlotManager;
import Plot.RecmbPlotManager;
import Plot.RstPlotManager;
import Plot.SrPlotManager;
import Proc.AppProc;
import Tree.TreePlotManager;
import Triangle.TrianglePlotManager;
import Util.GeneralFileFilter;
import Util.InFile;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;

public class StructureApp {
    private JPanel panel;
    private MainFrame mainFrame;
    private WizardController wizardController;
    private ParamDlg paramDlg;
    private ProjTree projTree;
    private SimListMenu simMenu;
    private FstPlotManager fstpm;
    private AlphaPlotManager alphapm;
    private LikePlotManager likepm;
    private LnpdPlotManager lnpdpm;
    private RstPlotManager rpm;
    private RecmbPlotManager recpm;
    private SrPlotManager srpm;
    private JobManager jobManager;
    private String plottingFilePath;
    private String plotString;
    private String plottingSimName;
    private NProjObj currProj;
    private NSimObj currSim;
    private NSimObj runningSim;
    private boolean outOfControl = false;
    private AppProc currThread;
    private File currSimDir;
    private String currSimRst;
    private History history;
    private File fc_dir;

    public void initStructure() {
        this.fstpm = new FstPlotManager();
        this.alphapm = new AlphaPlotManager();
        this.likepm = new LikePlotManager();
        this.lnpdpm = new LnpdPlotManager();
        this.recpm = new RecmbPlotManager();
        this.srpm = new SrPlotManager();
        this.history = new History(this);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        JFrame jFrame = new JFrame("Structure");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StructureApp.this.exit_structure();
            }
        });
        this.projTree = new ProjTree(this);
        this.projTree.initProjTree();
        this.simMenu = new SimListMenu(this);
        this.simMenu.initMenu();
        this.mainFrame = new MainFrame(this);
        jFrame.getContentPane().add("Center", this.mainFrame.createPane(n, n2));
        jFrame.setJMenuBar(this.mainFrame.createMenuBar());
        jFrame.getContentPane().add("North", this.mainFrame.getToolBar());
        this.mainFrame.updateUI(0);
        jFrame.setIconImage(Toolkit.getDefaultToolkit().getImage("images/icon.jpeg"));
        jFrame.pack();
        jFrame.setSize(n, n2);
        jFrame.setVisible(true);
    }

    public JTree getProjTree() {
        return this.projTree.getTree();
    }

    public JMenu getSimMenu() {
        return this.simMenu.getMenu();
    }

    public JMenu getHistoryMenu() {
        return this.history.getHistoryMenu();
    }

    public void exit_structure() {
        if (this.currThread != null && this.currThread.isAlive()) {
            this.currThread.killProc();
        }
        if (this.currProj != null) {
            File file = new File(this.currProj.getWorkingPath(), this.currProj.getName());
            this.history.updateHistory(file.getAbsolutePath(), false);
        }
        this.history.writeHistoryFile();
        System.exit(0);
    }

    public boolean newProject() {
        if (this.currProj == null) {
            this.wizardController = new WizardController(this.mainFrame);
            this.wizardController.initWizard();
            while (!this.wizardController.isDone()) {
            }
            this.currProj = this.wizardController.getProjObj();
            if (this.currProj == null) {
                return false;
            }
            this.currProj.createProjectSpace();
            String[][] stringArray = this.wizardController.getData();
            if (stringArray == null) {
                this.currProj = null;
                return false;
            }
            this.mainFrame.showData(stringArray, this.currProj.getDataTitle(), this.currProj.getGeneName(), this.currProj.getMapDistance(), this.currProj.getRecessiveAllele(), this.currProj.getPhaseInfo(), this.currProj.getOneRow(), this.currProj.getPloidy(), this.currProj.getNumloci());
            String[] stringArray2 = this.currProj.getSimList();
            this.projTree.loadProjTree(this.currProj.getName(), stringArray2);
            this.simMenu.loadMenu(stringArray2);
            this.wizardController = null;
            stringArray = null;
            this.mainFrame.updateUI(this.getCurrState());
            return true;
        }
        return false;
    }

    public boolean openProj() {
        GeneralFileFilter generalFileFilter = new GeneralFileFilter("spj", "Structure Project Files");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(generalFileFilter);
        jFileChooser.setCurrentDirectory(this.fc_dir);
        int n = jFileChooser.showOpenDialog(this.mainFrame);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.fc_dir = file.getParentFile();
            NProjObj nProjObj = ObjIO.loadProjObj(file);
            if (nProjObj == null) {
                return false;
            }
            this.currProj = nProjObj;
            String[][] stringArray = this.currProj.loadData();
            if (stringArray == null) {
                this.currProj = null;
                return false;
            }
            this.mainFrame.showData(stringArray, this.currProj.getDataTitle(), this.currProj.getGeneName(), this.currProj.getRecessiveAllele(), this.currProj.getMapDistance(), this.currProj.getPhaseInfo(), this.currProj.getOneRow(), this.currProj.getPloidy(), this.currProj.getNumloci());
            stringArray = null;
            String[] stringArray2 = this.currProj.getSimList();
            this.projTree.loadProjTree(this.currProj.getName(), stringArray2);
            this.simMenu.loadMenu(stringArray2);
            this.mainFrame.updateUI(this.getCurrState());
            this.setCurrentSelection(null, null);
            return true;
        }
        return false;
    }

    public boolean openProj(String string) {
        Object[] objectArray;
        if (this.currProj != null) {
            objectArray = new Object[]{"Yes", "No "};
            int n = JOptionPane.showOptionDialog(this.mainFrame, "Close current active project?", "Open project", 0, 3, null, objectArray, objectArray[1]);
            if (n == 1) {
                return false;
            }
            this.closeProj();
        }
        objectArray = new File(string);
        this.fc_dir = objectArray.getParentFile();
        NProjObj nProjObj = ObjIO.loadProjObj((File)objectArray);
        if (nProjObj == null) {
            return false;
        }
        this.currProj = nProjObj;
        String[][] stringArray = this.currProj.loadData();
        if (stringArray == null) {
            this.currProj = null;
            return false;
        }
        this.mainFrame.showData(stringArray, this.currProj.getDataTitle(), this.currProj.getGeneName(), this.currProj.getMapDistance(), this.currProj.getRecessiveAllele(), this.currProj.getPhaseInfo(), this.currProj.getOneRow(), this.currProj.getPloidy(), this.currProj.getNumloci());
        stringArray = null;
        String[] stringArray2 = this.currProj.getSimList();
        this.projTree.loadProjTree(this.currProj.getName(), stringArray2);
        this.simMenu.loadMenu(stringArray2);
        this.mainFrame.updateUI(this.getCurrState());
        this.setCurrentSelection(null, null);
        return true;
    }

    public boolean saveProj() {
        this.currProj.writeProjectFile();
        return true;
    }

    public boolean closeProj() {
        File file = new File(this.currProj.getWorkingPath(), this.currProj.getName());
        this.history.updateHistory(file.getAbsolutePath(), true);
        this.currProj.writeProjectFile();
        this.currSim = null;
        this.currProj = null;
        this.projTree.emptyProjTree();
        this.simMenu.emptyMenu();
        this.mainFrame.updateUI(this.getCurrState());
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        return true;
    }

    public boolean newSim() {
        NSimObj nSimObj = new NSimObj(this.currProj);
        this.paramDlg = new ParamDlg(nSimObj);
        this.paramDlg.pack();
        int n = this.paramDlg.showDialog();
        this.paramDlg = null;
        if (n == 0) {
            this.currProj.addSimObj(nSimObj.getSimName());
            this.currProj.writeProjectFile();
            boolean bl = true;
            int n2 = this.getCurrState();
            if (n2 == 3 || n2 == 4) {
                bl = false;
            }
            this.projTree.appendProjTree(nSimObj.getSimName(), bl);
            this.simMenu.appendMenuItem(nSimObj.getSimName(), bl);
            this.projTree.resetSimNodeFlag(this.currProj.getSimList());
            if (bl) {
                this.currSim = nSimObj;
                this.projTree.updateProjTree(this.currSim.getSimName());
                this.mainFrame.updateUI(this.getCurrState());
                this.mainFrame.loadDataFrame("sim", "Simulation Configuration - " + this.currSim.getSimName(), this.currSim.printSimInfo());
            }
            return true;
        }
        if (n == 2) {
            return false;
        }
        return false;
    }

    public boolean loadSimObj(String string) {
        NSimObj nSimObj = ObjIO.loadSimObj(this.currProj, string);
        if (nSimObj == null) {
            return false;
        }
        this.currSim = nSimObj;
        this.projTree.resetSimNodeFlag(this.currProj.getSimList());
        this.projTree.updateProjTree(string);
        this.simMenu.updateMenu(string);
        this.mainFrame.updateUI(this.getCurrState());
        this.mainFrame.loadDataFrame("sim", "Simulation Configuration - " + string, this.currSim.printSimInfo());
        return true;
    }

    public boolean removeSimObj() {
        if (this.currProj == null) {
            return false;
        }
        String[] stringArray = this.currProj.getSimList();
        if (stringArray.length == 0) {
            JOptionPane.showMessageDialog(null, "No Simulations can to be Removed", "Error", 0);
            return false;
        }
        RemoveSimDlg removeSimDlg = new RemoveSimDlg(stringArray);
        int n = removeSimDlg.showDialog();
        if (n == 2) {
            removeSimDlg = null;
            return false;
        }
        Object[] objectArray = removeSimDlg.getSelectedList();
        removeSimDlg = null;
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.currSim != null && this.currSim.getSimName().equals(objectArray[i])) {
                if (this.getCurrState() == 3) {
                    JOptionPane.showMessageDialog(null, "Can not Delete Current Running Simulation", "Error", 0);
                    continue;
                }
                this.projTree.resetSimNodeFlag(this.currProj.getSimList());
                this.simMenu.setActiveFlag(this.currSim.getSimName(), false);
                this.currSim = null;
            }
            if (!this.currProj.removeSimObj((String)objectArray[i])) {
                JOptionPane.showMessageDialog(null, "Delete Simulation " + objectArray[i] + " Failed", "Error", 0);
                continue;
            }
            this.simMenu.removeMenuItem((String)objectArray[i]);
            this.projTree.removeSimNode((String)objectArray[i]);
        }
        this.currProj.writeProjectFile();
        this.mainFrame.updateUI(this.getCurrState());
        return true;
    }

    public boolean simSetting() {
        this.paramDlg = new ParamDlg(this.currSim);
        int n = this.paramDlg.showDialog();
        if (n == 0) {
            this.currSim = this.paramDlg.getSimObj();
            this.mainFrame.loadDataFrame("sim", "Simulation Configuration - " + this.currSim.getSimName(), this.currSim.printSimInfo());
            return true;
        }
        if (n == 2) {
            this.currSim = this.paramDlg.getSimObj();
            return false;
        }
        if (n == 1) {
            NSimObj nSimObj = this.paramDlg.getSimObj();
            this.currProj.addSimObj(nSimObj.getSimName());
            this.currProj.writeProjectFile();
            boolean bl = true;
            int n2 = this.getCurrState();
            if (n2 == 3 || n2 == 4) {
                bl = false;
            }
            this.simMenu.appendMenuItem(this.currSim.getSimName(), bl);
            this.projTree.appendProjTree(this.currSim.getSimName(), bl);
            this.projTree.resetSimNodeFlag(this.currProj.getSimList());
            if (bl) {
                this.currSim = nSimObj;
                this.projTree.updateProjTree(this.currSim.getSimName());
                this.mainFrame.updateUI(this.getCurrState());
                this.mainFrame.loadDataFrame("sim", "Simulation Configuration - " + this.currSim.getSimName(), this.currSim.printSimInfo());
            }
            return true;
        }
        return false;
    }

    public boolean runProc() {
        int n = 0;
        StartRunDlg startRunDlg = new StartRunDlg();
        int n2 = startRunDlg.showDialog();
        if (n2 != 1) {
            return false;
        }
        n = startRunDlg.K;
        int n3 = 1;
        String string = this.currSim.getSimName() + "_run_" + n3;
        while (!this.currSim.setOutFile(string)) {
            string = this.currSim.getSimName() + "_run_" + ++n3;
        }
        this.currSim.setMAXPOPS(n);
        if (startRunDlg.seed_flag == 1) {
            this.currSim.setRNDSEED(startRunDlg.seed);
        }
        this.currSim.writeParamFile();
        this.runningSim = this.currSim;
        String string2 = "bin/structure -m ";
        String string3 = new String(string2 + "\"" + this.currSim.getParamFile() + "\"" + " -e " + "\"" + this.currSim.getExtraFile() + "\"");
        this.currThread = new AppProc(string3, this.mainFrame, this.projTree, this.currSim, true);
        this.currThread.start();
        return true;
    }

    public boolean treePlot() {
        if (this.currProj == null) {
            return false;
        }
        TreePlotManager treePlotManager = new TreePlotManager(this, this.currProj.getSimList(), this.plottingSimName, this.plottingFilePath, this.plotString);
        Integer n = treePlotManager.getK(this.plottingSimName, this.plottingFilePath);
        if (n > 2) {
            treePlotManager.parseDistanceMatrix(this.plottingSimName, this.plottingFilePath);
            treePlotManager.runNeighborAlgorithm(this.plottingSimName, this.plottingFilePath);
            treePlotManager.createTreePlot(this.plottingSimName, this.plottingFilePath);
        } else {
            JOptionPane.showMessageDialog(null, "Requires at least three populations.", "Error", 0);
        }
        return true;
    }

    public boolean treePlotLicense() {
        if (this.currProj == null) {
            return false;
        }
        ta_scroll ta_scroll2 = new ta_scroll();
        ta_scroll2.launchFrame();
        return true;
    }

    public boolean triPlot(int n) {
        if (this.currProj == null) {
            return false;
        }
        if (n == 0) {
            TrianglePlotManager trianglePlotManager = new TrianglePlotManager(this, this.currProj.getSimList());
            trianglePlotManager.showFrame();
        } else if (n == 1) {
            TrianglePlotManager trianglePlotManager = new TrianglePlotManager();
            trianglePlotManager.showFrame(this.plottingSimName, this.plottingFilePath);
        }
        return true;
    }

    public boolean plotStatic(String string) {
        File file = new File(this.currSimDir.getAbsolutePath(), "PlotData");
        String string2 = new String();
        if (string.equals("Fst")) {
            string2 = this.currSimRst + "_fst";
        }
        if (string.equals("Alpha")) {
            string2 = this.currSimRst + "_alpha";
        }
        if (string.equals("r")) {
            string2 = this.currSimRst + "_sr";
        }
        if (string.equals("Like")) {
            string2 = this.currSimRst + "_lhd";
        }
        if (string.equals("LnPD")) {
            string2 = this.currSimRst + "_lnpd";
        }
        if (string.equals("FstHist")) {
            string2 = this.currSimRst + "_fsthist";
        }
        if (string.equals("rHist")) {
            string2 = this.currSimRst + "_srhist";
        }
        if (string.equals("AlphaHist")) {
            string2 = this.currSimRst + "_alphahist";
        }
        if (string.equals("LnpdHist")) {
            string2 = this.currSimRst + "_lnpdhist";
        }
        if (string.equals("LikHist")) {
            string2 = this.currSimRst + "_lhdhist";
        }
        if (string.equals("RecHist")) {
            string2 = this.currSimRst + "_recmbhist";
        }
        if (string.equals("Rec")) {
            string2 = this.currSimRst + "_recmb";
        }
        File file2 = new File(file.getAbsolutePath(), string2);
        PlotData plotData = null;
        if (file2.exists()) {
            plotData = PlotData.loadData(file2.getAbsolutePath());
        }
        if (string.equals("Fst")) {
            if (plotData == null) {
                JOptionPane.showMessageDialog(null, "No fst data available, the simulation assumed\nallele frequencies independent", "Structure Plotting: Fst", 1);
                return false;
            }
            if (plotData != null) {
                this.fstpm.plot(plotData.getDataArray(), this.currSimRst + " of " + this.currSimDir.getName());
            }
            return true;
        }
        if (string.equals("Alpha")) {
            if (plotData == null) {
                JOptionPane.showMessageDialog(null, "No alpha data available. The simulation applied no admixture model", "Structure Plotting: Log Alpha", 1);
                return false;
            }
            if (plotData != null) {
                this.alphapm.plot(plotData.getDataArray(), this.currSimRst + " of " + this.currSimDir.getName());
            }
            return true;
        }
        if (string.equals("Like")) {
            if (plotData != null) {
                this.likepm.plot(plotData.getDataArray(), this.currSimRst + " of " + this.currSimDir.getName());
            }
            return true;
        }
        if (string.equals("r")) {
            if (plotData != null) {
                this.srpm.plot(plotData.getDataArray(), this.currSimRst + " of " + this.currSimDir.getName());
            }
            return true;
        }
        if (string.equals("LnPD")) {
            if (plotData != null) {
                this.lnpdpm.plot(plotData.getDataArray(), this.currSimRst + " of " + this.currSimDir.getName());
            }
            return true;
        }
        if (string.equals("Rec")) {
            if (plotData == null) {
                JOptionPane.showMessageDialog(null, "No recombination rate data  available. This simulation \ndid not apply linkage model", "Structure Plotting: Recombination Rate", 1);
                return false;
            }
            this.recpm.plot(plotData.getDataArray(), this.currSimRst + " of " + this.currSimDir.getName());
            return true;
        }
        if (string.equals("FstHist")) {
            if (plotData == null) {
                JOptionPane.showMessageDialog(null, "No fst data available. The simulation assumed \nallele frequencies independent", "Structure Plotting: Fst", 1);
                return false;
            }
            if (plotData != null) {
                this.fstpm.plotHist(plotData.getDataArray(), this.currSimRst + " of " + this.currSimDir.getName());
            }
            return true;
        }
        if (string.equals("AlphaHist")) {
            if (plotData == null) {
                JOptionPane.showMessageDialog(null, "No alpha data available. The simulation did not\napply admixture model", "Structure Plotting: Log Alpha", 1);
                return false;
            }
            if (plotData != null) {
                this.alphapm.plotHist(plotData.getDataArray(), this.currSimRst + " of " + this.currSimDir.getName());
            }
            return true;
        }
        if (string.equals("RecHist")) {
            if (plotData == null) {
                JOptionPane.showMessageDialog(null, "No recombinant rate data available. The simulation did not\napply linkage model", "Structure Plotting", 1);
                return false;
            }
            this.recpm.plotHist(plotData.getDataArray(), this.currSimRst + " of " + this.currSimDir.getName());
            return true;
        }
        if (string.equals("rHist")) {
            if (plotData == null) {
                JOptionPane.showMessageDialog(null, "No r data available", "Structure Plotting", 1);
                return false;
            }
            this.srpm.plotHist(plotData.getDataArray(), this.currSimRst + " of " + this.currSimDir.getName());
            return true;
        }
        if (string.equals("LikHist")) {
            if (plotData == null) {
                JOptionPane.showMessageDialog(null, "No likihood data available", "Structure Plotting", 1);
                return false;
            }
            this.likepm.plotHist(plotData.getDataArray(), this.currSimRst + " of " + this.currSimDir.getName());
            return true;
        }
        if (string.equals("LnpdHist")) {
            if (plotData == null) {
                JOptionPane.showMessageDialog(null, "No ln P(D) data available", "Structure Plotting", 1);
                return false;
            }
            this.lnpdpm.plotHist(plotData.getDataArray(), this.currSimRst + " of " + this.currSimDir.getName());
            return true;
        }
        return false;
    }

    public boolean plotDynamic(String string) {
        if (string.equals("Fst")) {
            if (!this.runningSim.FREQSCORR) {
                JOptionPane.showMessageDialog(null, "The simulation assumes allele frequencies independent", "Structure Plotting: Fst", 1);
                return false;
            }
            this.fstpm.plot(this.currThread, this.runningSim.ONEFST, this.runningSim.getMAXPOPS());
            return true;
        }
        if (string.equals("Alpha")) {
            if (this.runningSim.NOADMIX && !this.runningSim.RECOMBINE && this.runningSim.POPNOADMIX && this.runningSim.POPRECOMBINE) {
                JOptionPane.showMessageDialog(null, "The simulation is using no admixture model", "Structure Plotting: Log Alpha", 1);
                return false;
            }
            this.alphapm.plot(this.currThread, this.runningSim.POPALPHAS, this.runningSim.getMAXPOPS());
            return true;
        }
        if (string.equals("r")) {
            if (!this.runningSim.LOCPRIOR) {
                JOptionPane.showMessageDialog(null, "The simulation is not using LOCPRIOR model", "Structure Plotting: r", 1);
                return false;
            }
            this.srpm.plot(this.currThread);
            return true;
        }
        if (string.equals("Like")) {
            if (!this.runningSim.COMPUTEPROB) {
                JOptionPane.showMessageDialog(null, "No likelihood data available", "Structure Plotting: Log Alpha", 1);
                return false;
            }
            this.likepm.plot(this.currThread);
            return true;
        }
        if (string.equals("LnPD")) {
            if (!this.runningSim.COMPUTEPROB) {
                JOptionPane.showMessageDialog(null, "No Ln P(D) data available", "Structure Plotting: Log Alpha", 1);
                return false;
            }
            if (!this.currThread.isBurinFinished()) {
                JOptionPane.showMessageDialog(null, "Burnin is not finished, no Ln P(D) data available at this moment", "Structure Plotting: Ln P(D)", 1);
                return false;
            }
            this.lnpdpm.plot(this.currThread);
            return true;
        }
        if (string.equals("Rec")) {
            if (!this.runningSim.RECOMBINE && !this.runningSim.POPRECOMBINE) {
                JOptionPane.showMessageDialog(null, "The simulation is not using linkage model", "Structure Plotting: Recombination Rate", 1);
                return false;
            }
            if (!this.currThread.isRecStarted()) {
                JOptionPane.showMessageDialog(null, "\"NO Recombination Burnin\" is not finished,\nno data available at this moment", "Structure Plotting: Recombination Rate", 1);
                return false;
            }
            this.recpm.plot(this.currThread);
            return true;
        }
        if (string.equals("AlphaHist") || string.equals("FstHist") || string.equals("LikHist") || string.equals("LnpdHist") || string.equals("RecHist")) {
            JOptionPane.showMessageDialog(null, "Simulation is not finished, can not plot histogram", "Structure Plotting", 1);
        }
        return false;
    }

    public boolean stopProc() {
        if (this.currThread != null) {
            this.currThread.killProc();
            this.currThread = null;
        }
        this.mainFrame.getConsole().append("\n\nSimulation Interrupted!");
        return true;
    }

    public void startJob() {
        boolean bl;
        String[] stringArray;
        if (this.currProj == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String[] stringArray2 = this.currProj.getSimList();
        if (stringArray2 == null || stringArray2.length == 0) {
            return;
        }
        SchedulerDlg schedulerDlg = new SchedulerDlg(stringArray2);
        int n5 = schedulerDlg.showDialog();
        if (n5 == 0) {
            stringArray = schedulerDlg.getSelectedList();
            n = schedulerDlg.getIterationNum();
            n2 = schedulerDlg.getFromK();
            n3 = schedulerDlg.getToK();
            bl = schedulerDlg.isSeedRequired();
            n4 = schedulerDlg.getSeed();
            if (stringArray == null) {
                return;
            }
        } else {
            return;
        }
        schedulerDlg = null;
        this.jobManager = new JobManager(this, this.currProj, stringArray, n, n2, n3, this.mainFrame, this.projTree, bl, n4);
        this.jobManager.start();
        this.jobManager.showLog();
        this.outOfControl = true;
    }

    void returnControl() {
        this.outOfControl = false;
    }

    void setRunningInstance(AppProc appProc, NSimObj nSimObj) {
        this.currThread = appProc;
        this.runningSim = nSimObj;
    }

    public void showJobLog() {
        if (this.jobManager == null) {
            return;
        }
        this.jobManager.showLog();
    }

    public void killJob() {
        if (this.jobManager == null || !this.jobManager.isAlive()) {
            return;
        }
        this.jobManager.killJob();
    }

    public void genParamFiles() {
        if (this.currProj == null) {
            return;
        }
        String[] stringArray = this.currProj.getSimList();
        if (stringArray == null) {
            return;
        }
        PFGenManager pFGenManager = new PFGenManager(this, this.currProj, stringArray);
    }

    public void loadOutsideRst() {
        RstLoader rstLoader = new RstLoader();
    }

    public File[] getRunFiles(String string) {
        if (this.currProj == null) {
            return null;
        }
        File file = new File(this.currProj.getWorkingPath(), string);
        if (!file.exists()) {
            return null;
        }
        File file2 = new File(file.getAbsolutePath(), "Results");
        if (!file2.exists()) {
            return null;
        }
        File[] fileArray = file2.listFiles();
        if (fileArray == null) {
            return null;
        }
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getName();
            if (!string2.endsWith("_f")) continue;
            vector.add(fileArray[i]);
        }
        if (vector.size() == 0) {
            return null;
        }
        File[] fileArray2 = new File[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            fileArray2[i] = (File)vector.elementAt(i);
        }
        return fileArray2;
    }

    public String[] getRstFiles(String string) {
        if (this.currProj == null) {
            return null;
        }
        File file = new File(this.currProj.getWorkingPath(), string);
        if (!file.exists()) {
            return null;
        }
        File file2 = new File(file.getAbsolutePath(), "Results");
        if (!file2.exists()) {
            return null;
        }
        File[] fileArray = file2.listFiles();
        if (fileArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2;
            String string3;
            block12: {
                String string4;
                string3 = fileArray[i].getName();
                string2 = "";
                if (!string3.endsWith("_f")) continue;
                DataInputStream dataInputStream = null;
                try {
                    dataInputStream = new InFile(fileArray[i].getAbsolutePath());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                do {
                    string4 = null;
                    try {
                        string4 = dataInputStream.readLine();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string4 == null) break block12;
                } while (!string4.endsWith("populations assumed"));
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                string2 = stringTokenizer.nextToken();
            }
            vector.addElement(string3.substring(0, string3.length() - 2) + " ( K=" + string2 + " )");
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public void appendRstToTree(String string, String string2, int n) {
        this.projTree.appendRstNode(string, string2, n);
    }

    public void setCurrentSelection(File file, String string) {
        this.currSimDir = file;
        this.currSimRst = string;
    }

    public int getCurrState() {
        if (this.outOfControl) {
            return 4;
        }
        if (this.currProj == null) {
            return 0;
        }
        if (this.currSim == null) {
            return 1;
        }
        if (this.currThread == null) {
            return 2;
        }
        if (this.currThread.isAlive()) {
            return 3;
        }
        return 2;
    }

    public void showResults(String string, String string2) {
        Object object;
        Object object2;
        Object object3;
        if (this.currProj == null) {
            return;
        }
        File file = new File(this.currProj.getWorkingPath(), string);
        if (!file.exists()) {
            return;
        }
        File file2 = new File(file.getAbsolutePath(), "Results");
        if (!file2.exists()) {
            return;
        }
        File file3 = new File(file2.getAbsolutePath(), string2 + "_f");
        if (!file3.exists()) {
            return;
        }
        File file4 = new File(file.getAbsolutePath(), "PlotData");
        this.setCurrentSelection(file, string2);
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "";
        try {
            int n;
            object3 = new FileInputStream(file3.getAbsolutePath());
            object2 = new InputStreamReader((InputStream)object3, "UTF8");
            object = new BufferedReader((Reader)object2);
            while ((n = ((Reader)object).read()) > -1) {
                stringBuffer.append((char)n);
            }
            ((Reader)object).close();
            string3 = stringBuffer.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object3 = new JMenuBar();
        object2 = new JMenu("Bar plot");
        object = new JMenuItem("Show");
        ((AbstractButton)object).setActionCommand("barplot");
        ((AbstractButton)object).addActionListener(this.mainFrame);
        ((JMenu)object2).add((JMenuItem)object);
        JMenu jMenu = new JMenu("Data plot");
        JMenuItem jMenuItem = new JMenuItem("Fst");
        if (new File(file4, string2 + "_fst").exists()) {
            jMenuItem.setActionCommand("sviewfst");
            jMenuItem.addActionListener(this.mainFrame);
        } else {
            jMenuItem.setEnabled(false);
        }
        JMenuItem jMenuItem2 = new JMenuItem("Alpha");
        if (new File(file4, string2 + "_alpha").exists()) {
            jMenuItem2.setActionCommand("sviewalpha");
            jMenuItem2.addActionListener(this.mainFrame);
        } else {
            jMenuItem2.setEnabled(false);
        }
        JMenuItem jMenuItem3 = new JMenuItem("Recombination rate");
        if (new File(file4, string2 + "_recmb").exists()) {
            jMenuItem3.setActionCommand("sviewrec");
            jMenuItem3.addActionListener(this.mainFrame);
        } else {
            jMenuItem3.setEnabled(false);
        }
        JMenuItem jMenuItem4 = new JMenuItem("r (LOCPRIOR model)");
        if (new File(file4, string2 + "_sr").exists()) {
            jMenuItem4.setActionCommand("sviewr");
            jMenuItem4.addActionListener(this.mainFrame);
        } else {
            jMenuItem4.setEnabled(false);
        }
        JMenuItem jMenuItem5 = new JMenuItem("Likelihood");
        if (new File(file4, string2 + "_lhd").exists()) {
            jMenuItem5.setActionCommand("sviewlike");
            jMenuItem5.addActionListener(this.mainFrame);
        } else {
            jMenuItem5.setEnabled(false);
        }
        JMenuItem jMenuItem6 = new JMenuItem("Ln P(D) ");
        if (new File(file4, string2 + "_lnpd").exists()) {
            jMenuItem6.setActionCommand("sviewlnpd");
            jMenuItem6.addActionListener(this.mainFrame);
        } else {
            jMenuItem6.setEnabled(false);
        }
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        jMenu.add(jMenuItem5);
        jMenu.add(jMenuItem6);
        JMenu jMenu2 = new JMenu("Histogram");
        JMenuItem jMenuItem7 = new JMenuItem("Fst");
        if (new File(file4, string2 + "_fsthist").exists()) {
            jMenuItem7.setActionCommand("histfst");
            jMenuItem7.addActionListener(this.mainFrame);
        } else {
            jMenuItem7.setEnabled(false);
        }
        JMenuItem jMenuItem8 = new JMenuItem("Alpha");
        if (new File(file4, string2 + "_alphahist").exists()) {
            jMenuItem8.setActionCommand("histalpha");
            jMenuItem8.addActionListener(this.mainFrame);
        } else {
            jMenuItem8.setEnabled(false);
        }
        JMenuItem jMenuItem9 = new JMenuItem("Recombination rate");
        if (new File(file4, string2 + "_recmbhist").exists()) {
            jMenuItem9.setActionCommand("histrec");
            jMenuItem9.addActionListener(this.mainFrame);
        } else {
            jMenuItem9.setEnabled(false);
        }
        JMenuItem jMenuItem10 = new JMenuItem("r (LOCPRIOR model)");
        if (new File(file4, string2 + "_srhist").exists()) {
            jMenuItem10.setActionCommand("histr");
            jMenuItem10.addActionListener(this.mainFrame);
        } else {
            jMenuItem10.setEnabled(false);
        }
        JMenuItem jMenuItem11 = new JMenuItem("Likelihood");
        if (new File(file4, string2 + "_lhdhist").exists()) {
            jMenuItem11.setActionCommand("histlike");
            jMenuItem11.addActionListener(this.mainFrame);
        } else {
            jMenuItem11.setEnabled(false);
        }
        JMenuItem jMenuItem12 = new JMenuItem("Ln P(D) ");
        if (new File(file4, string2 + "_lnpdhist").exists()) {
            jMenuItem12.setActionCommand("histlnpd");
            jMenuItem12.addActionListener(this.mainFrame);
        } else {
            jMenuItem12.setEnabled(false);
        }
        jMenu2.add(jMenuItem7);
        jMenu2.add(jMenuItem8);
        jMenu2.add(jMenuItem9);
        jMenu2.add(jMenuItem10);
        jMenu2.add(jMenuItem11);
        jMenu2.add(jMenuItem12);
        JMenu jMenu3 = new JMenu("Tree plot");
        JMenuItem jMenuItem13 = new JMenuItem("Show");
        JMenuItem jMenuItem14 = new JMenuItem("Information and credit");
        jMenuItem13.setActionCommand("treeplot");
        jMenuItem14.setActionCommand("treePlotLicense");
        jMenuItem13.addActionListener(this.mainFrame);
        jMenuItem14.addActionListener(this.mainFrame);
        jMenu3.add(jMenuItem13);
        jMenu3.add(jMenuItem14);
        JMenu jMenu4 = new JMenu("Triangle plot");
        JMenuItem jMenuItem15 = new JMenuItem("Show");
        jMenuItem15.setActionCommand("triplot");
        jMenuItem15.addActionListener(this.mainFrame);
        jMenu4.add(jMenuItem15);
        ((JMenuBar)object3).add((JMenu)object2);
        ((JMenuBar)object3).add(jMenu);
        ((JMenuBar)object3).add(jMenu2);
        ((JMenuBar)object3).add(jMenu4);
        ((JMenuBar)object3).add(jMenu3);
        this.mainFrame.setRstMenu((JMenuBar)object3);
        this.mainFrame.loadDataFrame("result", "Simulation Result: " + string + "(" + string2 + ")", string3);
        this.plottingFilePath = file3.getAbsolutePath();
        this.plottingSimName = string;
        this.plotString = string + "(" + string2 + ")";
    }

    public void loadBarPlot() {
        if (this.rpm != null) {
            this.rpm.dispose();
            this.rpm = null;
        }
        this.rpm = new RstPlotManager(this.mainFrame, this.plottingFilePath, this.plotString);
    }

    public void loadSummary() {
        if (this.currProj == null) {
            return;
        }
        SummaryGenerator summaryGenerator = new SummaryGenerator(this.currProj);
        JInternalFrame jInternalFrame = summaryGenerator.getSummary();
        if (jInternalFrame == null) {
            JOptionPane.showMessageDialog(null, "No Summary Information Available", "Error", 0);
            return;
        }
        this.mainFrame.loadSummaryFrame(jInternalFrame, "Summary of Project " + this.currProj.getName());
    }

    public void loadDataFrame(String string, String string2) {
        if (string.equals("proj")) {
            this.mainFrame.loadDataFrame("proj", "Project Information - " + this.currProj.getName(), this.currProj.printProjInfo());
            return;
        }
        if (string.equals("data")) {
            this.mainFrame.loadDataFrame("data", "", "");
            return;
        }
        if (string.equals("sim")) {
            if (string2 != null) {
                NSimObj nSimObj = ObjIO.loadSimObj(this.currProj, string2);
                if (nSimObj == null) {
                    return;
                }
                if (nSimObj != null) {
                    this.mainFrame.loadDataFrame("sim", "Simulation Configuration - " + string2, nSimObj.printSimInfo());
                }
                nSimObj = null;
            } else if (this.currSim != null) {
                this.mainFrame.loadDataFrame("sim", "Simulation Configuration - " + this.currSim.getSimName(), this.currSim.printSimInfo());
            }
            return;
        }
    }
}

