/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import Plot.HistPlot;
import Plot.Plot;
import Proc.AppProc;
import Util.GeneralFileFilter;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import jas.hist.JASHist;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FstPlotManager {
    private JFrame target;
    Plot[] stg;
    JASHist[] sth;
    private int dataset;
    private AppProc proc;
    private ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FstPlotManager.this.saveCurveImage(Integer.parseInt(actionEvent.getActionCommand()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private ActionListener hlistener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FstPlotManager.this.saveHistImage(Integer.parseInt(actionEvent.getActionCommand()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public void plot(double[][] dArray, String string) {
        JPanel jPanel;
        this.dataset = dArray.length;
        this.stg = new Plot[this.dataset];
        if (this.dataset == 1) {
            this.stg[0] = new Plot(dArray[0], "Fst", "Fst Vs. Iterations");
        } else {
            for (int i = 0; i < this.dataset; ++i) {
                this.stg[i] = new Plot(dArray[i], "Fst", "Fst" + (i + 1) + " Vs. Iterations");
            }
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        for (int i = 0; i < this.dataset; ++i) {
            jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.stg[i], "Center");
            JButton jButton = new JButton("Save image");
            jButton.addActionListener(this.listener);
            jButton.setActionCommand("" + i);
            JPanel jPanel3 = new JPanel();
            jPanel3.add(jButton);
            jPanel.add((Component)jPanel3, "South");
            jPanel2.add(jPanel);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setBackground(Color.white);
        if (this.dataset > 1) {
            jScrollPane.setPreferredSize(new Dimension(500, 500));
        } else {
            jScrollPane.setPreferredSize(new Dimension(500, 350));
        }
        if (this.target != null) {
            this.target.dispose();
        }
        this.target = new JFrame("Structure Plotting: Fst - " + string);
        this.target.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FstPlotManager.this.target.setVisible(false);
            }
        });
        jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(500, 20));
        this.target.getContentPane().add("North", jPanel);
        this.target.getContentPane().add("Center", jScrollPane);
        this.target.setLocation(300, 200);
        this.target.pack();
        this.target.setVisible(true);
    }

    public void plot(AppProc appProc, boolean bl, int n) {
        this.proc = appProc;
        this.dataset = n;
        if (bl) {
            n = 1;
        }
        final Plot[] plotArray = new Plot[n];
        if (bl) {
            plotArray[0] = new Plot(appProc, "Fst", 0, "Fst Vs. Iterations");
        } else {
            for (int i = 0; i < n; ++i) {
                plotArray[i] = new Plot(appProc, "Fst", i, "Fst" + (i + 1) + " Vs. Iterations");
            }
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        for (int i = 0; i < n; ++i) {
            jPanel.add(plotArray[i]);
            plotArray[i].start();
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setPreferredSize(new Dimension(550, 500));
        if (this.target != null) {
            this.target.dispose();
        }
        this.target = new JFrame("Structure Plotting: Fst");
        this.target.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                for (int i = 0; i < plotArray.length; ++i) {
                    if (plotArray[i] != null) {
                        plotArray[i].stop();
                    }
                    FstPlotManager.this.target.setVisible(false);
                }
            }
        });
        this.target.setLocation(300, 200);
        this.target.getContentPane().add(jScrollPane);
        this.target.pack();
        this.target.setVisible(true);
    }

    public void plotHist(double[][] dArray, String string) {
        this.dataset = dArray.length;
        HistPlot[] histPlotArray = new HistPlot[this.dataset];
        if (this.dataset == 1) {
            histPlotArray[0] = new HistPlot(dArray[0], "Fst", "Histogram of Distribution of Fst");
        } else {
            for (int i = 0; i < this.dataset; ++i) {
                histPlotArray[i] = new HistPlot(dArray[i], "Fst", "Histogram of Distribution of Fst" + (i + 1));
            }
        }
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new GridLayout(0, 1));
        this.sth = new JASHist[this.dataset];
        for (int i = 0; i < this.dataset; ++i) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(Color.white);
            this.sth[i] = histPlotArray[i].draw();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)this.sth[i], "Center");
            JButton jButton = new JButton("Save image");
            jButton.addActionListener(this.hlistener);
            jButton.setActionCommand("" + i);
            JPanel jPanel3 = new JPanel();
            jPanel3.add(jButton);
            jPanel2.add((Component)jPanel3, "South");
            jPanel.add(jPanel2);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        if (this.dataset > 1) {
            jScrollPane.setPreferredSize(new Dimension(500, 600));
        } else {
            jScrollPane.setPreferredSize(new Dimension(500, 350));
        }
        if (this.target != null) {
            this.target.dispose();
        }
        this.target = new JFrame("Histogram of Distribution of Fst - " + string);
        this.target.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FstPlotManager.this.target.setVisible(false);
            }
        });
        this.target.setLocation(300, 200);
        this.target.getContentPane().add(jScrollPane);
        this.target.pack();
        this.target.setVisible(true);
    }

    protected void saveCurveImage(int n) {
        Object[] objectArray;
        Object object;
        Serializable serializable;
        String string = "";
        JFileChooser jFileChooser = new JFileChooser();
        GeneralFileFilter generalFileFilter = new GeneralFileFilter("jpg", "JPEG image files");
        jFileChooser.addChoosableFileFilter(generalFileFilter);
        int n2 = jFileChooser.showDialog(this.target, "Save");
        if (n2 == 0) {
            serializable = jFileChooser.getSelectedFile();
            object = ((File)serializable).getAbsolutePath();
            if (!((String)object).endsWith(".jpg") && !((String)object).endsWith(".jpeg")) {
                serializable = new File(new String((String)object + ".jpg"));
            }
            if (((File)serializable).exists()) {
                objectArray = new Object[]{"Yes", "No "};
                int n3 = JOptionPane.showOptionDialog(this.target, "Target file " + ((File)serializable).getName() + " already exists, Overwrite it?", "Save image", 0, 3, null, objectArray, objectArray[1]);
                if (n3 == 1) {
                    return;
                }
            }
            if (!(objectArray = ((File)serializable).getParentFile()).canWrite()) {
                JOptionPane.showMessageDialog(null, "Can not write image file: permission denied", "Error", 0);
                return;
            }
            string = ((File)serializable).getAbsolutePath();
        }
        serializable = this.stg[n].getBounds();
        object = new BufferedImage(((Rectangle)serializable).width, ((Rectangle)serializable).height, 1);
        objectArray = (Graphics2D)((BufferedImage)object).getGraphics();
        objectArray.setBackground(Color.white);
        objectArray.setPaint(Color.white);
        objectArray.fill((Shape)((Object)serializable));
        this.stg[n].getComponent(0).paint((Graphics)objectArray);
        try {
            File file = new File(string);
            JimiRasterImage jimiRasterImage = Jimi.createRasterImage(((BufferedImage)object).getSource());
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fileOutputStream != null) {
                Jimi.putImage("image/jpeg", (JimiImage)jimiRasterImage, (OutputStream)fileOutputStream);
            }
        }
        catch (JimiException jimiException) {
            jimiException.printStackTrace();
        }
    }

    protected void saveHistImage(int n) {
        Object[] objectArray;
        Object object;
        Serializable serializable;
        String string = "";
        JFileChooser jFileChooser = new JFileChooser();
        GeneralFileFilter generalFileFilter = new GeneralFileFilter("jpg", "JPEG image files");
        jFileChooser.addChoosableFileFilter(generalFileFilter);
        int n2 = jFileChooser.showDialog(this.target, "Save");
        if (n2 == 0) {
            serializable = jFileChooser.getSelectedFile();
            object = ((File)serializable).getAbsolutePath();
            if (!((String)object).endsWith(".jpg") && !((String)object).endsWith(".jpeg")) {
                serializable = new File(new String((String)object + ".jpg"));
            }
            if (((File)serializable).exists()) {
                objectArray = new Object[]{"Yes", "No "};
                int n3 = JOptionPane.showOptionDialog(this.target, "Target file " + ((File)serializable).getName() + " already exists, Overwrite it?", "Save image", 0, 3, null, objectArray, objectArray[1]);
                if (n3 == 1) {
                    return;
                }
            }
            if (!(objectArray = ((File)serializable).getParentFile()).canWrite()) {
                JOptionPane.showMessageDialog(null, "Can not write image file: permission denied", "Error", 0);
                return;
            }
            string = ((File)serializable).getAbsolutePath();
        }
        serializable = this.sth[n].getBounds();
        object = new BufferedImage(((Rectangle)serializable).width, ((Rectangle)serializable).height, 1);
        objectArray = (Graphics2D)((BufferedImage)object).getGraphics();
        objectArray.setBackground(Color.white);
        this.sth[n].paint((Graphics)objectArray);
        try {
            File file = new File(string);
            JimiRasterImage jimiRasterImage = Jimi.createRasterImage(((BufferedImage)object).getSource());
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fileOutputStream != null) {
                Jimi.putImage("image/jpeg", (JimiImage)jimiRasterImage, (OutputStream)fileOutputStream);
            }
        }
        catch (JimiException jimiException) {
            jimiException.printStackTrace();
        }
    }
}

