/*
 * Decompiled with CFR 0.152.
 */
package Triangle;

import Triangle.Triangle;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class TrianglePlot
extends JPanel {
    private Triangle tra = new Triangle(200.0, 220.0, 320.0);
    private double[][] pointData;
    private int[] id;
    private boolean useIdInfo;
    private Hashtable colormap;
    private int leftindex;
    private int rightindex;

    public TrianglePlot() {
        this.setPreferredSize(new Dimension(420, 380));
        this.setBackground(Color.white);
        this.setFont(new Font("TimesRoman", 2, 14));
        this.setBorder(new LineBorder(Color.black, 2));
    }

    public void resetData() {
        this.pointData = null;
        this.useIdInfo = false;
        this.colormap = null;
        this.id = null;
        this.rightindex = -1;
        this.leftindex = -1;
    }

    public void loadData(double[][] dArray, int[] nArray, Hashtable hashtable, int n, int n2) {
        this.pointData = dArray;
        this.id = nArray;
        if (nArray != null) {
            this.useIdInfo = true;
        }
        this.colormap = hashtable;
        this.leftindex = n - 1;
        this.rightindex = n2 - 1;
    }

    private AlphaComposite makeComposite(float f) {
        int n = 3;
        return AlphaComposite.getInstance(n, f);
    }

    public void paintComponent(Graphics graphics) {
        this.clear(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.pointData != null) {
            graphics2D.setComposite(this.makeComposite(1.0f));
            for (int i = 0; i < this.pointData[0].length; ++i) {
                if (!this.useIdInfo) {
                    this.drawPoint(graphics2D, this.pointData[this.rightindex][i], this.pointData[this.leftindex][i], (Color)this.colormap.get(new Integer(0)));
                    continue;
                }
                this.drawPoint(graphics2D, this.pointData[this.rightindex][i], this.pointData[this.leftindex][i], (Color)this.colormap.get(new Integer(this.id[i])));
            }
            graphics2D.setColor(Color.black);
            graphics2D.drawString("Cluster " + (this.leftindex + 1), (int)(this.tra.getOffsetX() - 35.0), (int)(this.tra.getOffsetY() + 25.0));
            graphics2D.drawString("Cluster " + (this.rightindex + 1), (int)(this.tra.getOffsetX() + this.tra.getLength() - 35.0), (int)(this.tra.getOffsetY() + 25.0));
            graphics2D.drawString("All others", (int)(this.tra.getOffsetX() + this.tra.getLength() / 2.0 - 25.0), (int)(this.tra.getOffsetY() - 1.732 * this.tra.getLength() / 2.0 - 12.0));
        }
        graphics2D.draw(new Triangle(200.0, 218.0, 340.0));
    }

    private void drawPoint(Graphics2D graphics2D, double d, double d2, Color color) {
        if (color == null) {
            graphics2D.setPaint(Color.black);
        } else {
            graphics2D.setPaint(color);
        }
        graphics2D.fill(this.getPoint(d, d2));
    }

    private Ellipse2D.Double getPoint(double d, double d2) {
        double d3 = this.tra.getLength() * 1.7321 / 2.0;
        double d4 = 1.0 - d - d2;
        double d5 = d;
        double d6 = -d4 * d3 + this.tra.getOffsetY();
        double d7 = (2.0 * d5 + d4) / 1.7321 * d3 + this.tra.getOffsetX();
        return new Ellipse2D.Double((int)(d7 - 4.0), (int)(d6 - 4.0), 8.0, 8.0);
    }

    protected void clear(Graphics graphics) {
        super.paintComponent(graphics);
    }

    protected void saveImage(String string) {
        BufferedImage bufferedImage = new BufferedImage(420, 380, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        this.paint(graphics2D);
        try {
            File file = new File(string);
            JimiRasterImage jimiRasterImage = Jimi.createRasterImage(bufferedImage.getSource());
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fileOutputStream != null) {
                Jimi.putImage("image/jpeg", (JimiImage)jimiRasterImage, (OutputStream)fileOutputStream);
            }
        }
        catch (JimiException jimiException) {
            jimiException.printStackTrace();
        }
    }
}

